/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.impex.workflow;

import com.vmware.dr.ui.tools.reactive.Promise;
import com.vmware.dr.ui.tools.reactive.impl.Promises;
import com.vmware.srm.client.impex.tool.SrmServersDataWrapper;
import com.vmware.srm.client.impex.workflow.TopologyCreator;
import com.vmware.srm.client.impex.workflow.UserInteractor;
import com.vmware.srm.client.infrastructure.tuple.Tuple2;
import com.vmware.srm.client.topology.client.Topology;
import com.vmware.srm.client.topology.client.view.availability.PairSetup;
import com.vmware.srm.client.topology.client.view.availability.srm.SrmPairSetup;
import com.vmware.srm.client.topology.client.view.availability.srm.SrmServer;
import com.vmware.srm.client.topology.client.view.availability.srm.SrmServersView;
import com.vmware.srm.client.topology.client.vmomi.availability.srm.SrmService;
import com.vmware.srm.client.topology.impl.core.TopologyImpl;
import com.vmware.srm.client.topology.impl.core.operations.faults.ProviderNotAuthenticatedException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class SrmTopologyCreator
extends TopologyCreator {
    static final SrmTopologyCreator instance = new SrmTopologyCreator();

    public static TopologyCreator getInstance() {
        return instance;
    }

    private SrmTopologyCreator() {
    }

    @Override
    public Promise<SrmPairSetup> selectServerPair(boolean isImport, TopologyImpl topology) {
        return this.promptForServer(topology).thenCompose(localGuid -> this.loginRemote(topology, (String)localGuid).thenCompose(remoteGuid -> this.doRemoteSiteLogin(isImport, topology, (String)localGuid).thenCombine(this.doRemoteSiteLogin(isImport, topology, (String)remoteGuid), (u1, u2) -> topology).thenCompose(unused -> ((SrmServersView)topology.getView()).getSrmBy(localGuid).thenCompose(SrmServer::getPair))));
    }

    private Promise<Void> doRemoteSiteLogin(boolean isImport, TopologyImpl topology, String guid) {
        if (isImport) {
            return SrmTopologyCreator.doRemoteSiteLogin((Topology)topology, guid);
        }
        return Promises.resolve(null);
    }

    public static Promise<SrmServersDataWrapper> createWrapper(TopologyImpl topology, PairSetup<SrmServer> pairSetup) {
        UserInteractor.getIoHelper().writeln("Collecting data...");
        SrmServersView view = (SrmServersView)topology.getView();
        Promise remoteServerPromise = view.getSrmBy(pairSetup.pairServerGuid());
        return remoteServerPromise.thenCompose(remoteServer -> remoteServer.getPair().thenCompose(remotePair -> SrmTopologyCreator.getSrmServersData(view, (SrmPairSetup)pairSetup, remotePair)));
    }

    protected Promise<String> promptForServer(TopologyImpl topology) {
        return this.buildLocalServeryGuid((SrmServersView)topology.getView()).thenCompose(map -> {
            if (map.isEmpty()) {
                return Promises.reject((Exception)new RuntimeException("No SRM servers available."));
            }
            return UserInteractor.getInputWaiter().promptForSrmServer((Map<String, String>)map);
        });
    }

    protected Promise<Map<String, String>> buildLocalServeryGuid(SrmServersView serversView) {
        return serversView.getLocalSrmServers().flatMap(srm -> SrmTopologyCreator.from(srm.getPair())).filter(Objects::nonNull).map(PairSetup::server).flatMap(srm -> SrmTopologyCreator.from(srm.getName().thenApply(name -> new Tuple2((Object)srm.guid(), name)))).reduce(new HashMap(), (map, tuple) -> {
            map.put((String)tuple.getFirst(), (String)tuple.getSecond());
            return map;
        });
    }

    protected Promise<String> loginRemote(TopologyImpl topology, String localSrmGuid) {
        return ((SrmServersView)topology.getView()).getSrmBy(localSrmGuid).materialize().thenCompose(promiseResult -> {
            if (promiseResult.isSuccessful()) {
                return ((SrmServer)promiseResult.getResult()).getPair();
            }
            Exception error = promiseResult.getError();
            if (error instanceof ClassCastException) {
                return Promises.reject((Exception)new RuntimeException(String.format("Provided local SRM guid is not valid: '%s'.", localSrmGuid)));
            }
            return Promises.reject((Exception)error);
        }).thenApply(pairSetup -> {
            if (pairSetup == null) {
                throw new RuntimeException("No pair setup found.");
            }
            return pairSetup;
        }).thenCompose(pairSetup -> pairSetup.getPairServer().materialize().thenCompose(pr -> {
            if (pr.isSuccessful()) {
                return Promises.resolve((Object)((SrmServer)pr.getResult()).guid());
            }
            if (!(pr.getError() instanceof PairSetup.PairSetupException)) {
                return Promises.reject((Exception)pr.getError());
            }
            PairSetup.PairSetupException pse = (PairSetup.PairSetupException)pr.getError();
            if (!(pse.getCause() instanceof ProviderNotAuthenticatedException)) {
                return Promises.reject((Exception)pr.getError());
            }
            Promise loginRemotePromise = UserInteractor.getInputWaiter().promptForUsingRemoteKeyStore(pairSetup.pairServerName()).thenCompose(useRemoteKeyStore -> useRemoteKeyStore != false ? SrmTopologyCreator.loginRemoteWithKeyStore(topology, pairSetup) : SrmTopologyCreator.loginRemoteWithCreds(topology, pairSetup));
            return loginRemotePromise.materialize().thenCompose(innerPr -> {
                if (innerPr.isSuccessful()) {
                    return Promises.resolve((Object)pairSetup.pairServerGuid());
                }
                Exception innerCause = innerPr.getError();
                if (innerCause instanceof Topology.LoginFailedException) {
                    UserInteractor.getIoHelper().writeln("Invalid credentials.");
                    return this.loginRemote(topology, localSrmGuid);
                }
                return Promises.reject((Exception)new RuntimeException("Unable to complete remote login. Reason: " + innerCause.getMessage(), innerCause));
            });
        }));
    }

    private static Promise<SrmServersDataWrapper> getSrmServersData(SrmServersView view, SrmPairSetup localPair, SrmPairSetup remotePair) {
        SrmServer localSrmServer = (SrmServer)localPair.server();
        Promise localContentPromise = ((SrmService)localSrmServer.service()).getContent();
        SrmServer remoteSrmServer = (SrmServer)remotePair.server();
        Promise remoteContentPromise = ((SrmService)remoteSrmServer.service()).getContent();
        return localContentPromise.thenCombine(remoteContentPromise, (localContent, remoteContent) -> new SrmServersDataWrapper(view, localPair, remotePair, localContent, remoteContent));
    }
}

