/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.core;

import com.vmware.vapi.core.AsyncHandle;
import com.vmware.vapi.core.Consumer;
import com.vmware.vapi.data.DataValue;
import com.vmware.vapi.data.ErrorValue;

public class MethodResult {
    public static final MethodResult EMPTY = new MethodResult();
    private DataValue output;
    private ErrorValue error;
    private Consumer<AsyncHandle<MethodResult>> next;

    private MethodResult() {
    }

    public MethodResult(DataValue output, ErrorValue error) {
        this(output, error, null);
    }

    public MethodResult(DataValue output, ErrorValue error, Consumer<AsyncHandle<MethodResult>> next) {
        if (output != null && error == null) {
            this.setOutput(output);
        } else if (output == null && error != null) {
            this.setError(error);
        } else {
            throw new IllegalArgumentException("Exactly one of 'output' and 'error' must be null");
        }
        this.next = next;
    }

    public DataValue getOutput() {
        return this.output;
    }

    public ErrorValue getError() {
        return this.error;
    }

    public Consumer<AsyncHandle<MethodResult>> getNext() {
        return this.next;
    }

    public boolean success() {
        return this.getError() == null;
    }

    private void setOutput(DataValue output) {
        this.output = output;
    }

    private void setError(ErrorValue error) {
        this.error = error;
    }

    public void setNext(Consumer<AsyncHandle<MethodResult>> next) {
        this.next = next;
    }

    public String toString() {
        return "Output: " + this.output + "\nError: " + this.error;
    }

    public static MethodResult newResult(DataValue output) {
        return new MethodResult(output, null);
    }

    public static MethodResult newErrorResult(ErrorValue error) {
        return new MethodResult(null, error);
    }
}

