/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.data;

import com.vmware.vapi.Message;
import com.vmware.vapi.MessageFactory;
import com.vmware.vapi.data.DataType;
import com.vmware.vapi.data.DataValue;
import com.vmware.vapi.data.DefinitionVisitor;
import java.util.LinkedList;
import java.util.List;

public abstract class DataDefinition {
    protected DataDefinition() {
    }

    public abstract DataType getType();

    public abstract void accept(DefinitionVisitor var1);

    public boolean validInstanceOf(DataValue value) {
        List<Message> errors = this.validate(value);
        return errors.isEmpty();
    }

    public List<Message> validate(DataValue value) {
        LinkedList<Message> result = new LinkedList<Message>();
        if (value == null) {
            result.add(MessageFactory.getMessage("vapi.data.validate.mismatch", this.getType().toString(), "null"));
        } else if (value.getType() != this.getType()) {
            result.add(MessageFactory.getMessage("vapi.data.validate.mismatch", this.getType().toString(), value.getType().toString()));
        }
        return result;
    }

    public void completeValue(DataValue value) {
    }

    public String toString() {
        return this.getType().toString();
    }
}

