/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.internal.dsig.json;

import com.vmware.vapi.CoreException;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyStoreHelper {
    private static final String ENTRY_NOT_ACCESSIBLE = "vapi.keystore.entrynotaccessible";
    private static final String JKS_TYPE = "JKS";
    private static final Logger log = LoggerFactory.getLogger(KeyStoreHelper.class);
    private final KeyStore _keyStore;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KeyStoreHelper(String storeName, char[] storePass) {
        try {
            this._keyStore = KeyStore.getInstance(JKS_TYPE);
            try (FileInputStream keystoreFileStream = new FileInputStream(storeName);){
                this._keyStore.load(keystoreFileStream, storePass);
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Failed to load keystore " + storeName, e);
        }
        catch (GeneralSecurityException e) {
            throw new IllegalArgumentException("Failed to load keystore " + storeName, e);
        }
    }

    public X509Certificate getCertificate(String certAlias) {
        X509Certificate cert;
        try {
            cert = (X509Certificate)this._keyStore.getCertificate(certAlias);
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("Entry " + certAlias + " does not correspond to an X.509 certificate", e);
        }
        catch (GeneralSecurityException e) {
            log.debug(e.getMessage(), (Throwable)e);
            throw new CoreException(ENTRY_NOT_ACCESSIBLE, certAlias);
        }
        this.checkEntryAvailable(certAlias, cert);
        return cert;
    }

    public PrivateKey getPrivateKey(String certAlias, char[] pass) {
        KeyStore.PrivateKeyEntry pk;
        try {
            pk = (KeyStore.PrivateKeyEntry)this._keyStore.getEntry(certAlias, new KeyStore.PasswordProtection(pass));
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("Entry " + certAlias + " does not correspond to a private key", e);
        }
        catch (GeneralSecurityException e) {
            log.debug(e.getMessage(), (Throwable)e);
            throw new CoreException(ENTRY_NOT_ACCESSIBLE, certAlias);
        }
        this.checkEntryAvailable(certAlias, pk);
        return pk.getPrivateKey();
    }

    private void checkEntryAvailable(String certAlias, Object ksObj) {
        if (ksObj == null) {
            throw new IllegalArgumentException("Entry " + certAlias + " not found in store");
        }
    }
}

