/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.internal.protocol.common.json;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.vmware.vapi.CoreException;
import com.vmware.vapi.MessageFactory;
import com.vmware.vapi.core.MethodResult;
import com.vmware.vapi.data.DataValue;
import com.vmware.vapi.data.ErrorValue;
import com.vmware.vapi.internal.protocol.common.json.DefaultDataValueDeserializer;
import com.vmware.vapi.internal.protocol.common.json.JsonApiRequest;
import com.vmware.vapi.internal.protocol.common.json.JsonApiResponse;
import com.vmware.vapi.internal.protocol.common.json.JsonBaseResponse;
import com.vmware.vapi.internal.protocol.common.json.JsonConstants;
import com.vmware.vapi.internal.protocol.common.json.JsonContextBuilderRequestParams;
import com.vmware.vapi.internal.protocol.common.json.JsonDataValueDeserializer;
import com.vmware.vapi.internal.protocol.common.json.JsonDeserializer;
import com.vmware.vapi.internal.protocol.common.json.JsonInvalidDataValueException;
import com.vmware.vapi.internal.protocol.common.json.JsonInvalidMethodException;
import com.vmware.vapi.internal.protocol.common.json.JsonInvalidMethodParamsException;
import com.vmware.vapi.internal.protocol.common.json.JsonInvalidRequest;
import com.vmware.vapi.internal.protocol.common.json.JsonInvalidResponse;
import com.vmware.vapi.internal.protocol.common.json.JsonProgressResponse;
import com.vmware.vapi.protocol.common.json.JsonRpcDeserializer;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class JsonMsgDeserializer2
implements JsonDeserializer,
JsonRpcDeserializer {
    private static final String OUTPUT = "output";
    private static final String LAST = "last";
    private static final String ERROR = "error";
    private static final String PROGRESS = "progress";
    private static final String RPC_VERSION = "2.0";
    private static final String INVALID_TYPE_IN_SECURITY_CONTEXT_MSG = "Found invalid type in the security context";
    private final JsonFactory factory = new JsonFactory();
    private final JsonDataValueDeserializer dvDeserializer;

    public JsonMsgDeserializer2() {
        this(new DefaultDataValueDeserializer());
    }

    public JsonMsgDeserializer2(JsonDataValueDeserializer dvDeserializer) {
        this.dvDeserializer = dvDeserializer;
    }

    @Override
    public JsonApiRequest requestDeserialize(String jsonRequest) throws JsonInvalidMethodParamsException, JsonInvalidRequest, JsonInvalidDataValueException, JsonInvalidMethodException, JsonParseException, IOException {
        try (JsonParser jp = this.factory.createParser(jsonRequest);){
            JsonToken nextToken;
            String rpcVersion = null;
            String id = null;
            String jsonMethod = null;
            JsonContextBuilderRequestParams params = null;
            jp.nextToken();
            while ((nextToken = jp.nextToken()) != JsonToken.END_OBJECT && nextToken != null) {
                JsonToken token = jp.getCurrentToken();
                if (token != JsonToken.FIELD_NAME) {
                    throw new JsonInvalidRequest(String.format("Received unexpected json token %s", token), id);
                }
                String jsonNode = jp.getCurrentName();
                if (jsonNode.equals("jsonrpc")) {
                    jp.nextToken();
                    rpcVersion = jp.getText();
                    if (rpcVersion.equals(RPC_VERSION)) continue;
                    throw new JsonInvalidRequest(String.format("Received Invalid rpc version %s", rpcVersion), id);
                }
                if (jsonNode.equals("id")) {
                    jp.nextToken();
                    id = jp.getText();
                    continue;
                }
                if (jsonNode.equals("method")) {
                    jp.nextToken();
                    jsonMethod = jp.getText();
                    if (JsonConstants.RequestType.invoke.toString().equals(jsonMethod)) continue;
                    throw new JsonInvalidMethodException(id, jsonMethod, "Invalid method:" + jsonMethod);
                }
                if (jp.getText().equals("params")) {
                    JsonMsgDeserializer2.nextExpectedToken(jp, JsonToken.START_OBJECT);
                    JsonMsgDeserializer2.nextExpectedToken(jp, JsonToken.FIELD_NAME);
                    JsonContextBuilderRequestParams.ExecutionContextBuilder ctx = null;
                    String serviceId = null;
                    String operationId = null;
                    DataValue dv = null;
                    while ((token = jp.getCurrentToken()) != JsonToken.END_OBJECT) {
                        if (token != JsonToken.FIELD_NAME) {
                            throw new JsonInvalidRequest(String.format("Received unexpected json token %s", token), id);
                        }
                        String fieldName = jp.getCurrentName();
                        if ("ctx".equals(fieldName)) {
                            jp.nextToken();
                            ctx = JsonMsgDeserializer2.deserializeExCtx(jp, id);
                            jp.nextToken();
                            continue;
                        }
                        if ("serviceId".equals(fieldName)) {
                            jp.nextToken();
                            serviceId = jp.getText();
                            jp.nextToken();
                            continue;
                        }
                        if ("operationId".equals(fieldName)) {
                            jp.nextToken();
                            operationId = jp.getText();
                            jp.nextToken();
                            continue;
                        }
                        if ("input".equals(fieldName)) {
                            jp.nextToken();
                            dv = this.dvDeserializer.deserializeDataValue(jp);
                            continue;
                        }
                        throw new JsonInvalidRequest(String.format("Unexpected field in '%s' value: %s", "params", fieldName), id);
                    }
                    JsonMsgDeserializer2.verifyFieldProcessed("serviceId", serviceId, id);
                    JsonMsgDeserializer2.verifyFieldProcessed("operationId", operationId, id);
                    JsonMsgDeserializer2.verifyFieldProcessed("ctx", ctx, id);
                    JsonMsgDeserializer2.verifyFieldProcessed("input", dv, id);
                    params = new JsonContextBuilderRequestParams(serviceId, operationId, ctx, dv);
                    continue;
                }
                throw new JsonInvalidRequest(String.format("Received unexpected jsonNode %s", jsonNode), id);
            }
            JsonMsgDeserializer2.verifyFieldProcessed("jsonrpc", rpcVersion, id);
            JsonMsgDeserializer2.verifyFieldProcessed("id", id, id);
            JsonMsgDeserializer2.verifyFieldProcessed("method", jsonMethod, id);
            JsonMsgDeserializer2.verifyFieldProcessed("params", params, id);
            JsonApiRequest jsonApiRequest = new JsonApiRequest(id, params);
            return jsonApiRequest;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public JsonBaseResponse responseDeserialize(InputStream jsonResponse, JsonConstants.RequestType responseType) {
        String jsonErrorData;
        String jsonErrorMessage;
        String jsonErrorCode;
        JsonParser jp;
        try {
            jp = this.factory.createParser(jsonResponse);
            Throwable throwable = null;
            try {
                block43: {
                    JsonApiResponse jsonApiResponse;
                    JsonToken nextToken;
                    String rpcVersion = null;
                    String id = null;
                    DataValue output = null;
                    ErrorValue error = null;
                    jp.nextToken();
                    while ((nextToken = jp.nextToken()) != JsonToken.END_OBJECT && nextToken != null) {
                        JsonToken token = jp.getCurrentToken();
                        if (token != JsonToken.FIELD_NAME) {
                            throw JsonMsgDeserializer2.toVapiCoreException(new JsonInvalidResponse(String.format("Received unexpected json token %s", token)));
                        }
                        String jsonNode = jp.getCurrentName();
                        if ("jsonrpc".equals(jsonNode)) {
                            jp.nextToken();
                            rpcVersion = jp.getText();
                            if (RPC_VERSION.equals(rpcVersion)) continue;
                            throw JsonMsgDeserializer2.toVapiCoreException(new JsonInvalidResponse(String.format("Received Invalid rpc version %s", rpcVersion)));
                        }
                        if ("id".equals(jsonNode)) {
                            jp.nextToken();
                            id = jp.getText();
                            continue;
                        }
                        if ("result".equals(jsonNode)) {
                            JsonMsgDeserializer2.nextExpectedToken(jp, JsonToken.START_OBJECT);
                            nextToken = jp.nextToken();
                            if (nextToken == JsonToken.FIELD_NAME) {
                                String fieldName = jp.getCurrentName();
                                if (OUTPUT.equals(fieldName)) {
                                    jp.nextToken();
                                    output = this.dvDeserializer.deserializeDataValue(jp);
                                    continue;
                                }
                                if (ERROR.equals(fieldName)) {
                                    JsonMsgDeserializer2.nextExpectedToken(jp, JsonToken.START_OBJECT);
                                    error = this.dvDeserializer.deserializeErrorValue(jp);
                                    continue;
                                }
                                if (PROGRESS.equals(fieldName)) {
                                    jp.nextToken();
                                    JsonProgressResponse jsonProgressResponse = new JsonProgressResponse(id, this.dvDeserializer.deserializeDataValue(jp));
                                    return jsonProgressResponse;
                                }
                                throw new JsonInvalidDataValueException(String.format("Unexpected field %s", fieldName));
                            }
                            if (nextToken == JsonToken.END_OBJECT) continue;
                            throw new JsonInvalidDataValueException(String.format("Expected empty object or response field but detected %s", nextToken));
                        }
                        if (!ERROR.equals(jsonNode)) {
                            throw JsonMsgDeserializer2.toVapiCoreException(new JsonInvalidResponse(String.format("Received unexpected jsonNode %s", jsonNode)));
                        }
                        break block43;
                    }
                    JsonMsgDeserializer2.verifyFieldProcessed("jsonrpc", rpcVersion, id);
                    JsonMsgDeserializer2.verifyFieldProcessed("id", id, id);
                    if (output != null && error != null) {
                        throw JsonMsgDeserializer2.toVapiCoreException(new JsonInvalidResponse("Received both Result and Error values"));
                    }
                    if (output == null && error == null) {
                        jsonApiResponse = new JsonApiResponse(id, MethodResult.EMPTY);
                        return jsonApiResponse;
                    }
                    if (output != null) {
                        jsonApiResponse = new JsonApiResponse(id, MethodResult.newResult(output));
                        return jsonApiResponse;
                    }
                    jsonApiResponse = new JsonApiResponse(id, MethodResult.newErrorResult(error));
                    return jsonApiResponse;
                }
                jsonErrorCode = null;
                jsonErrorMessage = null;
                jsonErrorData = null;
                jp.nextToken();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (jp != null) {
                    if (throwable != null) {
                        try {
                            jp.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        jp.close();
                    }
                }
            }
        }
        catch (JsonInvalidResponse e) {
            throw JsonMsgDeserializer2.toVapiCoreException(e);
        }
        catch (JsonParseException e) {
            throw JsonMsgDeserializer2.toVapiCoreException((Exception)((Object)e));
        }
        catch (IOException e) {
            throw JsonMsgDeserializer2.toVapiCoreException(e);
        }
        while (true) {
            if (jp.nextToken() == JsonToken.END_OBJECT) {
                String errorMessage = "Recieved JSON-RPC 2.0 error with code:" + jsonErrorCode + " and message:" + jsonErrorMessage;
                throw new JsonInvalidResponse(errorMessage, jsonErrorCode, jsonErrorData);
            }
            if (jp.getCurrentToken() != JsonToken.FIELD_NAME) {
                throw JsonMsgDeserializer2.toVapiCoreException(new JsonInvalidResponse(String.format("Received unexpected json token %s", jp.getCurrentToken())));
            }
            if ("code".equals(jp.getCurrentName())) {
                jp.nextToken();
                jsonErrorCode = jp.getText();
                continue;
            }
            if ("message".equals(jp.getCurrentName())) {
                jp.nextToken();
                jsonErrorMessage = jp.getText();
                continue;
            }
            if (!"data".equals(jp.getCurrentName())) continue;
            jp.nextToken();
            jsonErrorData = jp.getText();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public DataValue deserializeDataValue(String jsonString) {
        try (JsonParser jp = this.factory.createParser(jsonString);){
            jp.nextToken();
            DataValue dataValue = this.dvDeserializer.deserializeDataValue(jp);
            return dataValue;
        }
        catch (IOException ex) {
            throw JsonMsgDeserializer2.toVapiCoreException(ex);
        }
    }

    private static JsonContextBuilderRequestParams.ExecutionContextBuilder deserializeExCtx(JsonParser jp, String id) throws JsonParseException, JsonInvalidMethodParamsException, IOException {
        JsonContextBuilderRequestParams.ExecutionContextBuilder exCtx = new JsonContextBuilderRequestParams.ExecutionContextBuilder();
        while (jp.nextToken() != JsonToken.END_OBJECT) {
            String fieldName = jp.getCurrentName();
            if (fieldName.equals("appCtx")) {
                jp.nextToken();
                while (jp.nextToken() != JsonToken.END_OBJECT) {
                    String key = jp.getText();
                    jp.nextToken();
                    String value = jp.getText();
                    exCtx.applicationData.put(key.toLowerCase(Locale.ENGLISH), value);
                }
                continue;
            }
            if (!fieldName.equals("securityCtx")) continue;
            jp.nextToken();
            JsonMsgDeserializer2.deserializeSecurityContext(jp, id, exCtx.security);
        }
        return exCtx;
    }

    private static void deserializeSecurityContext(JsonParser jp, String id, Map<String, Object> secCtxData) throws JsonParseException, JsonInvalidMethodParamsException, IOException {
        JsonToken currentToken = jp.getCurrentToken();
        if (currentToken != JsonToken.START_OBJECT) {
            return;
        }
        jp.nextToken();
        while (currentToken != JsonToken.END_OBJECT) {
            String key = jp.getText();
            jp.nextToken();
            Object value = JsonMsgDeserializer2.parseJsonObject(jp);
            secCtxData.put(key, value);
            currentToken = jp.getCurrentToken();
        }
        Object schemeId = secCtxData.get("schemeId");
        if (schemeId == null || schemeId.getClass() != String.class) {
            throw new JsonInvalidMethodParamsException(id, "Missing or invalid value type for 'schemeId'");
        }
        secCtxData.put("authn_scheme_id", schemeId);
    }

    private static Object parseJsonObject(JsonParser jp) throws JsonParseException, IOException {
        Object value = null;
        JsonToken curr = jp.getCurrentToken();
        if (curr == JsonToken.VALUE_STRING) {
            value = jp.getText();
        } else if (curr == JsonToken.START_OBJECT) {
            jp.nextToken();
            HashMap<String, Object> data = new HashMap<String, Object>();
            while (curr != JsonToken.END_OBJECT) {
                String key = jp.getText();
                jp.nextToken();
                Object val = JsonMsgDeserializer2.parseJsonObject(jp);
                data.put(key, val);
                curr = jp.getCurrentToken();
            }
            value = data;
        } else {
            throw JsonMsgDeserializer2.toVapiCoreException(new RuntimeException(INVALID_TYPE_IN_SECURITY_CONTEXT_MSG));
        }
        jp.nextToken();
        return value;
    }

    static void nextExpectedToken(JsonParser jp, JsonToken expected) throws JsonParseException, IOException {
        if (jp.nextToken() != expected) {
            throw new JsonInvalidDataValueException(String.format("Expected %s JSON token but detected %s", expected, jp.getCurrentToken()));
        }
    }

    private static void verifyFieldProcessed(String fieldName, Object value, String id) throws JsonInvalidMethodParamsException {
        if (value == null) {
            throw new JsonInvalidMethodParamsException(id, "Missing node: " + fieldName);
        }
    }

    private static CoreException toVapiCoreException(Exception ex) {
        return new CoreException(MessageFactory.getMessage("vapi.json.deserialize.ioerror", ex.getMessage()), (Throwable)ex);
    }
}

