/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.security;

import com.vmware.vapi.ErrorValueFactory;
import com.vmware.vapi.Message;
import com.vmware.vapi.MessageFactory;
import com.vmware.vapi.core.ApiProvider;
import com.vmware.vapi.core.AsyncHandle;
import com.vmware.vapi.core.DecoratorApiProvider;
import com.vmware.vapi.core.ExecutionContext;
import com.vmware.vapi.core.MethodIdentifier;
import com.vmware.vapi.core.MethodResult;
import com.vmware.vapi.data.DataValue;
import com.vmware.vapi.data.ErrorDefinition;
import com.vmware.vapi.data.ErrorValue;
import com.vmware.vapi.internal.security.SecurityUtil;
import com.vmware.vapi.internal.util.Validate;
import com.vmware.vapi.provider.introspection.ErrorAugmentingFilter;
import com.vmware.vapi.security.AuthenticationConfig;
import com.vmware.vapi.security.AuthenticationHandler;
import com.vmware.vapi.std.StandardDataFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AuthenticationFilter
extends DecoratorApiProvider {
    private static final char PACKAGE_DELIMITER = '.';
    private static final Logger logger = LoggerFactory.getLogger(AuthenticationFilter.class);
    private static final AuthenticationConfig.AuthnScheme NO_AUTHN_SCHEME = AuthenticationConfig.AuthnScheme.getNoAuthenticationScheme();
    private static final ErrorValue UNAUTHENTICATED;
    private static final ErrorValue OPERATION_NOT_FOUND;
    private static Set<String> VAPI_ANON_OPERATIONS;
    static final Set<ErrorDefinition> AUTHN_FILTER_ERROR_DEFS;
    private final Map<String, List<AuthenticationConfig.AuthnScheme>> ifaceRulesTable;
    private final Map<String, List<AuthenticationConfig.AuthnScheme>> packageRulesTable;
    private final Map<String, List<AuthenticationConfig.AuthnScheme>> operationRulesTable;
    private final List<AuthenticationHandler> authnHandlers;

    public AuthenticationFilter(ApiProvider decoratedProvider, AuthenticationConfig authnConfig, List<AuthenticationHandler> authnHandlers) {
        super(new ErrorAugmentingFilter(decoratedProvider, AUTHN_FILTER_ERROR_DEFS));
        Validate.notNull(authnConfig);
        Validate.notNull(authnHandlers);
        this.ifaceRulesTable = AuthenticationFilter.copyRules(authnConfig.getIFaceAuthenticationRules(), true);
        this.packageRulesTable = AuthenticationFilter.copyRules(authnConfig.getPackageAuthenticationRules(), true);
        this.operationRulesTable = AuthenticationFilter.copyRules(authnConfig.getOperationAuthenticationRules(), false);
        this.authnHandlers = authnHandlers;
    }

    @Override
    public void invoke(final String serviceId, final String operationId, final DataValue input, final ExecutionContext ctx, final AsyncHandle<MethodResult> asyncHandle) {
        List<AuthenticationConfig.AuthnScheme> requiredAuthnSchemes = this.getMethodAuthnScheme(serviceId, operationId);
        if (requiredAuthnSchemes == null || requiredAuthnSchemes.isEmpty()) {
            asyncHandle.setResult(MethodResult.newErrorResult(OPERATION_NOT_FOUND));
            return;
        }
        final ExecutionContext.SecurityContext secCtx = ctx.retrieveSecurityContext();
        String wireSchemeId = AuthenticationFilter.extractWireScheme(secCtx);
        AuthenticationConfig.AuthnScheme wireScheme = AuthenticationFilter.createAuthnScheme(wireSchemeId);
        if (AuthenticationFilter.isSchemeAllowed(requiredAuthnSchemes, wireScheme)) {
            if (NO_AUTHN_SCHEME == wireScheme) {
                this.decoratedProvider.invoke(serviceId, operationId, input, ctx, asyncHandle);
                return;
            }
        } else {
            if (AuthenticationFilter.isSchemeAllowed(requiredAuthnSchemes, NO_AUTHN_SCHEME)) {
                logger.debug("Unexpected scheme '{}' found in the invocation of method '{}.{}' which allows 'NoAuthentication'", new Object[]{wireScheme, serviceId, operationId});
                this.decoratedProvider.invoke(serviceId, operationId, input, ctx.withSecurityContext(null), asyncHandle);
                return;
            }
            logger.debug("Invalid authentication scheme '{}' for method {}.{} which allows {}", new Object[]{wireScheme, serviceId, operationId, requiredAuthnSchemes});
            asyncHandle.setResult(MethodResult.newErrorResult(UNAUTHENTICATED));
            return;
        }
        AuthenticationHandler authnHandler = this.findHandler(wireSchemeId);
        if (authnHandler == null) {
            asyncHandle.setResult(MethodResult.newErrorResult(UNAUTHENTICATED));
            return;
        }
        authnHandler.authenticate(secCtx, new AsyncHandle<AuthenticationHandler.AuthenticationResult>(){

            @Override
            public void updateProgress(DataValue progress) {
            }

            @Override
            public void setResult(AuthenticationHandler.AuthenticationResult result) {
                ExecutionContext.SecurityContext authnSecCtx = secCtx;
                if (result != null && result.getSecurityContext() != null) {
                    authnSecCtx = result.getSecurityContext();
                }
                SecurityContextImpl s = new SecurityContextImpl(authnSecCtx, result);
                AuthenticationFilter.this.decoratedProvider.invoke(serviceId, operationId, input, ctx.withSecurityContext(s), asyncHandle);
            }

            @Override
            public void setError(RuntimeException error) {
                logger.info("Authentication failed", (Throwable)error);
                asyncHandle.setResult(MethodResult.newErrorResult(UNAUTHENTICATED));
            }
        });
    }

    private AuthenticationHandler findHandler(String schemeId) {
        for (AuthenticationHandler handler : this.authnHandlers) {
            if (!handler.supportedAuthenticationSchemes().contains(schemeId)) continue;
            logger.debug("Selected authentication handler is {}", (Object)handler);
            return handler;
        }
        logger.debug("No suitable authentication handler found for scheme '{}'", (Object)schemeId);
        return null;
    }

    private List<AuthenticationConfig.AuthnScheme> getMethodAuthnScheme(String serviceId, String operationId) {
        String fqn = MethodIdentifier.getFullyQualifiedName(serviceId, operationId);
        List<AuthenticationConfig.AuthnScheme> requiredSchemesList = this.operationRulesTable.get(fqn);
        if (requiredSchemesList != null) {
            return requiredSchemesList;
        }
        if (VAPI_ANON_OPERATIONS.contains(fqn)) {
            return Collections.singletonList(NO_AUTHN_SCHEME);
        }
        requiredSchemesList = this.ifaceRulesTable.get(serviceId);
        if (requiredSchemesList != null) {
            return requiredSchemesList;
        }
        String closestPackage = AuthenticationFilter.findClosestPackage(serviceId, this.packageRulesTable.keySet());
        return this.packageRulesTable.get(closestPackage);
    }

    private static boolean isSchemeAllowed(List<AuthenticationConfig.AuthnScheme> allowedList, AuthenticationConfig.AuthnScheme wireScheme) {
        for (AuthenticationConfig.AuthnScheme scheme : allowedList) {
            if (!scheme.isAllowed(wireScheme)) continue;
            return true;
        }
        return false;
    }

    private static String extractWireScheme(ExecutionContext.SecurityContext ctx) {
        if (ctx == null) {
            return null;
        }
        Object schemeIdObject = ctx.getProperty("authn_scheme_id");
        return SecurityUtil.narrowType(schemeIdObject, String.class);
    }

    private static AuthenticationConfig.AuthnScheme createAuthnScheme(String schemeId) {
        if (schemeId == null) {
            return AuthenticationConfig.AuthnScheme.getNoAuthenticationScheme();
        }
        return new AuthenticationConfig.AuthnScheme(Collections.singletonList(schemeId));
    }

    static String findClosestPackage(String invocationService, Iterable<String> registeredPackages) {
        String result = "";
        for (String packageName : registeredPackages) {
            int packageNameLength = packageName.length();
            if (packageNameLength <= result.length() || !invocationService.startsWith(packageName) || invocationService.length() <= packageNameLength || invocationService.charAt(packageNameLength) != '.') continue;
            result = packageName;
        }
        return result;
    }

    private static Map<String, List<AuthenticationConfig.AuthnScheme>> copyRules(Map<String, List<AuthenticationConfig.AuthnScheme>> authenticationRules, boolean rejectNoAuth) {
        HashMap<String, List<AuthenticationConfig.AuthnScheme>> result = new HashMap<String, List<AuthenticationConfig.AuthnScheme>>(authenticationRules);
        for (Map.Entry entry : result.entrySet()) {
            List schemes = (List)entry.getValue();
            if (schemes == null) continue;
            if (rejectNoAuth && schemes.contains(AuthenticationConfig.AuthnScheme.getNoAuthenticationScheme())) {
                throw new RuntimeException(String.format("%s cannot be marked as anonymous. NoAuthentication is allowed on operations level only.", entry.getKey()));
            }
            entry.setValue(new ArrayList(schemes));
        }
        return result;
    }

    public static Set<String> getImplicitlyAnonymousOperations() {
        return Collections.unmodifiableSet(VAPI_ANON_OPERATIONS);
    }

    static {
        Message message = MessageFactory.getMessage("vapi.method.authentication.required", new String[0]);
        UNAUTHENTICATED = ErrorValueFactory.buildErrorValue("com.vmware.vapi.std.errors.unauthenticated", message);
        message = MessageFactory.getMessage("vapi.authentication.metadata.required", new String[0]);
        OPERATION_NOT_FOUND = ErrorValueFactory.buildErrorValue("com.vmware.vapi.std.errors.operation_not_found", message);
        VAPI_ANON_OPERATIONS = new HashSet<String>(Arrays.asList("com.vmware.vapi.metadata.routing.component.list", "com.vmware.vapi.metadata.routing.component.get", "com.vmware.vapi.metadata.routing.component.fingerprint", "com.vmware.vapi.metadata.routing.service.operation.list", "com.vmware.vapi.metadata.routing.service.operation.get", "com.vmware.vapi.metadata.routing.package.list", "com.vmware.vapi.metadata.routing.package.get", "com.vmware.vapi.metadata.routing.service.list", "com.vmware.vapi.metadata.routing.service.get", "com.vmware.vapi.metadata.cli.command.list", "com.vmware.vapi.metadata.cli.command.get", "com.vmware.vapi.metadata.cli.command.fingerprint", "com.vmware.vapi.metadata.cli.namespace.list", "com.vmware.vapi.metadata.cli.namespace.get", "com.vmware.vapi.metadata.cli.namespace.fingerprint", "com.vmware.vapi.metadata.privilege.component.list", "com.vmware.vapi.metadata.privilege.component.get", "com.vmware.vapi.metadata.privilege.component.fingerprint", "com.vmware.vapi.metadata.privilege.service.operation.list", "com.vmware.vapi.metadata.privilege.service.operation.get", "com.vmware.vapi.metadata.privilege.package.list", "com.vmware.vapi.metadata.privilege.package.get", "com.vmware.vapi.metadata.privilege.service.list", "com.vmware.vapi.metadata.privilege.service.get", "com.vmware.vapi.metadata.authentication.component.list", "com.vmware.vapi.metadata.authentication.component.get", "com.vmware.vapi.metadata.authentication.component.fingerprint", "com.vmware.vapi.metadata.authentication.service.operation.list", "com.vmware.vapi.metadata.authentication.service.operation.get", "com.vmware.vapi.metadata.authentication.package.list", "com.vmware.vapi.metadata.authentication.package.get", "com.vmware.vapi.metadata.authentication.service.list", "com.vmware.vapi.metadata.authentication.service.get", "com.vmware.vapi.metadata.metamodel.component.list", "com.vmware.vapi.metadata.metamodel.component.get", "com.vmware.vapi.metadata.metamodel.component.fingerprint", "com.vmware.vapi.metadata.metamodel.enumeration.list", "com.vmware.vapi.metadata.metamodel.enumeration.get", "com.vmware.vapi.metadata.metamodel.resource.model.list", "com.vmware.vapi.metadata.metamodel.service.operation.list", "com.vmware.vapi.metadata.metamodel.service.operation.get", "com.vmware.vapi.metadata.metamodel.service.hidden.list", "com.vmware.vapi.metadata.metamodel.package.list", "com.vmware.vapi.metadata.metamodel.package.get", "com.vmware.vapi.metadata.metamodel.resource.list", "com.vmware.vapi.metadata.metamodel.service.list", "com.vmware.vapi.metadata.metamodel.service.get", "com.vmware.vapi.metadata.metamodel.structure.list", "com.vmware.vapi.metadata.metamodel.structure.get", "com.vmware.vapi.rest.navigation.component.list", "com.vmware.vapi.rest.navigation.options.get", "com.vmware.vapi.rest.navigation.resource.get", "com.vmware.vapi.rest.navigation.resource.list", "com.vmware.vapi.rest.navigation.root.get", "com.vmware.vapi.rest.navigation.service.list", "com.vmware.vapi.std.introspection.operation.list", "com.vmware.vapi.std.introspection.operation.get", "com.vmware.vapi.std.introspection.provider.get", "com.vmware.vapi.std.introspection.service.list", "com.vmware.vapi.std.introspection.service.get"));
        AUTHN_FILTER_ERROR_DEFS = Collections.singleton(StandardDataFactory.createStandardErrorDefinition("com.vmware.vapi.std.errors.unauthenticated"));
    }

    private static class SecurityContextImpl
    implements ExecutionContext.SecurityContext {
        private final Map<String, Object> ctxData;

        private SecurityContextImpl(ExecutionContext.SecurityContext ctx, AuthenticationHandler.AuthenticationResult result) {
            this.ctxData = new HashMap<String, Object>(ctx.getAllProperties());
            this.ctxData.put("authn_data_id", result);
        }

        @Override
        public Object getProperty(String key) {
            return this.ctxData.get(key);
        }

        @Override
        public Map<String, Object> getAllProperties() {
            return Collections.unmodifiableMap(this.ctxData);
        }
    }
}

