/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.binding.vim;

import com.vmware.vim.binding.impl.vmodl.DynamicDataImpl;
import com.vmware.vim.binding.vim.KeyValue;
import com.vmware.vim.binding.vim.version.version1;
import com.vmware.vim.binding.vim.version.version2;
import com.vmware.vim.binding.vim.version.version5;
import com.vmware.vim.binding.vim.version.version7;
import com.vmware.vim.binding.vmodl.KeyAnyValue;
import com.vmware.vim.binding.vmodl.ManagedObject;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.data;
import com.vmware.vim.binding.vmodl.faults;
import com.vmware.vim.binding.vmodl.fullyQualifiedVmodlName;
import com.vmware.vim.binding.vmodl.internal;
import com.vmware.vim.binding.vmodl.list;
import com.vmware.vim.binding.vmodl.localizable;
import com.vmware.vim.binding.vmodl.managed;
import com.vmware.vim.binding.vmodl.managedObjectType;
import com.vmware.vim.binding.vmodl.map;
import com.vmware.vim.binding.vmodl.name;
import com.vmware.vim.binding.vmodl.optional;
import com.vmware.vim.binding.vmodl.privilege;
import com.vmware.vim.binding.vmodl.propertyOrder;
import com.vmware.vim.binding.vmodl.readonly;
import com.vmware.vim.binding.vmodl.versionClass;
import com.vmware.vim.binding.vmodl.wsdlName;
import com.vmware.vim.vmomi.core.Future;
import com.vmware.vim.vmomi.core.util.StringUtil;
import java.util.Calendar;

@fullyQualifiedVmodlName(value="vim.LicenseManager")
@managed
@versionClass(value=version1.class)
@wsdlName(value="LicenseManager")
public interface LicenseManager
extends ManagedObject {
    @readonly
    @name(value="source")
    @versionClass(value=version1.class)
    public void getSource(Future<LicenseSource> var1);

    @readonly
    @name(value="sourceAvailable")
    @versionClass(value=version1.class)
    public void isSourceAvailable(Future<Boolean> var1);

    @readonly
    @name(value="diagnostics")
    @versionClass(value=version2.class)
    @optional
    public void getDiagnostics(@optional Future<DiagnosticInfo> var1);

    @readonly
    @name(value="featureInfo")
    @versionClass(value=version1.class)
    @optional
    @map
    public void getFeatureInfo(@optional Future<FeatureInfo[]> var1);

    @readonly
    @name(value="licensedEdition")
    @versionClass(value=version2.class)
    public void getLicensedEdition(Future<String> var1);

    @readonly
    @name(value="licenses")
    @versionClass(value=version5.class)
    @list
    public void getLicenses(Future<LicenseInfo[]> var1);

    @readonly
    @name(value="licenseAssignmentManager")
    @privilege(value="System.View")
    @versionClass(value=version5.class)
    @optional
    @managedObjectType(value="com.vmware.vim.binding.vim.LicenseAssignmentManager")
    public void getLicenseAssignmentManager(@optional @managedObjectType(value="com.vmware.vim.binding.vim.LicenseAssignmentManager") Future<ManagedObjectReference> var1);

    @readonly
    @name(value="evaluation")
    @privilege(value="System.Read")
    @versionClass(value=version5.class)
    public void getEvaluation(Future<EvaluationInfo> var1);

    @versionClass(value=version7.class)
    @wsdlName(value="ActivateRemoteHardEnforcement")
    @privilege(value="Global.Licenses")
    @internal
    public void activateRemoteHardEnforcement(@name(value="remoteHardEnforcementTimeout") @versionClass(value=version7.class) int var1, Future<Void> var2);

    @versionClass(value=version5.class)
    @wsdlName(value="AddLicense")
    @privilege(value="Global.Licenses")
    public void addLicense(@name(value="licenseKey") @versionClass(value=version5.class) String var1, @name(value="labels") @versionClass(value=version5.class) @optional @map KeyValue[] var2, Future<LicenseInfo> var3);

    @versionClass(value=version1.class)
    @wsdlName(value="CheckLicenseFeature")
    @privilege(value="System.Read")
    @faults(value={"InvalidState"})
    @Deprecated
    public void checkFeature(@name(value="host") @versionClass(value=version1.class) @optional @managedObjectType(value="com.vmware.vim.binding.vim.HostSystem") ManagedObjectReference var1, @name(value="featureKey") @versionClass(value=version1.class) String var2, Future<Boolean> var3);

    @versionClass(value=version1.class)
    @wsdlName(value="ConfigureLicenseSource")
    @privilege(value="Global.Licenses")
    @faults(value={"CannotAccessLocalSource", "InvalidLicense", "LicenseServerUnavailable"})
    @Deprecated
    public void configureSource(@name(value="host") @versionClass(value=version1.class) @optional @managedObjectType(value="com.vmware.vim.binding.vim.HostSystem") ManagedObjectReference var1, @name(value="licenseSource") @versionClass(value=version1.class) LicenseSource var2, Future<Void> var3);

    @versionClass(value=version5.class)
    @wsdlName(value="DecodeLicense")
    @privilege(value="Global.Licenses")
    public void decodeLicense(@name(value="licenseKey") @versionClass(value=version5.class) String var1, Future<LicenseInfo> var2);

    @versionClass(value=version1.class)
    @wsdlName(value="DisableFeature")
    @privilege(value="Global.Licenses")
    @faults(value={"InvalidState", "LicenseServerUnavailable"})
    @Deprecated
    public void disable(@name(value="host") @versionClass(value=version1.class) @optional @managedObjectType(value="com.vmware.vim.binding.vim.HostSystem") ManagedObjectReference var1, @name(value="featureKey") @versionClass(value=version1.class) String var2, Future<Boolean> var3);

    @versionClass(value=version1.class)
    @wsdlName(value="EnableFeature")
    @privilege(value="Global.Licenses")
    @faults(value={"InvalidState", "LicenseServerUnavailable"})
    @Deprecated
    public void enable(@name(value="host") @versionClass(value=version1.class) @optional @managedObjectType(value="com.vmware.vim.binding.vim.HostSystem") ManagedObjectReference var1, @name(value="featureKey") @versionClass(value=version1.class) String var2, Future<Boolean> var3);

    @versionClass(value=version7.class)
    @wsdlName(value="QueryLicenseDataManager")
    @privilege(value="Global.Licenses")
    @internal
    public void queryLicenseDataManager(@managedObjectType(value="com.vmware.vim.binding.vim.LicenseDataManager") Future<ManagedObjectReference> var1);

    @versionClass(value=version1.class)
    @wsdlName(value="QueryLicenseSourceAvailability")
    @privilege(value="Global.Licenses")
    @list
    @Deprecated
    public void querySourceAvailability(@name(value="host") @versionClass(value=version1.class) @optional @managedObjectType(value="com.vmware.vim.binding.vim.HostSystem") ManagedObjectReference var1, @optional @list Future<AvailabilityInfo[]> var2);

    @versionClass(value=version1.class)
    @wsdlName(value="QueryLicenseUsage")
    @privilege(value="System.Read")
    @Deprecated
    public void queryUsage(@name(value="host") @versionClass(value=version1.class) @optional @managedObjectType(value="com.vmware.vim.binding.vim.HostSystem") ManagedObjectReference var1, Future<LicenseUsageInfo> var2);

    @versionClass(value=version2.class)
    @wsdlName(value="QuerySupportedFeatures")
    @privilege(value="Global.Licenses")
    @map
    @Deprecated
    public void querySupportedFeatures(@name(value="host") @versionClass(value=version2.class) @optional @managedObjectType(value="com.vmware.vim.binding.vim.HostSystem") ManagedObjectReference var1, @optional @map Future<FeatureInfo[]> var2);

    @versionClass(value=version5.class)
    @wsdlName(value="RemoveLicense")
    @privilege(value="Global.Licenses")
    public void removeLicense(@name(value="licenseKey") @versionClass(value=version5.class) String var1, Future<Void> var2);

    @versionClass(value=version5.class)
    @wsdlName(value="RemoveLicenseLabel")
    @privilege(value="Global.Licenses")
    public void removeLabel(@name(value="licenseKey") @versionClass(value=version5.class) String var1, @name(value="labelKey") @versionClass(value=version5.class) String var2, Future<Void> var3);

    @versionClass(value=version1.class)
    @wsdlName(value="SetLicenseEdition")
    @privilege(value="Global.Licenses")
    @faults(value={"InvalidState", "LicenseServerUnavailable"})
    @Deprecated
    public void setEdition(@name(value="host") @versionClass(value=version1.class) @optional @managedObjectType(value="com.vmware.vim.binding.vim.HostSystem") ManagedObjectReference var1, @name(value="featureKey") @versionClass(value=version1.class) @optional String var2, Future<Void> var3);

    @versionClass(value=version5.class)
    @wsdlName(value="UpdateLicense")
    @privilege(value="Global.Licenses")
    public void updateLicense(@name(value="licenseKey") @versionClass(value=version5.class) String var1, @name(value="labels") @versionClass(value=version5.class) @optional @map KeyValue[] var2, Future<LicenseInfo> var3);

    @versionClass(value=version5.class)
    @wsdlName(value="UpdateLicenseLabel")
    @privilege(value="Global.Licenses")
    public void updateLabel(@name(value="licenseKey") @versionClass(value=version5.class) String var1, @name(value="labelKey") @versionClass(value=version5.class) String var2, @name(value="labelValue") @versionClass(value=version5.class) String var3, Future<Void> var4);

    @versionClass(value=version1.class)
    @wsdlName(value="LicenseReservationInfo")
    @data
    @propertyOrder(value={"key", "state", "required"})
    public static class ReservationInfo
    extends DynamicDataImpl {
        private static final long serialVersionUID = 1L;
        public String key;
        public State state;
        public int required;

        public ReservationInfo() {
        }

        public ReservationInfo(String key, State state, int required) {
            this.key = key;
            this.state = state;
            this.required = required;
        }

        @versionClass(value=version1.class)
        public String getKey() {
            return this.key;
        }

        @versionClass(value=version1.class)
        public void setKey(String key) {
            this.key = key;
        }

        @versionClass(value=version1.class)
        public State getState() {
            return this.state;
        }

        @versionClass(value=version1.class)
        public void setState(State state) {
            this.state = state;
        }

        @versionClass(value=version1.class)
        public int getRequired() {
            return this.required;
        }

        @versionClass(value=version1.class)
        public void setRequired(int required) {
            this.required = required;
        }

        public String toString() {
            StringBuilder objString = new StringBuilder(200);
            objString.append("(vim.ReservationInfo) {\n");
            objString.append("   ");
            objString.append("dynamicType = ");
            objString.append(this.getDynamicType());
            objString.append(",\n");
            objString.append("   ");
            objString.append("dynamicProperty = ");
            if (this.getDynamicProperty() == null) {
                objString.append("null");
            } else {
                objString.append("(vmodl.DynamicProperty) [\n");
                for (int i = 0; i < this.getDynamicProperty().length; ++i) {
                    objString.append("      ");
                    objString.append(StringUtil.indent((String)("" + this.getDynamicProperty()[i]), (boolean)true));
                    if (i < this.getDynamicProperty().length - 1) {
                        objString.append(",");
                    }
                    objString.append("\n");
                }
                objString.append("   ");
                objString.append("]");
            }
            objString.append(",\n");
            objString.append("   ");
            objString.append("key = ");
            objString.append(this.getKey());
            objString.append(",\n");
            objString.append("   ");
            objString.append("state = ");
            objString.append((Object)this.getState());
            objString.append(",\n");
            objString.append("   ");
            objString.append("required = ");
            objString.append(this.getRequired());
            objString.append("\n}");
            return objString.toString();
        }

        @versionClass(value=version1.class)
        @wsdlName(value="LicenseReservationInfoState")
        public static enum State {
            notUsed,
            noLicense,
            unlicensedUse,
            licensed;

        }
    }

    @versionClass(value=version1.class)
    @wsdlName(value="LocalLicenseSource")
    @data
    @propertyOrder(value={"licenseKeys"})
    public static class LocalLicense
    extends LicenseSource {
        private static final long serialVersionUID = 1L;
        public String licenseKeys;

        public LocalLicense() {
        }

        public LocalLicense(String licenseKeys) {
            this.licenseKeys = licenseKeys;
        }

        @versionClass(value=version1.class)
        public String getLicenseKeys() {
            return this.licenseKeys;
        }

        @versionClass(value=version1.class)
        public void setLicenseKeys(String licenseKeys) {
            this.licenseKeys = licenseKeys;
        }

        @Override
        public String toString() {
            StringBuilder objString = new StringBuilder(120);
            objString.append("(vim.LocalLicense) {\n");
            objString.append("   ");
            objString.append("dynamicType = ");
            objString.append(this.getDynamicType());
            objString.append(",\n");
            objString.append("   ");
            objString.append("dynamicProperty = ");
            if (this.getDynamicProperty() == null) {
                objString.append("null");
            } else {
                objString.append("(vmodl.DynamicProperty) [\n");
                for (int i = 0; i < this.getDynamicProperty().length; ++i) {
                    objString.append("      ");
                    objString.append(StringUtil.indent((String)("" + this.getDynamicProperty()[i]), (boolean)true));
                    if (i < this.getDynamicProperty().length - 1) {
                        objString.append(",");
                    }
                    objString.append("\n");
                }
                objString.append("   ");
                objString.append("]");
            }
            objString.append(",\n");
            objString.append("   ");
            objString.append("licenseKeys = ");
            objString.append(this.getLicenseKeys());
            objString.append("\n}");
            return objString.toString();
        }
    }

    @versionClass(value=version1.class)
    @wsdlName(value="LicenseUsageInfo")
    @data
    @propertyOrder(value={"source", "sourceAvailable", "reservationInfo", "featureInfo"})
    public static class LicenseUsageInfo
    extends DynamicDataImpl {
        private static final long serialVersionUID = 1L;
        public LicenseSource source;
        public boolean sourceAvailable;
        public ReservationInfo[] reservationInfo;
        public FeatureInfo[] featureInfo;

        public LicenseUsageInfo() {
        }

        public LicenseUsageInfo(LicenseSource source, boolean sourceAvailable, ReservationInfo[] reservationInfo, FeatureInfo[] featureInfo) {
            this.source = source;
            this.sourceAvailable = sourceAvailable;
            this.reservationInfo = reservationInfo;
            this.featureInfo = featureInfo;
        }

        @versionClass(value=version1.class)
        public LicenseSource getSource() {
            return this.source;
        }

        @versionClass(value=version1.class)
        public void setSource(LicenseSource source) {
            this.source = source;
        }

        @versionClass(value=version1.class)
        public boolean isSourceAvailable() {
            return this.sourceAvailable;
        }

        @versionClass(value=version1.class)
        public void setSourceAvailable(boolean sourceAvailable) {
            this.sourceAvailable = sourceAvailable;
        }

        @map
        @optional
        @versionClass(value=version1.class)
        public ReservationInfo[] getReservationInfo() {
            return this.reservationInfo;
        }

        @map
        @optional
        @versionClass(value=version1.class)
        public void setReservationInfo(ReservationInfo[] reservationInfo) {
            this.reservationInfo = reservationInfo;
        }

        @map
        @optional
        @versionClass(value=version1.class)
        public FeatureInfo[] getFeatureInfo() {
            return this.featureInfo;
        }

        @map
        @optional
        @versionClass(value=version1.class)
        public void setFeatureInfo(FeatureInfo[] featureInfo) {
            this.featureInfo = featureInfo;
        }

        public String toString() {
            int i;
            StringBuilder objString = new StringBuilder(240);
            objString.append("(vim.LicenseUsageInfo) {\n");
            objString.append("   ");
            objString.append("dynamicType = ");
            objString.append(this.getDynamicType());
            objString.append(",\n");
            objString.append("   ");
            objString.append("dynamicProperty = ");
            if (this.getDynamicProperty() == null) {
                objString.append("null");
            } else {
                objString.append("(vmodl.DynamicProperty) [\n");
                for (i = 0; i < this.getDynamicProperty().length; ++i) {
                    objString.append("      ");
                    objString.append(StringUtil.indent((String)("" + this.getDynamicProperty()[i]), (boolean)true));
                    if (i < this.getDynamicProperty().length - 1) {
                        objString.append(",");
                    }
                    objString.append("\n");
                }
                objString.append("   ");
                objString.append("]");
            }
            objString.append(",\n");
            objString.append("   ");
            objString.append("source = ");
            if (this.getSource() == null) {
                objString.append("null");
            } else {
                objString.append(StringUtil.indent((String)("" + this.getSource()), (boolean)false));
            }
            objString.append(",\n");
            objString.append("   ");
            objString.append("sourceAvailable = ");
            objString.append(this.isSourceAvailable());
            objString.append(",\n");
            objString.append("   ");
            objString.append("reservationInfo = ");
            if (this.getReservationInfo() == null) {
                objString.append("null");
            } else {
                objString.append("(vim.ReservationInfo) [\n");
                for (i = 0; i < this.getReservationInfo().length; ++i) {
                    objString.append("      ");
                    objString.append(StringUtil.indent((String)("" + this.getReservationInfo()[i]), (boolean)true));
                    if (i < this.getReservationInfo().length - 1) {
                        objString.append(",");
                    }
                    objString.append("\n");
                }
                objString.append("   ");
                objString.append("]");
            }
            objString.append(",\n");
            objString.append("   ");
            objString.append("featureInfo = ");
            if (this.getFeatureInfo() == null) {
                objString.append("null");
            } else {
                objString.append("(vim.FeatureInfo) [\n");
                for (i = 0; i < this.getFeatureInfo().length; ++i) {
                    objString.append("      ");
                    objString.append(StringUtil.indent((String)("" + this.getFeatureInfo()[i]), (boolean)true));
                    if (i < this.getFeatureInfo().length - 1) {
                        objString.append(",");
                    }
                    objString.append("\n");
                }
                objString.append("   ");
                objString.append("]");
            }
            objString.append("\n}");
            return objString.toString();
        }
    }

    @versionClass(value=version2.class)
    @wsdlName(value="LicenseManagerState")
    public static enum LicenseState {
        initializing,
        normal,
        marginal,
        fault;

    }

    @versionClass(value=version1.class)
    @wsdlName(value="LicenseSource")
    @data
    public static class LicenseSource
    extends DynamicDataImpl {
        private static final long serialVersionUID = 1L;

        public String toString() {
            StringBuilder objString = new StringBuilder(80);
            objString.append("(vim.LicenseSource) {\n");
            objString.append("   ");
            objString.append("dynamicType = ");
            objString.append(this.getDynamicType());
            objString.append(",\n");
            objString.append("   ");
            objString.append("dynamicProperty = ");
            if (this.getDynamicProperty() == null) {
                objString.append("null");
            } else {
                objString.append("(vmodl.DynamicProperty) [\n");
                for (int i = 0; i < this.getDynamicProperty().length; ++i) {
                    objString.append("      ");
                    objString.append(StringUtil.indent((String)("" + this.getDynamicProperty()[i]), (boolean)true));
                    if (i < this.getDynamicProperty().length - 1) {
                        objString.append(",");
                    }
                    objString.append("\n");
                }
                objString.append("   ");
                objString.append("]");
            }
            objString.append("\n}");
            return objString.toString();
        }
    }

    @versionClass(value=version1.class)
    @wsdlName(value="LicenseServerSource")
    @data
    @propertyOrder(value={"licenseServer"})
    public static class LicenseServer
    extends LicenseSource {
        private static final long serialVersionUID = 1L;
        public String licenseServer;

        public LicenseServer() {
        }

        public LicenseServer(String licenseServer) {
            this.licenseServer = licenseServer;
        }

        @versionClass(value=version1.class)
        public String getLicenseServer() {
            return this.licenseServer;
        }

        @versionClass(value=version1.class)
        public void setLicenseServer(String licenseServer) {
            this.licenseServer = licenseServer;
        }

        @Override
        public String toString() {
            StringBuilder objString = new StringBuilder(120);
            objString.append("(vim.LicenseServer) {\n");
            objString.append("   ");
            objString.append("dynamicType = ");
            objString.append(this.getDynamicType());
            objString.append(",\n");
            objString.append("   ");
            objString.append("dynamicProperty = ");
            if (this.getDynamicProperty() == null) {
                objString.append("null");
            } else {
                objString.append("(vmodl.DynamicProperty) [\n");
                for (int i = 0; i < this.getDynamicProperty().length; ++i) {
                    objString.append("      ");
                    objString.append(StringUtil.indent((String)("" + this.getDynamicProperty()[i]), (boolean)true));
                    if (i < this.getDynamicProperty().length - 1) {
                        objString.append(",");
                    }
                    objString.append("\n");
                }
                objString.append("   ");
                objString.append("]");
            }
            objString.append(",\n");
            objString.append("   ");
            objString.append("licenseServer = ");
            objString.append(this.getLicenseServer());
            objString.append("\n}");
            return objString.toString();
        }
    }

    @versionClass(value=version1.class)
    @wsdlName(value="LicenseManagerLicenseKey")
    public static enum LicenseKey {
        esxFull,
        esxVmtn,
        esxExpress,
        san,
        iscsi,
        nas,
        vsmp,
        backup,
        vc,
        vcExpress,
        esxHost,
        gsxHost,
        serverHost,
        drsPower,
        vmotion,
        drs,
        das;

    }

    @versionClass(value=version5.class)
    @wsdlName(value="LicenseManagerLicenseInfo")
    @data
    @propertyOrder(value={"licenseKey", "editionKey", "name", "total", "used", "costUnit", "properties", "labels"})
    public static class LicenseInfo
    extends DynamicDataImpl {
        private static final long serialVersionUID = 1L;
        public String licenseKey;
        public String editionKey;
        public String name;
        public int total;
        public Integer used;
        public String costUnit;
        public KeyAnyValue[] properties;
        public KeyValue[] labels;

        public LicenseInfo() {
        }

        public LicenseInfo(String licenseKey, String editionKey, String name2, int total, Integer used, String costUnit, KeyAnyValue[] properties, KeyValue[] labels) {
            this.licenseKey = licenseKey;
            this.editionKey = editionKey;
            this.name = name2;
            this.total = total;
            this.used = used;
            this.costUnit = costUnit;
            this.properties = properties;
            this.labels = labels;
        }

        @versionClass(value=version5.class)
        public String getLicenseKey() {
            return this.licenseKey;
        }

        @versionClass(value=version5.class)
        public void setLicenseKey(String licenseKey) {
            this.licenseKey = licenseKey;
        }

        @versionClass(value=version5.class)
        public String getEditionKey() {
            return this.editionKey;
        }

        @versionClass(value=version5.class)
        public void setEditionKey(String editionKey) {
            this.editionKey = editionKey;
        }

        @versionClass(value=version5.class)
        public String getName() {
            return this.name;
        }

        @versionClass(value=version5.class)
        public void setName(String name2) {
            this.name = name2;
        }

        @versionClass(value=version5.class)
        public int getTotal() {
            return this.total;
        }

        @versionClass(value=version5.class)
        public void setTotal(int total) {
            this.total = total;
        }

        @optional
        @versionClass(value=version5.class)
        public Integer getUsed() {
            return this.used;
        }

        @optional
        @versionClass(value=version5.class)
        public void setUsed(Integer used) {
            this.used = used;
        }

        @versionClass(value=version5.class)
        public String getCostUnit() {
            return this.costUnit;
        }

        @versionClass(value=version5.class)
        public void setCostUnit(String costUnit) {
            this.costUnit = costUnit;
        }

        @map
        @optional
        @versionClass(value=version5.class)
        public KeyAnyValue[] getProperties() {
            return this.properties;
        }

        @map
        @optional
        @versionClass(value=version5.class)
        public void setProperties(KeyAnyValue[] properties) {
            this.properties = properties;
        }

        @map
        @optional
        @versionClass(value=version5.class)
        public KeyValue[] getLabels() {
            return this.labels;
        }

        @map
        @optional
        @versionClass(value=version5.class)
        public void setLabels(KeyValue[] labels) {
            this.labels = labels;
        }

        public String toString() {
            int i;
            StringBuilder objString = new StringBuilder(400);
            objString.append("(vim.LicenseInfo) {\n");
            objString.append("   ");
            objString.append("dynamicType = ");
            objString.append(this.getDynamicType());
            objString.append(",\n");
            objString.append("   ");
            objString.append("dynamicProperty = ");
            if (this.getDynamicProperty() == null) {
                objString.append("null");
            } else {
                objString.append("(vmodl.DynamicProperty) [\n");
                for (i = 0; i < this.getDynamicProperty().length; ++i) {
                    objString.append("      ");
                    objString.append(StringUtil.indent((String)("" + this.getDynamicProperty()[i]), (boolean)true));
                    if (i < this.getDynamicProperty().length - 1) {
                        objString.append(",");
                    }
                    objString.append("\n");
                }
                objString.append("   ");
                objString.append("]");
            }
            objString.append(",\n");
            objString.append("   ");
            objString.append("licenseKey = ");
            objString.append(this.getLicenseKey());
            objString.append(",\n");
            objString.append("   ");
            objString.append("editionKey = ");
            objString.append(this.getEditionKey());
            objString.append(",\n");
            objString.append("   ");
            objString.append("name = ");
            objString.append(this.getName());
            objString.append(",\n");
            objString.append("   ");
            objString.append("total = ");
            objString.append(this.getTotal());
            objString.append(",\n");
            objString.append("   ");
            objString.append("used = ");
            objString.append(this.getUsed());
            objString.append(",\n");
            objString.append("   ");
            objString.append("costUnit = ");
            objString.append(this.getCostUnit());
            objString.append(",\n");
            objString.append("   ");
            objString.append("properties = ");
            if (this.getProperties() == null) {
                objString.append("null");
            } else {
                objString.append("(vmodl.KeyAnyValue) [\n");
                for (i = 0; i < this.getProperties().length; ++i) {
                    objString.append("      ");
                    objString.append(StringUtil.indent((String)("" + this.getProperties()[i]), (boolean)true));
                    if (i < this.getProperties().length - 1) {
                        objString.append(",");
                    }
                    objString.append("\n");
                }
                objString.append("   ");
                objString.append("]");
            }
            objString.append(",\n");
            objString.append("   ");
            objString.append("labels = ");
            if (this.getLabels() == null) {
                objString.append("null");
            } else {
                objString.append("(vim.KeyValue) [\n");
                for (i = 0; i < this.getLabels().length; ++i) {
                    objString.append("      ");
                    objString.append(StringUtil.indent((String)("" + this.getLabels()[i]), (boolean)true));
                    if (i < this.getLabels().length - 1) {
                        objString.append(",");
                    }
                    objString.append("\n");
                }
                objString.append("   ");
                objString.append("]");
            }
            objString.append("\n}");
            return objString.toString();
        }
    }

    @versionClass(value=version7.class)
    @wsdlName(value="HostLicensableResourceInfo")
    @data
    @propertyOrder(value={"resource"})
    public static class LicensableResourceInfo
    extends DynamicDataImpl {
        private static final long serialVersionUID = 1L;
        public KeyAnyValue[] resource;

        public LicensableResourceInfo() {
        }

        public LicensableResourceInfo(KeyAnyValue[] resource) {
            this.resource = resource;
        }

        @map
        @versionClass(value=version7.class)
        public KeyAnyValue[] getResource() {
            return this.resource;
        }

        @map
        @versionClass(value=version7.class)
        public void setResource(KeyAnyValue[] resource) {
            this.resource = resource;
        }

        public String toString() {
            int i;
            StringBuilder objString = new StringBuilder(120);
            objString.append("(vim.LicensableResourceInfo) {\n");
            objString.append("   ");
            objString.append("dynamicType = ");
            objString.append(this.getDynamicType());
            objString.append(",\n");
            objString.append("   ");
            objString.append("dynamicProperty = ");
            if (this.getDynamicProperty() == null) {
                objString.append("null");
            } else {
                objString.append("(vmodl.DynamicProperty) [\n");
                for (i = 0; i < this.getDynamicProperty().length; ++i) {
                    objString.append("      ");
                    objString.append(StringUtil.indent((String)("" + this.getDynamicProperty()[i]), (boolean)true));
                    if (i < this.getDynamicProperty().length - 1) {
                        objString.append(",");
                    }
                    objString.append("\n");
                }
                objString.append("   ");
                objString.append("]");
            }
            objString.append(",\n");
            objString.append("   ");
            objString.append("resource = ");
            if (this.getResource() == null) {
                objString.append("null");
            } else {
                objString.append("(vmodl.KeyAnyValue) [\n");
                for (i = 0; i < this.getResource().length; ++i) {
                    objString.append("      ");
                    objString.append(StringUtil.indent((String)("" + this.getResource()[i]), (boolean)true));
                    if (i < this.getResource().length - 1) {
                        objString.append(",");
                    }
                    objString.append("\n");
                }
                objString.append("   ");
                objString.append("]");
            }
            objString.append("\n}");
            return objString.toString();
        }

        @versionClass(value=version7.class)
        @wsdlName(value="HostLicensableResourceKey")
        public static enum ResourceKey {
            numCpuPackages,
            numCpuCores,
            memorySize,
            memoryForVms,
            numVmsStarted,
            numVmsStarting;

        }
    }

    @versionClass(value=version1.class)
    @wsdlName(value="LicenseFeatureInfo")
    @data
    @propertyOrder(value={"key", "featureName", "featureDescription", "state", "costUnit", "sourceRestriction", "dependentKey", "edition", "expiresOn"})
    public static class FeatureInfo
    extends DynamicDataImpl {
        private static final long serialVersionUID = 1L;
        public String key;
        public String featureName;
        public String featureDescription;
        public State state;
        public String costUnit;
        public String sourceRestriction;
        public String[] dependentKey;
        public Boolean edition;
        public Calendar expiresOn;

        public FeatureInfo() {
        }

        public FeatureInfo(String key, String featureName, String featureDescription, State state, String costUnit, String sourceRestriction, String[] dependentKey, Boolean edition, Calendar expiresOn) {
            this.key = key;
            this.featureName = featureName;
            this.featureDescription = featureDescription;
            this.state = state;
            this.costUnit = costUnit;
            this.sourceRestriction = sourceRestriction;
            this.dependentKey = dependentKey;
            this.edition = edition;
            this.expiresOn = expiresOn;
        }

        @versionClass(value=version1.class)
        public String getKey() {
            return this.key;
        }

        @versionClass(value=version1.class)
        public void setKey(String key) {
            this.key = key;
        }

        @versionClass(value=version1.class)
        @localizable
        public String getFeatureName() {
            return this.featureName;
        }

        @versionClass(value=version1.class)
        @localizable
        public void setFeatureName(String featureName) {
            this.featureName = featureName;
        }

        @optional
        @versionClass(value=version2.class)
        @localizable
        public String getFeatureDescription() {
            return this.featureDescription;
        }

        @optional
        @versionClass(value=version2.class)
        @localizable
        public void setFeatureDescription(String featureDescription) {
            this.featureDescription = featureDescription;
        }

        @optional
        @versionClass(value=version1.class)
        public State getState() {
            return this.state;
        }

        @optional
        @versionClass(value=version1.class)
        public void setState(State state) {
            this.state = state;
        }

        @versionClass(value=version1.class)
        public String getCostUnit() {
            return this.costUnit;
        }

        @versionClass(value=version1.class)
        public void setCostUnit(String costUnit) {
            this.costUnit = costUnit;
        }

        @optional
        @versionClass(value=version2.class)
        public String getSourceRestriction() {
            return this.sourceRestriction;
        }

        @optional
        @versionClass(value=version2.class)
        public void setSourceRestriction(String sourceRestriction) {
            this.sourceRestriction = sourceRestriction;
        }

        @map
        @optional
        @versionClass(value=version2.class)
        public String[] getDependentKey() {
            return this.dependentKey;
        }

        @map
        @optional
        @versionClass(value=version2.class)
        public void setDependentKey(String[] dependentKey) {
            this.dependentKey = dependentKey;
        }

        @optional
        @versionClass(value=version2.class)
        @Deprecated
        public Boolean isEdition() {
            return this.edition;
        }

        @optional
        @versionClass(value=version2.class)
        public Boolean getEdition() {
            return this.edition;
        }

        @optional
        @versionClass(value=version2.class)
        public void setEdition(Boolean edition) {
            this.edition = edition;
        }

        @optional
        @versionClass(value=version2.class)
        public Calendar getExpiresOn() {
            return this.expiresOn;
        }

        @optional
        @versionClass(value=version2.class)
        public void setExpiresOn(Calendar expiresOn) {
            this.expiresOn = expiresOn;
        }

        public String toString() {
            int i;
            StringBuilder objString = new StringBuilder(440);
            objString.append("(vim.FeatureInfo) {\n");
            objString.append("   ");
            objString.append("dynamicType = ");
            objString.append(this.getDynamicType());
            objString.append(",\n");
            objString.append("   ");
            objString.append("dynamicProperty = ");
            if (this.getDynamicProperty() == null) {
                objString.append("null");
            } else {
                objString.append("(vmodl.DynamicProperty) [\n");
                for (i = 0; i < this.getDynamicProperty().length; ++i) {
                    objString.append("      ");
                    objString.append(StringUtil.indent((String)("" + this.getDynamicProperty()[i]), (boolean)true));
                    if (i < this.getDynamicProperty().length - 1) {
                        objString.append(",");
                    }
                    objString.append("\n");
                }
                objString.append("   ");
                objString.append("]");
            }
            objString.append(",\n");
            objString.append("   ");
            objString.append("key = ");
            objString.append(this.getKey());
            objString.append(",\n");
            objString.append("   ");
            objString.append("featureName = ");
            objString.append(this.getFeatureName());
            objString.append(",\n");
            objString.append("   ");
            objString.append("featureDescription = ");
            objString.append(this.getFeatureDescription());
            objString.append(",\n");
            objString.append("   ");
            objString.append("state = ");
            objString.append((Object)this.getState());
            objString.append(",\n");
            objString.append("   ");
            objString.append("costUnit = ");
            objString.append(this.getCostUnit());
            objString.append(",\n");
            objString.append("   ");
            objString.append("sourceRestriction = ");
            objString.append(this.getSourceRestriction());
            objString.append(",\n");
            objString.append("   ");
            objString.append("dependentKey = ");
            if (this.getDependentKey() == null) {
                objString.append("null");
            } else {
                objString.append("(STRING) [\n");
                for (i = 0; i < this.getDependentKey().length; ++i) {
                    objString.append("      ");
                    objString.append(this.getDependentKey()[i]);
                    if (i < this.getDependentKey().length - 1) {
                        objString.append(",");
                    }
                    objString.append("\n");
                }
                objString.append("   ");
                objString.append("]");
            }
            objString.append(",\n");
            objString.append("   ");
            objString.append("edition = ");
            objString.append(this.isEdition());
            objString.append(",\n");
            objString.append("   ");
            objString.append("expiresOn = ");
            objString.append(this.getExpiresOn());
            objString.append("\n}");
            return objString.toString();
        }

        @versionClass(value=version1.class)
        @wsdlName(value="LicenseFeatureInfoState")
        public static enum State {
            enabled,
            disabled,
            optional;

        }

        @versionClass(value=version2.class)
        @wsdlName(value="LicenseFeatureInfoSourceRestriction")
        public static enum SourceRestriction {
            unrestricted,
            served,
            file;

        }

        @versionClass(value=version1.class)
        @wsdlName(value="LicenseFeatureInfoUnit")
        public static enum CostUnit {
            host,
            cpuCore,
            cpuPackage,
            server,
            vm;

        }
    }

    @versionClass(value=version2.class)
    @wsdlName(value="EvaluationLicenseSource")
    @data
    @propertyOrder(value={"remainingHours"})
    public static class EvaluationLicense
    extends LicenseSource {
        private static final long serialVersionUID = 1L;
        public Long remainingHours;

        public EvaluationLicense() {
        }

        public EvaluationLicense(Long remainingHours) {
            this.remainingHours = remainingHours;
        }

        @optional
        @versionClass(value=version2.class)
        public Long getRemainingHours() {
            return this.remainingHours;
        }

        @optional
        @versionClass(value=version2.class)
        public void setRemainingHours(Long remainingHours) {
            this.remainingHours = remainingHours;
        }

        @Override
        public String toString() {
            StringBuilder objString = new StringBuilder(120);
            objString.append("(vim.EvaluationLicense) {\n");
            objString.append("   ");
            objString.append("dynamicType = ");
            objString.append(this.getDynamicType());
            objString.append(",\n");
            objString.append("   ");
            objString.append("dynamicProperty = ");
            if (this.getDynamicProperty() == null) {
                objString.append("null");
            } else {
                objString.append("(vmodl.DynamicProperty) [\n");
                for (int i = 0; i < this.getDynamicProperty().length; ++i) {
                    objString.append("      ");
                    objString.append(StringUtil.indent((String)("" + this.getDynamicProperty()[i]), (boolean)true));
                    if (i < this.getDynamicProperty().length - 1) {
                        objString.append(",");
                    }
                    objString.append("\n");
                }
                objString.append("   ");
                objString.append("]");
            }
            objString.append(",\n");
            objString.append("   ");
            objString.append("remainingHours = ");
            objString.append(this.getRemainingHours());
            objString.append("\n}");
            return objString.toString();
        }
    }

    @versionClass(value=version5.class)
    @wsdlName(value="LicenseManagerEvaluationInfo")
    @data
    @propertyOrder(value={"properties"})
    public static class EvaluationInfo
    extends DynamicDataImpl {
        private static final long serialVersionUID = 1L;
        public KeyAnyValue[] properties;

        public EvaluationInfo() {
        }

        public EvaluationInfo(KeyAnyValue[] properties) {
            this.properties = properties;
        }

        @map
        @versionClass(value=version5.class)
        public KeyAnyValue[] getProperties() {
            return this.properties;
        }

        @map
        @versionClass(value=version5.class)
        public void setProperties(KeyAnyValue[] properties) {
            this.properties = properties;
        }

        public String toString() {
            int i;
            StringBuilder objString = new StringBuilder(120);
            objString.append("(vim.EvaluationInfo) {\n");
            objString.append("   ");
            objString.append("dynamicType = ");
            objString.append(this.getDynamicType());
            objString.append(",\n");
            objString.append("   ");
            objString.append("dynamicProperty = ");
            if (this.getDynamicProperty() == null) {
                objString.append("null");
            } else {
                objString.append("(vmodl.DynamicProperty) [\n");
                for (i = 0; i < this.getDynamicProperty().length; ++i) {
                    objString.append("      ");
                    objString.append(StringUtil.indent((String)("" + this.getDynamicProperty()[i]), (boolean)true));
                    if (i < this.getDynamicProperty().length - 1) {
                        objString.append(",");
                    }
                    objString.append("\n");
                }
                objString.append("   ");
                objString.append("]");
            }
            objString.append(",\n");
            objString.append("   ");
            objString.append("properties = ");
            if (this.getProperties() == null) {
                objString.append("null");
            } else {
                objString.append("(vmodl.KeyAnyValue) [\n");
                for (i = 0; i < this.getProperties().length; ++i) {
                    objString.append("      ");
                    objString.append(StringUtil.indent((String)("" + this.getProperties()[i]), (boolean)true));
                    if (i < this.getProperties().length - 1) {
                        objString.append(",");
                    }
                    objString.append("\n");
                }
                objString.append("   ");
                objString.append("]");
            }
            objString.append("\n}");
            return objString.toString();
        }
    }

    @versionClass(value=version2.class)
    @wsdlName(value="LicenseDiagnostics")
    @data
    @propertyOrder(value={"sourceLastChanged", "sourceLost", "sourceLatency", "licenseRequests", "licenseRequestFailures", "licenseFeatureUnknowns", "opState", "lastStatusUpdate", "opFailureMessage"})
    public static class DiagnosticInfo
    extends DynamicDataImpl {
        private static final long serialVersionUID = 1L;
        public Calendar sourceLastChanged;
        public String sourceLost;
        public float sourceLatency;
        public String licenseRequests;
        public String licenseRequestFailures;
        public String licenseFeatureUnknowns;
        public LicenseState opState;
        public Calendar lastStatusUpdate;
        public String opFailureMessage;

        public DiagnosticInfo() {
        }

        public DiagnosticInfo(Calendar sourceLastChanged, String sourceLost, float sourceLatency, String licenseRequests, String licenseRequestFailures, String licenseFeatureUnknowns, LicenseState opState, Calendar lastStatusUpdate, String opFailureMessage) {
            this.sourceLastChanged = sourceLastChanged;
            this.sourceLost = sourceLost;
            this.sourceLatency = sourceLatency;
            this.licenseRequests = licenseRequests;
            this.licenseRequestFailures = licenseRequestFailures;
            this.licenseFeatureUnknowns = licenseFeatureUnknowns;
            this.opState = opState;
            this.lastStatusUpdate = lastStatusUpdate;
            this.opFailureMessage = opFailureMessage;
        }

        @versionClass(value=version2.class)
        public Calendar getSourceLastChanged() {
            return this.sourceLastChanged;
        }

        @versionClass(value=version2.class)
        public void setSourceLastChanged(Calendar sourceLastChanged) {
            this.sourceLastChanged = sourceLastChanged;
        }

        @versionClass(value=version2.class)
        public String getSourceLost() {
            return this.sourceLost;
        }

        @versionClass(value=version2.class)
        public void setSourceLost(String sourceLost) {
            this.sourceLost = sourceLost;
        }

        @versionClass(value=version2.class)
        public float getSourceLatency() {
            return this.sourceLatency;
        }

        @versionClass(value=version2.class)
        public void setSourceLatency(float sourceLatency) {
            this.sourceLatency = sourceLatency;
        }

        @versionClass(value=version2.class)
        public String getLicenseRequests() {
            return this.licenseRequests;
        }

        @versionClass(value=version2.class)
        public void setLicenseRequests(String licenseRequests) {
            this.licenseRequests = licenseRequests;
        }

        @versionClass(value=version2.class)
        public String getLicenseRequestFailures() {
            return this.licenseRequestFailures;
        }

        @versionClass(value=version2.class)
        public void setLicenseRequestFailures(String licenseRequestFailures) {
            this.licenseRequestFailures = licenseRequestFailures;
        }

        @versionClass(value=version2.class)
        public String getLicenseFeatureUnknowns() {
            return this.licenseFeatureUnknowns;
        }

        @versionClass(value=version2.class)
        public void setLicenseFeatureUnknowns(String licenseFeatureUnknowns) {
            this.licenseFeatureUnknowns = licenseFeatureUnknowns;
        }

        @versionClass(value=version2.class)
        public LicenseState getOpState() {
            return this.opState;
        }

        @versionClass(value=version2.class)
        public void setOpState(LicenseState opState) {
            this.opState = opState;
        }

        @versionClass(value=version2.class)
        public Calendar getLastStatusUpdate() {
            return this.lastStatusUpdate;
        }

        @versionClass(value=version2.class)
        public void setLastStatusUpdate(Calendar lastStatusUpdate) {
            this.lastStatusUpdate = lastStatusUpdate;
        }

        @versionClass(value=version2.class)
        @localizable
        public String getOpFailureMessage() {
            return this.opFailureMessage;
        }

        @versionClass(value=version2.class)
        @localizable
        public void setOpFailureMessage(String opFailureMessage) {
            this.opFailureMessage = opFailureMessage;
        }

        public String toString() {
            StringBuilder objString = new StringBuilder(440);
            objString.append("(vim.DiagnosticInfo) {\n");
            objString.append("   ");
            objString.append("dynamicType = ");
            objString.append(this.getDynamicType());
            objString.append(",\n");
            objString.append("   ");
            objString.append("dynamicProperty = ");
            if (this.getDynamicProperty() == null) {
                objString.append("null");
            } else {
                objString.append("(vmodl.DynamicProperty) [\n");
                for (int i = 0; i < this.getDynamicProperty().length; ++i) {
                    objString.append("      ");
                    objString.append(StringUtil.indent((String)("" + this.getDynamicProperty()[i]), (boolean)true));
                    if (i < this.getDynamicProperty().length - 1) {
                        objString.append(",");
                    }
                    objString.append("\n");
                }
                objString.append("   ");
                objString.append("]");
            }
            objString.append(",\n");
            objString.append("   ");
            objString.append("sourceLastChanged = ");
            objString.append(this.getSourceLastChanged());
            objString.append(",\n");
            objString.append("   ");
            objString.append("sourceLost = ");
            objString.append(this.getSourceLost());
            objString.append(",\n");
            objString.append("   ");
            objString.append("sourceLatency = ");
            objString.append(this.getSourceLatency());
            objString.append(",\n");
            objString.append("   ");
            objString.append("licenseRequests = ");
            objString.append(this.getLicenseRequests());
            objString.append(",\n");
            objString.append("   ");
            objString.append("licenseRequestFailures = ");
            objString.append(this.getLicenseRequestFailures());
            objString.append(",\n");
            objString.append("   ");
            objString.append("licenseFeatureUnknowns = ");
            objString.append(this.getLicenseFeatureUnknowns());
            objString.append(",\n");
            objString.append("   ");
            objString.append("opState = ");
            objString.append((Object)this.getOpState());
            objString.append(",\n");
            objString.append("   ");
            objString.append("lastStatusUpdate = ");
            objString.append(this.getLastStatusUpdate());
            objString.append(",\n");
            objString.append("   ");
            objString.append("opFailureMessage = ");
            objString.append(this.getOpFailureMessage());
            objString.append("\n}");
            return objString.toString();
        }
    }

    @versionClass(value=version1.class)
    @wsdlName(value="LicenseAvailabilityInfo")
    @data
    @propertyOrder(value={"feature", "total", "available"})
    public static class AvailabilityInfo
    extends DynamicDataImpl {
        private static final long serialVersionUID = 1L;
        public FeatureInfo feature;
        public int total;
        public int available;

        public AvailabilityInfo() {
        }

        public AvailabilityInfo(FeatureInfo feature, int total, int available) {
            this.feature = feature;
            this.total = total;
            this.available = available;
        }

        @versionClass(value=version1.class)
        public FeatureInfo getFeature() {
            return this.feature;
        }

        @versionClass(value=version1.class)
        public void setFeature(FeatureInfo feature) {
            this.feature = feature;
        }

        @versionClass(value=version1.class)
        public int getTotal() {
            return this.total;
        }

        @versionClass(value=version1.class)
        public void setTotal(int total) {
            this.total = total;
        }

        @versionClass(value=version1.class)
        public int getAvailable() {
            return this.available;
        }

        @versionClass(value=version1.class)
        public void setAvailable(int available) {
            this.available = available;
        }

        public String toString() {
            StringBuilder objString = new StringBuilder(200);
            objString.append("(vim.AvailabilityInfo) {\n");
            objString.append("   ");
            objString.append("dynamicType = ");
            objString.append(this.getDynamicType());
            objString.append(",\n");
            objString.append("   ");
            objString.append("dynamicProperty = ");
            if (this.getDynamicProperty() == null) {
                objString.append("null");
            } else {
                objString.append("(vmodl.DynamicProperty) [\n");
                for (int i = 0; i < this.getDynamicProperty().length; ++i) {
                    objString.append("      ");
                    objString.append(StringUtil.indent((String)("" + this.getDynamicProperty()[i]), (boolean)true));
                    if (i < this.getDynamicProperty().length - 1) {
                        objString.append(",");
                    }
                    objString.append("\n");
                }
                objString.append("   ");
                objString.append("]");
            }
            objString.append(",\n");
            objString.append("   ");
            objString.append("feature = ");
            if (this.getFeature() == null) {
                objString.append("null");
            } else {
                objString.append(StringUtil.indent((String)("" + this.getFeature()), (boolean)false));
            }
            objString.append(",\n");
            objString.append("   ");
            objString.append("total = ");
            objString.append(this.getTotal());
            objString.append(",\n");
            objString.append("   ");
            objString.append("available = ");
            objString.append(this.getAvailable());
            objString.append("\n}");
            return objString.toString();
        }
    }
}

