/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.sso.client.impl.processors.request;

import com.vmware.vim.sso.client.TokenSpec;
import com.vmware.vim.sso.client.UserCertificateHandler;
import com.vmware.vim.sso.client.impl.SoapMessage;
import com.vmware.vim.sso.client.impl.exception.ParserException;
import com.vmware.vim.sso.client.impl.processors.request.AcquireTokenRequestBuilder;
import com.vmware.vim.sso.client.util.JAXBExtractor;
import com.vmware.vim.sso.client.util.codec.Base64;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import javax.xml.bind.JAXBContext;
import org.oasis_open.docs.ws_sx.ws_trust._200512.RequestSecurityTokenType;
import org.oasis_open.docs.wss._2004._01.oasis_200401_wss_wssecurity_secext_1_0.BinarySecurityTokenType;
import org.oasis_open.docs.wss._2004._01.oasis_200401_wss_wssecurity_secext_1_0.SecurityHeaderType;
import org.oasis_open.docs.wss._2004._01.oasis_200401_wss_wssecurity_secext_1_0.SignatureAlgorithmType;
import org.oasis_open.docs.wss._2004._01.oasis_200401_wss_wssecurity_secext_1_0.UserCertificateTokenType;
import org.oasis_open.docs.wss._2004._01.oasis_200401_wss_wssecurity_utility_1_0.TimestampType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3._2000._09.xmldsig_.ObjectFactory;
import org.w3._2000._09.xmldsig_.SignatureValueType;

public class AcquireTokenByUserCertRequestBuilder
extends AcquireTokenRequestBuilder {
    private final Logger logger = LoggerFactory.getLogger(AcquireTokenByUserCertRequestBuilder.class);
    private final X509Certificate userCertificate;
    private final UserCertificateHandler userCertificateHandler;

    public AcquireTokenByUserCertRequestBuilder(X509Certificate userCertificate, UserCertificateHandler userCertificateHandler, TokenSpec tokenSpec, boolean hokConfirmation, JAXBContext jaxbContext, int requestValidityInSeconds) {
        super(tokenSpec, hokConfirmation, jaxbContext, requestValidityInSeconds);
        this.userCertificate = userCertificate;
        this.userCertificateHandler = userCertificateHandler;
    }

    @Override
    protected void postProcessAcquireRequest(SoapMessage message) throws ParserException {
    }

    @Override
    protected void addRequestData(RequestSecurityTokenType request, org.oasis_open.docs.ws_sx.ws_trust._200512.ObjectFactory wstFactory) {
    }

    @Override
    protected void addSecurityHeaderInfo(SecurityHeaderType header) {
        org.oasis_open.docs.wss._2004._01.oasis_200401_wss_wssecurity_secext_1_0.ObjectFactory wssObjFactory = new org.oasis_open.docs.wss._2004._01.oasis_200401_wss_wssecurity_secext_1_0.ObjectFactory();
        TimestampType timeStamp = JAXBExtractor.extractFromSecurityHeader(header, TimestampType.class);
        header.getAny().add(wssObjFactory.createUserCertificateToken(this.createUserCertificateToken(timeStamp)));
    }

    private UserCertificateTokenType createUserCertificateToken(TimestampType timestamp) {
        org.oasis_open.docs.wss._2004._01.oasis_200401_wss_wssecurity_secext_1_0.ObjectFactory wssObjFactory = new org.oasis_open.docs.wss._2004._01.oasis_200401_wss_wssecurity_secext_1_0.ObjectFactory();
        UserCertificateTokenType userCertiticateToken = wssObjFactory.createUserCertificateTokenType();
        try {
            BinarySecurityTokenType binarySecurityToken = wssObjFactory.createBinarySecurityTokenType();
            binarySecurityToken.setValueType("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509v3");
            binarySecurityToken.setEncodingType("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#Base64Binary");
            binarySecurityToken.setValue(new String(Base64.encodeBase64(this.userCertificate.getEncoded())));
            userCertiticateToken.setUserCertificate(binarySecurityToken);
        }
        catch (CertificateEncodingException e) {
            throw new IllegalArgumentException("Failed to encode the certificate", e);
        }
        ObjectFactory xmldsigObjFactory = new ObjectFactory();
        SignatureValueType signatureValueType = xmldsigObjFactory.createSignatureValueType();
        String signedInfo = timestamp.getCreated().getValue() + timestamp.getExpires().getValue();
        userCertiticateToken.setSignatureInfo(signedInfo);
        userCertiticateToken.setSignatureAlgorithm(SignatureAlgorithmType.SHA_256_WITH_RSA);
        signatureValueType.setValue(this.userCertificateHandler.signBySHA256WithRSA(signedInfo.getBytes()));
        userCertiticateToken.setSignatureValue(signatureValueType);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Username token created");
        }
        return userCertiticateToken;
    }
}

