/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.infrastructure.websockets.endpoint;

import com.vmware.dr.ui.tools.reactive.Promise;
import com.vmware.dr.ui.tools.reactive.Stream;
import com.vmware.dr.ui.tools.reactive.Subscriber;
import com.vmware.dr.ui.tools.reactive.impl.CachingStream;
import com.vmware.dr.ui.tools.reactive.impl.PromiseImpl;
import com.vmware.dr.ui.tools.reactive.impl.Promises;
import com.vmware.dr.ui.tools.utilities.L10NHelper;
import com.vmware.dr.ui.tools.utilities.OpIdAccessor;
import com.vmware.srm.client.infrastructure.authentication.SessionWrapper;
import com.vmware.srm.client.infrastructure.http.SerializationUtil;
import com.vmware.srm.client.infrastructure.requestHandlers.protocol.DrClientProtocolException;
import com.vmware.srm.client.infrastructure.requestHandlers.protocol.DrData;
import com.vmware.srm.client.infrastructure.requestHandlers.protocol.impl.DrFaultImpl;
import com.vmware.srm.client.infrastructure.websockets.requesthandlers.DrWsRequestHandler;
import com.vmware.srm.client.infrastructure.websockets.requesthandlers.lookup.DrWsHandlerLookup;
import com.vmware.srm.client.infrastructure.websockets.requesthandlers.protocol.data.DrWsRequest;
import com.vmware.srm.client.infrastructure.websockets.requesthandlers.protocol.data.DrWsResponse;
import com.vmware.srm.client.topology.client.Topology;
import com.vmware.srm.client.topology.client.view.availability.ExtensionServersView;
import com.vmware.srm.client.topology.impl.core.TopologyImpl;
import com.vmware.srm.client.topology.impl.init.Config;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Locale;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.servlet.http.HttpSession;
import javax.websocket.CloseReason;
import javax.websocket.Endpoint;
import javax.websocket.EndpointConfig;
import javax.websocket.MessageHandler;
import javax.websocket.RemoteEndpoint;
import javax.websocket.SendHandler;
import javax.websocket.SendResult;
import javax.websocket.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DrWsServerEndpoint
extends Endpoint {
    private static Logger LOGGER = LoggerFactory.getLogger(DrWsServerEndpoint.class);
    private static final DrWsServerEndpoint INSTANCE = new DrWsServerEndpoint();

    public static DrWsServerEndpoint get() {
        return INSTANCE;
    }

    private static void closeSession(Session session, CloseReason.CloseCode closeCode, String reason) {
        try {
            session.close(new CloseReason(closeCode, reason));
        }
        catch (IOException e) {
            LOGGER.warn("Close on ws session '{}' failed.", (Object)session, (Object)e);
        }
    }

    private DrWsServerEndpoint() {
    }

    public void onOpen(Session session, EndpointConfig config) {
        LOGGER.info("Opening ws session '{}'", (Object)session);
        if (!session.isSecure()) {
            LOGGER.warn("Session '{}' is not secure.", (Object)session);
            DrWsServerEndpoint.closeSession(session, (CloseReason.CloseCode)CloseReason.CloseCodes.CANNOT_ACCEPT, "Insecure session.");
            return;
        }
        HttpSession httpSession = (HttpSession)session.getUserProperties().get("dr.ws.httpsession");
        if (httpSession == null || !this.addWsSession(httpSession, session)) {
            LOGGER.error("Invalid http session for '{}'", (Object)session);
            DrWsServerEndpoint.closeSession(session, (CloseReason.CloseCode)CloseReason.CloseCodes.UNEXPECTED_CONDITION, "Invalid http session");
            return;
        }
        TopologyImpl topology = SessionWrapper.getTopology(httpSession);
        if (topology == null || !topology.isAuthenticated()) {
            LOGGER.warn("Session is not authenticated.");
            DrWsServerEndpoint.closeSession(session, (CloseReason.CloseCode)CloseReason.CloseCodes.UNEXPECTED_CONDITION, "Unauthenticated http session");
            return;
        }
        Locale locale = SessionWrapper.getWsLocale(httpSession);
        if (locale == null) {
            LOGGER.warn("Web sockets locale is not set. Using the default locale (en_US).");
            locale = Locale.US;
        }
        session.setMaxBinaryMessageBufferSize(Config.get().getMaxRequestSize());
        session.addMessageHandler(String.class, (MessageHandler.Whole)new DrWsMessageHandler(session, (Topology)topology, locale));
    }

    public void onClose(Session session, CloseReason closeReason) {
        LOGGER.info("Closing ws session '{}'", (Object)session);
        HttpSession httpSession = (HttpSession)session.getUserProperties().get("dr.ws.httpsession");
        if (httpSession == null) {
            return;
        }
        try {
            SessionWrapper.removeWsSession(httpSession, session);
        }
        catch (IllegalStateException illState) {
            LOGGER.warn("Http session for ws session '{}' invalid.", (Object)session);
        }
        try {
            DrWsMessageHandler mh = session.getMessageHandlers().stream().filter(DrWsMessageHandler.class::isInstance).findFirst().map(DrWsMessageHandler.class::cast).orElse(null);
            if (mh == null) {
                LOGGER.warn("No message handler found for '{}'", (Object)session);
                return;
            }
            mh.stop();
        }
        catch (Exception exc) {
            LOGGER.warn("Failed to stop message handler for '{}'", (Object)session);
        }
    }

    public void onError(Session session, Throwable throwable) {
        LOGGER.warn("Error with session '{}'.", (Object)session, (Object)throwable);
    }

    private boolean addWsSession(HttpSession httpSession, Session wsSession) {
        try {
            return SessionWrapper.addWsSession(httpSession, wsSession);
        }
        catch (IllegalStateException illState) {
            LOGGER.warn("Http session for ws session '{}' invalid.", (Object)wsSession);
            return false;
        }
    }

    private static class DrWsMessageHandler
    implements MessageHandler.Whole<String> {
        private final Session _wsSession;
        private final Topology _topology;
        private final AsyncScheduler _scheduler;
        private final Locale _locale;
        private final ConcurrentMap<Long, ControlStream> _controlStreamBySequence = new ConcurrentHashMap<Long, ControlStream>();
        private final AtomicBoolean _stoppedRef = new AtomicBoolean(false);

        private static String generateOpId() {
            return UUID.randomUUID().toString();
        }

        DrWsMessageHandler(Session wsSession, Topology topology, Locale locale) {
            this._wsSession = wsSession;
            this._topology = topology;
            this._locale = locale;
            RemoteEndpoint.Async async = this._wsSession.getAsyncRemote();
            async.setSendTimeout(Config.get().getSocketTimeout());
            this._scheduler = new AsyncScheduler(async);
        }

        void stop() {
            if (!this._stoppedRef.compareAndSet(false, true)) {
                return;
            }
            this._controlStreamBySequence.forEach((ignored, control) -> control.stop());
            this._controlStreamBySequence.clear();
        }

        public void onMessage(String message) {
            DrWsRequest request;
            try {
                request = SerializationUtil.fromString(message, DrWsRequest.class);
            }
            catch (IOException e) {
                LOGGER.warn("Failed to deserialize message", (Throwable)e);
                throw new DrClientProtocolException(e.getLocalizedMessage(), e);
            }
            if (request.isStop()) {
                ControlStream controlStream = (ControlStream)((Object)this._controlStreamBySequence.remove(request.getSequence()));
                if (controlStream != null) {
                    controlStream.stop();
                }
                return;
            }
            ControlStream controlStream = new ControlStream();
            if (this._controlStreamBySequence.putIfAbsent(request.getSequence(), controlStream) != null) {
                RuntimeException exc = new RuntimeException("Existing request for sequence '" + request.getSequence() + "'.");
                this.handleError(exc, controlStream, request);
                return;
            }
            if (this._stoppedRef.get()) {
                this._controlStreamBySequence.remove(request.getSequence());
                controlStream.stop();
                return;
            }
            controlStream.consume(signal -> {
                if (signal == DrWsRequestHandler.Signal.Stop) {
                    this._controlStreamBySequence.remove(request.getSequence());
                }
            });
            DrWsRequestHandler<?, ?> handler = DrWsHandlerLookup.get().lookup(request.getPath());
            if (handler == null) {
                RuntimeException exc = new RuntimeException("No handler for path '" + request.getPath() + "' found.");
                this.handleError(exc, controlStream, request);
                return;
            }
            this.startSendStreamResult(handler, request, controlStream);
        }

        private Promise<Void> sendNext(DrData next, DrWsRequest request, boolean last) {
            return this.sendResponse(new DrWsResponse(request.getSequence(), next, last), request);
        }

        private Promise<Void> sendError(Exception exc, DrWsRequest request) {
            return this.sendResponse(new DrWsResponse(request.getSequence(), DrFaultImpl.from(exc)), request);
        }

        private Promise<Void> sendResponse(DrWsResponse response, DrWsRequest request) {
            byte[] responseContent;
            try {
                responseContent = SerializationUtil.toByteArray(response);
            }
            catch (IOException e) {
                LOGGER.warn("Response serialization for '{}' failed.", (Object)request.getPath(), (Object)e);
                return Promises.reject((Exception)new DrWsSessionFault(e));
            }
            return this._scheduler.send(responseContent, request.getPath());
        }

        private void startSendStreamResult(DrWsRequestHandler handler, final DrWsRequest request, final ControlStream controlStream) {
            Stream streamResult;
            try {
                Callable resultCallable = L10NHelper.withLocale(() -> handler.handle(request.getDrData(), (ExtensionServersView)this._topology.getView(), (Stream<DrWsRequestHandler.Signal>)controlStream), (Locale)this._locale);
                resultCallable = OpIdAccessor.withOpId((Callable)resultCallable, (String)DrWsMessageHandler.generateOpId());
                streamResult = (Stream)resultCallable.call();
            }
            catch (Exception exc) {
                LOGGER.warn("WsHandler for '{}' failed.", (Object)request.getPath(), (Object)exc);
                this.handleError(exc, controlStream, request);
                return;
            }
            streamResult.subscribe((Subscriber)new Subscriber<DrData>(){

                public void onNext(DrData item) {
                    this.sendNext(item, request, false).onError(exc -> {
                        LOGGER.warn("Send failed for '{}'", (Object)request.getPath(), exc);
                        this.handleError((Exception)exc, controlStream, request);
                    });
                }

                public void onComplete(boolean cancelled) {
                    if (!controlStream.isComplete()) {
                        this.sendNext(DrData.EMPTY, request, true).onError(exc -> {
                            LOGGER.warn("Send failed for '{}'", (Object)request.getPath(), exc);
                            this.handleError((Exception)exc, controlStream, request);
                        });
                        controlStream.stop();
                    }
                }

                public void onError(Exception exc) {
                    LOGGER.warn("Stream for '{}' failed.", (Object)request.getPath(), (Object)exc);
                    this.handleError(exc, controlStream, request);
                }
            });
            controlStream.start();
        }

        private void handleError(Exception exc, ControlStream controlStream, DrWsRequest request) {
            controlStream.stop();
            if (exc instanceof DrWsSessionFault) {
                DrWsServerEndpoint.closeSession(this._wsSession, (CloseReason.CloseCode)CloseReason.CloseCodes.UNEXPECTED_CONDITION, exc.getLocalizedMessage());
                return;
            }
            this.sendError(exc, request).onError(inner -> {
                if (inner instanceof DrWsSessionFault) {
                    DrWsServerEndpoint.closeSession(this._wsSession, (CloseReason.CloseCode)CloseReason.CloseCodes.UNEXPECTED_CONDITION, inner.getLocalizedMessage());
                }
            });
        }
    }

    private static class ControlStream
    extends CachingStream<DrWsRequestHandler.Signal> {
        private final AtomicBoolean _stoppedRef = new AtomicBoolean(false);

        private ControlStream() {
        }

        public void publishNext(DrWsRequestHandler.Signal item) {
            this._stoppedRef.set(item == DrWsRequestHandler.Signal.Stop);
            super.publishNext((Object)item);
        }

        public boolean isComplete() {
            return this._stoppedRef.get() || super.isComplete();
        }

        void start() {
            this.publishNext(DrWsRequestHandler.Signal.Start);
        }

        void stop() {
            this.publishNext(DrWsRequestHandler.Signal.Stop);
            this.publishComplete();
        }
    }

    private static class AsyncScheduler {
        private final RemoteEndpoint.Async _async;
        private final AtomicReference<Promise<Void>> _queueRef = new AtomicReference<Promise>(Promises.resolve(null));

        private AsyncScheduler(RemoteEndpoint.Async async) {
            this._async = async;
        }

        Promise<Void> send(byte[] data, String requestPath) {
            PromiseImpl next = new PromiseImpl();
            Promise<Void> current = this._queueRef.getAndSet((Promise<Void>)next);
            current.onError(arg_0 -> ((PromiseImpl)next).setError(arg_0));
            return current.thenCompose(ignore -> {
                SendPromise sp = new SendPromise();
                sp.onError(arg_0 -> ((PromiseImpl)next).setError(arg_0)).onSuccess(arg_0 -> ((PromiseImpl)next).setResult(arg_0));
                try {
                    this._async.sendBinary(ByteBuffer.wrap(data), (SendHandler)sp);
                }
                catch (Exception exc) {
                    LOGGER.warn("Failed to send response for '{}'.", (Object)requestPath, (Object)exc);
                    next.setError((Exception)new DrWsSessionFault(exc));
                }
                return next;
            });
        }
    }

    private static class SendPromise
    extends PromiseImpl<Void>
    implements SendHandler {
        private SendPromise() {
        }

        public void onResult(SendResult result) {
            if (result.isOK()) {
                this.setResult(null);
            } else {
                this.setError(new DrWsSessionFault(result.getException()));
            }
        }
    }

    public static class DrWsSessionFault
    extends RuntimeException {
        DrWsSessionFault(String msg, Throwable cause) {
            super(msg, cause);
        }

        DrWsSessionFault(Throwable cause) {
            this(cause.getLocalizedMessage(), cause);
        }
    }
}

