/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.infrastructure.websso;

import com.vmware.dr.ui.tools.reactive.Promise;
import com.vmware.dr.ui.tools.reactive.impl.Promises;
import com.vmware.srm.client.topology.impl.core.mxn.nodes.TokenProviderImpl;
import com.vmware.srm.client.topology.impl.lspp.monitor.model.LsppService;
import com.vmware.srm.client.topology.impl.sso.DrSecurityTokenService;
import com.vmware.srm.client.topology.impl.sso.SsoFacade;
import com.vmware.srm.client.topology.impl.sso.TokenManager;
import com.vmware.srm.client.topology.impl.vmomi.TokenProvider;
import com.vmware.vim.sso.client.SamlToken;
import com.vmware.vim.sso.client.SecurityTokenService;
import com.vmware.vim.sso.client.exception.SsoException;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;

public class SolutionUserTokenManager {
    private final X509Certificate cert;
    private final PrivateKey privateKey;
    private final TokenProviderImpl _provider;

    public SolutionUserTokenManager(X509Certificate cert, PrivateKey privateKey) {
        this.cert = cert;
        this.privateKey = privateKey;
        this._provider = new ProviderImpl();
    }

    public TokenProvider getTokenProvider() {
        return this._provider;
    }

    public void setSso(LsppService ssoReg) throws SsoException, GeneralSecurityException, IOException {
        DrSecurityTokenService sts = this.createSts(ssoReg);
        this._provider.setSts(sts);
    }

    public void dispose() {
        this._provider.dispose();
    }

    private DrSecurityTokenService createSts(LsppService ssoReg) throws GeneralSecurityException, IOException, SsoException {
        DrSecurityTokenService sts = SsoFacade.createSts((LsppService)ssoReg, (X509Certificate)this.cert, (PrivateKey)this.privateKey);
        try {
            SsoFacade.getTokenManager().acquireTokenByCertificate((SecurityTokenService)sts);
        }
        catch (SsoException | RuntimeException exc) {
            sts.dispose();
            throw exc;
        }
        return sts;
    }

    private static final class ProviderImpl
    extends TokenProviderImpl {
        private ProviderImpl() {
        }

        public Promise<SamlToken> getToken() {
            return super.getToken().materialize().thenCompose(pr -> {
                if (pr.isSuccessful()) {
                    return Promises.resolve((Object)((SamlToken)pr.getResult()));
                }
                Exception cause = pr.getError();
                if (cause instanceof TokenProvider.AuthenticationTokenNotAvailable) {
                    DrSecurityTokenService current = this.getSts();
                    return Promises.from(() -> SsoFacade.getTokenManager().acquireTokenByCertificate((SecurityTokenService)current)).materialize().thenCompose(prToken -> {
                        if (prToken.isSuccessful()) {
                            if (current != this.getSts()) {
                                SsoFacade.getTokenManager().releaseToken((SecurityTokenService)current);
                                return this.getToken();
                            }
                            return Promises.resolve((Object)((SamlToken)prToken.getResult()));
                        }
                        Exception innerCause = prToken.getError();
                        if (innerCause instanceof TokenManager.TokenRequestExists) {
                            return this.getToken();
                        }
                        cause.addSuppressed(innerCause);
                        return Promises.reject((Exception)cause);
                    });
                }
                return Promises.reject((Exception)cause);
            });
        }
    }
}

