/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.impex.configurables.arrayManagers;

import com.vmware.srm.client.impex.configurables.ConfigurableConverter;
import com.vmware.srm.client.impex.configurables.arrayManagers.IeReplicationSoftware;
import com.vmware.srm.client.impex.configurables.arrayManagers.IeStorageAdapter;
import com.vmware.srm.client.infrastructure.pc.utils.PcResult;
import com.vmware.vim.binding.dr.storage.StorageAdapter;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import java.util.Arrays;
import org.apache.commons.lang.ArrayUtils;

public class StorageAdapterConverter
implements ConfigurableConverter {
    public static IeStorageAdapter fromVmodl(ManagedObjectReference adapter, PcResult pcResult) {
        IeStorageAdapter ieAdapter = new IeStorageAdapter();
        StorageAdapterConverter.setStorageAdapterBasicSettings(ieAdapter, adapter, pcResult);
        StorageAdapterConverter.setStorageAdapterArrayModels(ieAdapter, adapter, pcResult);
        StorageAdapterConverter.setStorageAdapterReplicationSoftware(ieAdapter, adapter, pcResult);
        return ieAdapter;
    }

    private static void setStorageAdapterBasicSettings(IeStorageAdapter ieAdapter, ManagedObjectReference adapter, PcResult pcResult) {
        StorageAdapter.Info info = (StorageAdapter.Info)pcResult.getProperty(adapter, "info");
        ieAdapter.setName(info.getName().getText());
        ieAdapter.setVendorName(info.getVendor().getText());
        ieAdapter.setVersion(info.getVersion());
    }

    private static void setStorageAdapterArrayModels(IeStorageAdapter ieAdapter, ManagedObjectReference adapter, PcResult pcResult) {
        Object[] arrayModels = (StorageAdapter.ArrayModel[])pcResult.getProperty(adapter, "arrayModel");
        if (ArrayUtils.isEmpty((Object[])arrayModels)) {
            return;
        }
        ieAdapter.setArrayModels((String[])Arrays.stream(arrayModels).map(StorageAdapter.ArrayModel::getName).toArray(String[]::new));
    }

    private static void setStorageAdapterReplicationSoftware(IeStorageAdapter ieAdapter, ManagedObjectReference adapter, PcResult pcResult) {
        Object[] replicationSoftware = (StorageAdapter.ReplicationSoftware[])pcResult.getProperty(adapter, "replicationSoftware");
        if (ArrayUtils.isEmpty((Object[])replicationSoftware)) {
            return;
        }
        ieAdapter.setReplicationSoftware((IeReplicationSoftware[])Arrays.stream(replicationSoftware).map(rs -> new IeReplicationSoftware(rs.name, rs.version)).toArray(IeReplicationSoftware[]::new));
    }
}

