/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.impex.configurables.groups;

import com.vmware.srm.client.impex.configurables.groups.IeSrmConfigVmProtectionGroup;
import com.vmware.srm.client.impex.configurables.groups.IeVmProtectionGroup;
import com.vmware.srm.client.impex.configurables.groups.IeVmProtectionGroupFaultDomain;
import com.vmware.srm.client.impex.configurables.groups.IeVmProtectionGroupProperties;
import com.vmware.srm.client.impex.configurables.groups.PgSettingsConverter;
import com.vmware.srm.client.impex.importers.inventory.InventoryExtractor;
import com.vmware.srm.client.impex.tool.ImpexImportSrmContext;
import com.vmware.srm.client.impex.utils.ImpexL10N;
import com.vmware.vim.binding.dr.hbrProvider.GroupSettings;
import com.vmware.vim.binding.dr.replication.ProtectionGroup;
import com.vmware.vim.binding.dr.replication.VmProtectionGroup;
import com.vmware.vim.binding.dr.vvolProvider.DomainInfo;
import com.vmware.vim.binding.dr.vvolProvider.ReplicationGroupInfo;
import com.vmware.vim.binding.vim.vm.replication.ReplicationGroupId;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VmPgSettingsConverter
extends PgSettingsConverter {
    private static final Logger LOGGER = LoggerFactory.getLogger(VmPgSettingsConverter.class);

    public static VmProtectionGroup.Settings toVmodl(IeSrmConfigVmProtectionGroup iePg, InventoryExtractor.InventoryLookup inventory, Map<String, ManagedObjectReference> arrayPairKeyToMoRef, DomainInfo[] domainInfos) {
        VmProtectionGroup.Settings settings = new VmProtectionGroup.Settings();
        VmPgSettingsConverter.setBasicSettings((ProtectionGroup.Settings)settings, iePg);
        if (iePg.getProviderType() != null) {
            switch (iePg.getProviderType()) {
                case Hbr: {
                    settings.setProviderSettings((ProtectionGroup.ReplicationProviderGroupSettings)VmPgSettingsConverter.getHbrSettings(iePg.getProtectionProperties(), inventory));
                    return settings;
                }
                case Abr: {
                    settings.setProviderSettings((ProtectionGroup.ReplicationProviderGroupSettings)VmPgSettingsConverter.getStorageSettings(iePg, inventory, arrayPairKeyToMoRef));
                    return settings;
                }
                case Vvol: {
                    settings.setProviderSettings((ProtectionGroup.ReplicationProviderGroupSettings)VmPgSettingsConverter.getVvolSettings(iePg, domainInfos));
                    return settings;
                }
            }
            throw new RuntimeException("Invalid ieProtectionGroup provider type: " + iePg.getProviderType());
        }
        throw new IllegalStateException("VmProtectionGroup Settings");
    }

    private static GroupSettings getHbrSettings(List<IeVmProtectionGroupProperties> properties, InventoryExtractor.InventoryLookup inventory) {
        GroupSettings hbrSettings = new GroupSettings();
        if (properties == null) {
            return hbrSettings;
        }
        Object[] vms = (ManagedObjectReference[])properties.stream().map(IeVmProtectionGroupProperties::getId).map(vmId -> {
            ManagedObjectReference vm = (ManagedObjectReference)inventory.get(vmId);
            if (vm == null) {
                ImpexImportSrmContext context = ImpexImportSrmContext.get();
                String message = ImpexL10N.localize("group.create.vmpg.protectionSettings", context.names().getVm((String)vmId));
                LOGGER.warn(message);
                context.addError(message);
            }
            return vm;
        }).filter(Objects::nonNull).toArray(ManagedObjectReference[]::new);
        if (ArrayUtils.isNotEmpty((Object[])vms)) {
            hbrSettings.setAssociatedVm((ManagedObjectReference[])vms);
        }
        return hbrSettings;
    }

    private static com.vmware.vim.binding.dr.storageProvider.GroupSettings getStorageSettings(IeSrmConfigVmProtectionGroup iePg, InventoryExtractor.InventoryLookup inventory, Map<String, ManagedObjectReference> arrayPairKeyToMoRef) {
        List<String> datastoreIds = iePg.getDatastores();
        if (datastoreIds == null) {
            throw new IllegalArgumentException("Invalid datastore ids for ProtectionGroup " + iePg.getName() + ".");
        }
        String key = iePg.getArrayPairKey();
        if (key == null) {
            throw new NoSuchElementException("Array pair key: " + iePg.getArrayPairKey() + ".");
        }
        ManagedObjectReference[] datastores = (ManagedObjectReference[])datastoreIds.stream().map(datastoreId -> {
            ManagedObjectReference datastore = (ManagedObjectReference)inventory.get(datastoreId);
            if (Objects.isNull(datastore)) {
                ImpexImportSrmContext context = ImpexImportSrmContext.get();
                String message = ImpexL10N.localize("group.create.vmpg.datastoreSettings", context.names().getDatastore((String)datastoreId));
                LOGGER.warn(message);
                context.addError(message);
            }
            return datastore;
        }).filter(Objects::nonNull).toArray(ManagedObjectReference[]::new);
        com.vmware.vim.binding.dr.storageProvider.GroupSettings storageSettings = new com.vmware.vim.binding.dr.storageProvider.GroupSettings();
        ManagedObjectReference array = arrayPairKeyToMoRef.get(key);
        storageSettings.setArray(array);
        storageSettings.setDatastore(datastores);
        return storageSettings;
    }

    private static com.vmware.vim.binding.dr.vvolProvider.GroupSettings getVvolSettings(IeVmProtectionGroup iePg, DomainInfo[] domainInfos) {
        IeVmProtectionGroupFaultDomain ieFaultDomain = iePg.getFaultDomain();
        if (ieFaultDomain == null || ieFaultDomain.getName() == null) {
            throw new RuntimeException(String.format("Missing fault domain or its name for vVol protection group '%s' with ID '%s'.", iePg.getName(), iePg.getId()));
        }
        if (domainInfos == null) {
            throw new RuntimeException(String.format("Missing domain infos for vVol protection group '%s' with ID '%s'.", iePg.getName(), iePg.getId()));
        }
        DomainInfo domainInfo = Arrays.stream(domainInfos).filter(info -> ieFaultDomain.getName().equals(info.getName())).findFirst().orElse(null);
        if (domainInfo == null || domainInfo.id == null) {
            throw new RuntimeException(String.format("Unable to find fault domain with name '%s' for vVol protection group: '%s'.", ieFaultDomain.getName(), iePg.getName()));
        }
        ReplicationGroupId[] replicationGroups = VmPgSettingsConverter.getReplicationGroups(ieFaultDomain, domainInfo.getSourceReplicationGroups());
        return new com.vmware.vim.binding.dr.vvolProvider.GroupSettings(replicationGroups);
    }

    private static ReplicationGroupId[] getReplicationGroups(IeVmProtectionGroupFaultDomain ieFaultDomain, ReplicationGroupInfo[] replicationGroupInfos) {
        if (CollectionUtils.isEmpty(ieFaultDomain.getReplicationGroups())) {
            LOGGER.info("No ieReplicationGroups for ieFaultDomain '{}' with ID '{}'.", (Object)ieFaultDomain.getName(), (Object)ieFaultDomain.getId());
            return null;
        }
        if (ArrayUtils.isEmpty((Object[])replicationGroupInfos)) {
            return null;
        }
        Map replicationGroupsByName = Arrays.stream(replicationGroupInfos).collect(Collectors.toMap(ReplicationGroupInfo::getName, Function.identity(), (rgi1, rgi2) -> rgi1));
        return (ReplicationGroupId[])ieFaultDomain.getReplicationGroups().stream().map(ieReplicationGroup -> {
            String ieReplicationGroupName = ieReplicationGroup.getName();
            if (ieReplicationGroupName == null) {
                LOGGER.warn("Skipping replication group with ID '{}' from fault domain '{}': replication group name is missing.", (Object)ieReplicationGroup.getId(), (Object)ieFaultDomain.getId());
                ImpexImportSrmContext.get().addError(ImpexL10N.localize("group.create.vmpg.replicationGroup.name", ieReplicationGroup.getId(), ieFaultDomain.getId()));
                return null;
            }
            if (!replicationGroupsByName.containsKey(ieReplicationGroupName)) {
                LOGGER.warn("Skipping replication group '{}', with ID '{}', from fault domain '{}': not found.", new Object[]{ieReplicationGroupName, ieReplicationGroup.getId(), ieFaultDomain.getId()});
                ImpexImportSrmContext.get().addError(ImpexL10N.localize("group.create.vmpg.replicationGroup.faultDomain.name", ieReplicationGroupName, ieReplicationGroup.getId(), ieFaultDomain.getId()));
                return null;
            }
            return ((ReplicationGroupInfo)replicationGroupsByName.get(ieReplicationGroupName)).getReplicationGroup();
        }).filter(Objects::nonNull).toArray(ReplicationGroupId[]::new);
    }
}

