/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.impex.exporters.placeholderDatastores;

import com.vmware.dr.ui.tools.reactive.Promise;
import com.vmware.srm.client.impex.configurables.placeholderDatastores.IePlaceholderDatastores;
import com.vmware.srm.client.impex.configurables.placeholderDatastores.PlaceholderDatastoresConverter;
import com.vmware.srm.client.impex.exporters.SingleSiteExporter;
import com.vmware.srm.client.impex.tool.ImpexExportSrmContext;
import com.vmware.srm.client.impex.tool.SrmServersDataWrapper;
import com.vmware.srm.client.reactive.impl.FuturePromise;
import com.vmware.srm.client.topology.client.view.availability.srm.SrmServer;
import com.vmware.srm.client.topology.client.vmomi.availability.srm.SrmService;
import com.vmware.vim.binding.dr.PlaceholderDatastoreManager;
import com.vmware.vim.binding.dr.ServiceInstanceContent;
import com.vmware.vim.vmomi.core.Future;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlaceholderDatastoresExporter
extends SingleSiteExporter<IePlaceholderDatastores> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PlaceholderDatastoresExporter.class);

    @Override
    protected Promise<List<IePlaceholderDatastores>> getSingleSiteConfigurables(boolean local) {
        SrmServersDataWrapper serversData = ImpexExportSrmContext.getServersDataWrapper();
        SrmService srmService = local ? (SrmService)((SrmServer)serversData.getLocalPair().server()).service() : (SrmService)((SrmServer)serversData.getRemotePair().server()).service();
        ServiceInstanceContent content = local ? serversData.getLocalContent() : serversData.getRemoteContent();
        IePlaceholderDatastores placeholderDatastores = new IePlaceholderDatastores();
        placeholderDatastores.setLocal(local);
        PlaceholderDatastoreManager pdManager = (PlaceholderDatastoreManager)srmService.createStub(content.placeholderDatastoreManager);
        FuturePromise infosFp = new FuturePromise();
        pdManager.getPlaceholderDatastore((Future)infosFp);
        return infosFp.onError(error -> LOGGER.warn("Could not get placeholder datastores for guid: {}.", (Object)pdManager._getRef().getServerGuid(), error)).thenApply(infos -> Collections.singletonList(PlaceholderDatastoresConverter.fromVmodl(placeholderDatastores, infos)));
    }
}

