/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.utilities.java.support.httpclient;

import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.utilities.java.support.httpclient.HttpClientSupport;
import net.shibboleth.utilities.java.support.httpclient.RequestConnectionClose;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.ServiceUnavailableRetryStrategy;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.config.ConnectionConfig;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.util.CharsetUtils;

public class HttpClientBuilder {
    private InetAddress socketLocalAddress;
    private int socketTimeout;
    private int socketBufferSize;
    private int connectionTimeout;
    private boolean connectionDisregardTLSCertificate;
    @Nullable
    private LayeredConnectionSocketFactory tlsSocketFactory;
    private boolean connectionCloseAfterResponse;
    private boolean connectionStalecheck;
    @Nullable
    private String connectionProxyHost;
    @Nullable
    private String userAgent;
    private int connectionProxyPort;
    @Nullable
    private String connectionProxyUsername;
    @Nullable
    private String connectionProxyPassword;
    private boolean httpFollowRedirects;
    @Nullable
    private String httpContentCharSet;
    @Nullable
    private HttpRequestRetryHandler retryHandler;
    @Nullable
    private ServiceUnavailableRetryStrategy serviceUnavailStrategy;
    private org.apache.http.impl.client.HttpClientBuilder apacheBuilder;

    public HttpClientBuilder() {
        this(org.apache.http.impl.client.HttpClientBuilder.create());
    }

    public HttpClientBuilder(@Nonnull org.apache.http.impl.client.HttpClientBuilder builder) {
        Constraint.isNotNull(builder, "Apache HttpClientBuilder may not be null");
        this.apacheBuilder = builder;
        this.resetDefaults();
    }

    public void resetDefaults() {
        this.socketLocalAddress = null;
        this.socketTimeout = -1;
        this.socketBufferSize = 8192;
        this.connectionTimeout = -1;
        this.connectionDisregardTLSCertificate = false;
        this.connectionCloseAfterResponse = true;
        this.connectionStalecheck = false;
        this.connectionProxyHost = null;
        this.connectionProxyPort = 8080;
        this.connectionProxyUsername = null;
        this.connectionProxyPassword = null;
        this.httpFollowRedirects = true;
        this.httpContentCharSet = "UTF-8";
        this.userAgent = null;
    }

    public InetAddress getSocketLocalAddress() {
        return this.socketLocalAddress;
    }

    public void setSocketLocalAddress(InetAddress address) {
        this.socketLocalAddress = address;
    }

    public void setSocketLocalAddress(String ipOrHost) throws UnknownHostException {
        this.socketLocalAddress = InetAddress.getByName(Constraint.isNotNull(ipOrHost, "IP or hostname may not be null"));
    }

    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    public void setSocketTimeout(int timeout) {
        this.socketTimeout = timeout;
    }

    public int getSocketBufferSize() {
        return this.socketBufferSize;
    }

    public void setSocketBufferSize(int size) {
        this.socketBufferSize = (int)Constraint.isGreaterThan(0L, size, "Socket buffer size must be greater than 0");
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(int timeout) {
        this.connectionTimeout = timeout;
    }

    public boolean isConnectionDisregardTLSCertificate() {
        return this.connectionDisregardTLSCertificate;
    }

    public void setConnectionDisregardTLSCertificate(boolean disregard) {
        this.connectionDisregardTLSCertificate = disregard;
    }

    @Nullable
    public LayeredConnectionSocketFactory getTLSSocketFactory() {
        return this.tlsSocketFactory;
    }

    public void setTLSSocketFactory(@Nullable LayeredConnectionSocketFactory factory) {
        this.tlsSocketFactory = factory;
    }

    public boolean isConnectionCloseAfterResponse() {
        return this.connectionCloseAfterResponse;
    }

    public void setConnectionCloseAfterResponse(boolean close) {
        this.connectionCloseAfterResponse = close;
    }

    public boolean isConnectionStalecheck() {
        return this.connectionStalecheck;
    }

    public void setConnectionStalecheck(boolean check) {
        this.connectionStalecheck = check;
    }

    @Nullable
    public String getConnectionProxyHost() {
        return this.connectionProxyHost;
    }

    public void setConnectionProxyHost(@Nullable String host) {
        this.connectionProxyHost = StringSupport.trimOrNull(host);
    }

    public int getConnectionProxyPort() {
        return this.connectionProxyPort;
    }

    public void setConnectionProxyPort(int port) {
        this.connectionProxyPort = (int)Constraint.numberInRangeExclusive(0L, 65536L, port, "Proxy port must be between 0 and 65536, exclusive");
    }

    @Nullable
    public String getConnectionProxyUsername() {
        return this.connectionProxyUsername;
    }

    public void setConnectionProxyUsername(@Nullable String usename) {
        this.connectionProxyUsername = usename;
    }

    @Nullable
    public String getConnectionProxyPassword() {
        return this.connectionProxyPassword;
    }

    public void setConnectionProxyPassword(@Nullable String password) {
        this.connectionProxyPassword = password;
    }

    public boolean isHttpFollowRedirects() {
        return this.httpFollowRedirects;
    }

    public void setHttpFollowRedirects(boolean followRedirects) {
        this.httpFollowRedirects = followRedirects;
    }

    @Nullable
    public String getHttpContentCharSet() {
        return this.httpContentCharSet;
    }

    public void setHttpContentCharSet(@Nullable String charSet) {
        this.httpContentCharSet = charSet;
    }

    @Nullable
    public String getUserAgent() {
        return this.userAgent;
    }

    public void setUserAgent(@Nullable String what) {
        this.userAgent = what;
    }

    @Nullable
    public HttpRequestRetryHandler getHttpRequestRetryHandler() {
        return this.retryHandler;
    }

    public void setHttpRequestRetryHandler(@Nullable HttpRequestRetryHandler handler) {
        this.retryHandler = handler;
    }

    @Nullable
    public ServiceUnavailableRetryStrategy getServiceUnavailableRetryHandler() {
        return this.serviceUnavailStrategy;
    }

    public void setServiceUnavailableRetryHandler(@Nullable ServiceUnavailableRetryStrategy strategy) {
        this.serviceUnavailStrategy = strategy;
    }

    public HttpClient buildClient() throws Exception {
        this.decorateApacheBuilder();
        return this.getApacheBuilder().build();
    }

    protected void decorateApacheBuilder() throws Exception {
        org.apache.http.impl.client.HttpClientBuilder builder = this.getApacheBuilder();
        if (this.getTLSSocketFactory() != null) {
            builder.setSSLSocketFactory(this.getTLSSocketFactory());
        } else if (this.connectionDisregardTLSCertificate) {
            builder.setSSLSocketFactory(HttpClientSupport.buildNoTrustTLSSocketFactory());
        } else {
            builder.setSSLSocketFactory(HttpClientSupport.buildStrictTLSSocketFactory());
        }
        if (this.connectionCloseAfterResponse) {
            builder.addInterceptorLast((HttpRequestInterceptor)new RequestConnectionClose());
        }
        if (this.retryHandler != null) {
            builder.setRetryHandler(this.retryHandler);
        }
        if (this.serviceUnavailStrategy != null) {
            builder.setServiceUnavailableRetryStrategy(this.serviceUnavailStrategy);
        }
        RequestConfig.Builder requestConfigBuilder = RequestConfig.custom();
        if (this.socketLocalAddress != null) {
            requestConfigBuilder.setLocalAddress(this.socketLocalAddress);
        }
        if (this.socketTimeout > 0) {
            requestConfigBuilder.setSocketTimeout(this.socketTimeout);
        }
        if (this.connectionTimeout > 0) {
            requestConfigBuilder.setConnectTimeout(this.connectionTimeout);
        }
        requestConfigBuilder.setStaleConnectionCheckEnabled(this.connectionStalecheck);
        requestConfigBuilder.setRedirectsEnabled(this.httpFollowRedirects);
        if (this.connectionProxyHost != null) {
            HttpHost proxyHost = new HttpHost(this.connectionProxyHost, this.connectionProxyPort);
            requestConfigBuilder.setProxy(proxyHost);
            if (this.connectionProxyUsername != null && this.connectionProxyPassword != null) {
                BasicCredentialsProvider credProvider = new BasicCredentialsProvider();
                credProvider.setCredentials(new AuthScope(this.connectionProxyHost, this.connectionProxyPort), (Credentials)new UsernamePasswordCredentials(this.connectionProxyUsername, this.connectionProxyPassword));
                builder.setDefaultCredentialsProvider((CredentialsProvider)credProvider);
            }
        }
        ConnectionConfig.Builder connectionConfigBuilder = ConnectionConfig.custom();
        connectionConfigBuilder.setBufferSize(this.socketBufferSize);
        if (this.httpContentCharSet != null) {
            connectionConfigBuilder.setCharset(CharsetUtils.get((String)this.httpContentCharSet));
        }
        builder.setDefaultRequestConfig(requestConfigBuilder.build());
        builder.setDefaultConnectionConfig(connectionConfigBuilder.build());
        if (null != this.userAgent) {
            builder.setUserAgent(this.userAgent);
        }
    }

    protected org.apache.http.impl.client.HttpClientBuilder getApacheBuilder() {
        return this.apacheBuilder;
    }
}

