/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.activation;

import com.vmware.vapi.bindings.client.InvocationConfig;
import com.vmware.vapi.bindings.server.AsyncContext;
import com.vmware.vapi.bindings.server.InvocationContext;
import com.vmware.vapi.core.ExecutionContext;
import com.vmware.vapi.internal.util.Validate;
import java.util.Collections;
import java.util.UUID;

public final class Activations {
    public static final String PROP_NAME_ACTIVATION_ID = "ActivationId";

    private Activations() {
    }

    public static String getActivationId(InvocationConfig invocationConfig) {
        if (invocationConfig == null) {
            return null;
        }
        return Activations.getActivationId(invocationConfig.getExecutionContext());
    }

    public static <T> String getActivationId(AsyncContext<T> asyncContext) {
        if (asyncContext == null) {
            return null;
        }
        return Activations.getActivationId(asyncContext.getInvocationContext());
    }

    public static String getActivationId(InvocationContext invocationContext) {
        if (invocationContext == null) {
            return null;
        }
        return Activations.getActivationId(invocationContext.getExecutionContext());
    }

    public static String getActivationId(ExecutionContext executionContext) {
        if (executionContext == null) {
            return null;
        }
        return Activations.getActivationId(executionContext.retrieveApplicationData());
    }

    public static String getActivationId(ExecutionContext.ApplicationData applicationData) {
        if (applicationData == null) {
            return null;
        }
        return applicationData.getProperty(PROP_NAME_ACTIVATION_ID);
    }

    public static String newActivationId() {
        return UUID.randomUUID().toString();
    }

    public static ExecutionContext.ApplicationData setActivationId(ExecutionContext.ApplicationData appData, String activationId) {
        Validate.notNull(activationId);
        return ExecutionContext.ApplicationData.merge(appData, PROP_NAME_ACTIVATION_ID, activationId);
    }

    public static ExecutionContext.ApplicationData newApplicationData(String activationId) {
        Validate.notNull(activationId);
        return new ExecutionContext.ApplicationData(Collections.singletonMap(PROP_NAME_ACTIVATION_ID, activationId));
    }

    public static ExecutionContext.ApplicationData newApplicationData() {
        return Activations.newApplicationData(Activations.newActivationId());
    }

    public static ExecutionContext setActivationId(ExecutionContext ctx, String activationId) {
        Validate.notNull(activationId);
        return ExecutionContext.Builder.from(ctx).mergeApplicationData(PROP_NAME_ACTIVATION_ID, activationId).build();
    }

    public static ExecutionContext newExecutionContext(String activationId) {
        return new ExecutionContext(Activations.newApplicationData(activationId), null);
    }

    public static ExecutionContext newExecutionContext() {
        return Activations.newExecutionContext(Activations.newActivationId());
    }

    public static InvocationConfig setActivationId(InvocationConfig ctx, String activationId) {
        Validate.notNull(activationId);
        ExecutionContext executionContext = null;
        if (ctx != null) {
            executionContext = ctx.getExecutionContext();
        }
        return new InvocationConfig(Activations.setActivationId(executionContext, activationId));
    }

    public static InvocationConfig newInvocationConfig(String activationId) {
        return new InvocationConfig(Activations.newExecutionContext(activationId));
    }

    public static InvocationConfig newInvocationConfig() {
        return Activations.newInvocationConfig(Activations.newActivationId());
    }
}

