/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.bindings;

import com.vmware.vapi.bindings.Service;
import com.vmware.vapi.bindings.StubConfigurationBase;
import com.vmware.vapi.bindings.StubFactory;
import com.vmware.vapi.core.ApiProvider;
import com.vmware.vapi.internal.util.Validate;
import com.vmware.vapi.protocol.local.LocalConnection;
import com.vmware.vapi.protocol.local.LocalProtocol;
import com.vmware.vapi.provider.ApiInterface;
import com.vmware.vapi.provider.local.LocalProvider;
import java.util.Collections;

public final class LocalStubFactory {
    public <T extends Service> T createStub(ApiInterface skeleton, Class<T> stubIface) {
        return this.createStub(skeleton, stubIface, null);
    }

    public <T extends Service> T createStub(ApiInterface skeleton, Class<T> stubIface, StubConfigurationBase config) {
        LocalProvider provider = new LocalProvider("LocalProvider for " + skeleton.getIdentifier().toString(), Collections.singletonList(skeleton));
        return this.createStub(skeleton, stubIface, config, provider);
    }

    public <T extends Service> T createStub(ApiInterface skeleton, Class<T> stubIface, StubConfigurationBase config, ApiProvider provider) {
        Validate.notNull(skeleton);
        Validate.notNull(stubIface);
        LocalConnection c = new LocalConnection(new LocalProtocol(provider));
        StubFactory stubFactory = new StubFactory(c.getApiProvider());
        return stubFactory.createStub(stubIface, config);
    }
}

