/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.internal.protocol.common.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.vmware.vapi.Message;
import com.vmware.vapi.MessageFactory;
import com.vmware.vapi.dsig.json.SignatureException;
import com.vmware.vapi.internal.util.Validate;
import java.io.IOException;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class JsonSecurityContextSerializer {
    public static final int TS_DEF_OFFSET = 10;
    private static final Message SERIALIZATION_ERROR = MessageFactory.getMessage("vapi.signature.serialization", new String[0]);
    private static final String SEC_CTX_NAME = "securityCtx";
    private static final Pattern EXEC_CTX_REGEXP = Pattern.compile("\"ctx\"\\s*:\\s*\\{");
    private static final String JSON_OBJ_DELIM = ":";
    private static final String QUOT = "\"";
    private static final ObjectMapper jsonMapper = new ObjectMapper();

    public String serializeSecurityContext(Map<String, Object> securityContext, String request) {
        return this.serializeSecurityContext(this.toJsonString(securityContext), request);
    }

    public String removeSignature(String request) {
        Validate.notNull(request);
        JsonNode requestTree = JsonSecurityContextSerializer.parseToTree(request);
        JsonNode secCtx = requestTree.findPath(SEC_CTX_NAME);
        ((ObjectNode)secCtx).remove("signature");
        return this.toJsonString(requestTree);
    }

    private String serializeSecurityContext(String securityContext, String request) {
        Validate.notNull(securityContext);
        Validate.notNull(request);
        StringBuilder result = new StringBuilder();
        int pos = this.findEndPosition(request, EXEC_CTX_REGEXP);
        StringBuilder secCtx = new StringBuilder();
        this.quote(secCtx, SEC_CTX_NAME).append(JSON_OBJ_DELIM);
        secCtx.append(securityContext);
        result.append(request.substring(0, pos)).append(secCtx.toString()).append(",").append(request.substring(pos));
        return result.toString();
    }

    private static JsonNode parseToTree(String message) {
        JsonNode root;
        if (message == null) {
            return null;
        }
        try {
            root = jsonMapper.readTree(message);
        }
        catch (IOException e) {
            throw new SignatureException(SERIALIZATION_ERROR, (Throwable)e);
        }
        return root;
    }

    private StringBuilder quote(StringBuilder builder, String value) {
        assert (builder != null);
        assert (value != null);
        return builder.append(QUOT).append(value).append(QUOT);
    }

    public String toJsonString(Object ctx) {
        try {
            return jsonMapper.writeValueAsString(ctx);
        }
        catch (IOException e) {
            throw new SignatureException(SERIALIZATION_ERROR, (Throwable)e);
        }
    }

    private int findEndPosition(String request, Pattern regexp) {
        assert (request != null);
        assert (regexp != null);
        Matcher m = regexp.matcher(request);
        if (m.find()) {
            return m.end();
        }
        return -1;
    }
}

