/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.identity.cdc;

public enum CdcState {
    CDC_STATE_UNDEFINED(0),
    CDC_STATE_NO_DC_LIST(1),
    CDC_STATE_SITE_AFFINITIZED(2),
    CDC_STATE_OFF_SITE(3),
    CDC_STATE_NO_DCS_ALIVE(4),
    CDC_STATE_DISABLED(5);

    private final int _cdcState;

    private CdcState(int cdcState) {
        this._cdcState = cdcState;
    }

    public int getValue() {
        return this._cdcState;
    }

    public static CdcState getState(int state) {
        switch (state) {
            case 0: {
                return CDC_STATE_UNDEFINED;
            }
            case 1: {
                return CDC_STATE_NO_DC_LIST;
            }
            case 2: {
                return CDC_STATE_SITE_AFFINITIZED;
            }
            case 3: {
                return CDC_STATE_OFF_SITE;
            }
            case 4: {
                return CDC_STATE_NO_DCS_ALIVE;
            }
            case 5: {
                return CDC_STATE_DISABLED;
            }
        }
        throw new IllegalArgumentException(String.format("Unidentified State [%d]", state));
    }
}

