/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.topology.impl.vmomi.updates;

import com.vmware.dr.ui.tools.reactive.Promise;
import com.vmware.srm.client.reactive.impl.FuturePromise;
import com.vmware.srm.client.topology.client.vmomi.Service;
import com.vmware.srm.client.topology.client.vmomi.availability.PcUpdatesService;
import com.vmware.srm.client.topology.client.vmomi.updates.FilterUpdatesHandler;
import com.vmware.srm.client.topology.impl.utils.IndexUtils;
import com.vmware.srm.client.topology.impl.vmomi.updates.PcUpdateResultImpl;
import com.vmware.srm.client.topology.impl.vmomi.updates.WaitForUpdatesRunner;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.fault.ManagedObjectNotFound;
import com.vmware.vim.binding.vmodl.query.PropertyCollector;
import com.vmware.vim.vmomi.core.Future;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.commons.lang.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilterManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(FilterManager.class);
    private final Service<?, ?> _service;
    private final PropertyCollector _propertyCollector;
    private final WaitForUpdatesRunner _waitForUpdatesRunner;
    private final Consumer<ManagedObjectNotFound> _monfErrorHandler;
    private final AtomicBoolean _disposed;
    private final Map<ManagedObjectReference, FilterUpdatesHandler> _filterMoRefToStream;
    private final Map<FilterUpdatesHandler, ManagedObjectReference> _streamToFilterMoRef;
    private final Map<Promise<ManagedObjectReference>, FilterUpdatesHandler> _pendingFilterCreationMap;
    private final Map<ManagedObjectReference, List<PropertyCollector.FilterUpdate>> _pendingUpdates;

    FilterManager(PropertyCollector propertyCollector, PcUpdatesService<?, ?> service, Consumer<ManagedObjectNotFound> monfErrorHandler, PropertyCollector.WaitOptions waitOptions) {
        Validate.notNull((Object)propertyCollector, (String)"propertyCollector can not be null.");
        Validate.notNull(service, (String)"service can not be null.");
        Validate.notNull(monfErrorHandler, (String)"monfErrorHandler can not be null.");
        Validate.notNull((Object)waitOptions, (String)"waitOptions can not be null.");
        this._propertyCollector = propertyCollector;
        this._service = service;
        this._monfErrorHandler = monfErrorHandler;
        this._waitForUpdatesRunner = new WaitForUpdatesRunner(propertyCollector, waitOptions, this::processUpdates, this::processError);
        this._disposed = new AtomicBoolean(false);
        this._filterMoRefToStream = new HashMap<ManagedObjectReference, FilterUpdatesHandler>();
        this._streamToFilterMoRef = new HashMap<FilterUpdatesHandler, ManagedObjectReference>();
        this._pendingFilterCreationMap = new HashMap<Promise<ManagedObjectReference>, FilterUpdatesHandler>();
        this._pendingUpdates = new HashMap<ManagedObjectReference, List<PropertyCollector.FilterUpdate>>();
    }

    ManagedObjectReference getPropertyCollector() {
        return this._propertyCollector._getRef();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addFilter(FilterUpdatesHandler updatesHandler) {
        if (this._disposed.get()) {
            LOGGER.warn("FilterManager is disposed! Ignoring request to add filter.");
            return;
        }
        FuturePromise filterPromise = new FuturePromise();
        FilterManager filterManager = this;
        synchronized (filterManager) {
            this._pendingFilterCreationMap.put((Promise<ManagedObjectReference>)filterPromise, updatesHandler);
        }
        this._propertyCollector.createFilter(updatesHandler.getSpec(), updatesHandler.isPartialUpdates(), (Future)filterPromise);
        filterPromise.onSuccess(filterMoRef -> this.onFilterCreated((FuturePromise<ManagedObjectReference>)filterPromise, (ManagedObjectReference)filterMoRef, updatesHandler)).onError(error -> this.onFilterCreationError((Exception)error, (Promise<ManagedObjectReference>)filterPromise, updatesHandler));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeFilter(FilterUpdatesHandler updatesHandler) {
        ManagedObjectReference filterMoRef;
        LOGGER.info("Remove filter called for {}.", (Object)updatesHandler);
        FilterManager filterManager = this;
        synchronized (filterManager) {
            filterMoRef = this._streamToFilterMoRef.remove(updatesHandler);
            if (filterMoRef != null) {
                this._filterMoRefToStream.remove(filterMoRef);
            }
            this.stopIfNoFilters();
        }
        if (filterMoRef == null) {
            LOGGER.warn("No filter found for {}.", (Object)updatesHandler);
            return;
        }
        PropertyCollector.Filter filter = (PropertyCollector.Filter)this._service.createStub(filterMoRef);
        filter.destroy((Future)new FuturePromise());
    }

    void dispose() {
        if (this._disposed.compareAndSet(false, true)) {
            LOGGER.info("Dispose called for FilterManager for {}.", (Object)this._propertyCollector);
            this._waitForUpdatesRunner.stop();
            this._pendingFilterCreationMap.clear();
            this._pendingUpdates.clear();
            this._filterMoRefToStream.clear();
            this._streamToFilterMoRef.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onFilterCreated(FuturePromise<ManagedObjectReference> filterPromise, ManagedObjectReference filterMoRef, FilterUpdatesHandler updatesHandler) {
        LOGGER.info("Successfully created filter for stream {}: {}.", (Object)updatesHandler, (Object)filterMoRef);
        if (this._disposed.get()) {
            LOGGER.warn("FilterManager is disposed! Ignoring successful filter creation.");
            return;
        }
        FilterManager filterManager = this;
        synchronized (filterManager) {
            this._pendingFilterCreationMap.remove(filterPromise);
            List<PropertyCollector.FilterUpdate> pendingUpdates = this._pendingUpdates.remove(filterMoRef);
            if (pendingUpdates != null && !pendingUpdates.isEmpty()) {
                updatesHandler.handleUpdate(new PcUpdateResultImpl(pendingUpdates));
            }
            this._filterMoRefToStream.put(filterMoRef, updatesHandler);
            this._streamToFilterMoRef.put(updatesHandler, filterMoRef);
        }
        if (updatesHandler.isMarkForDelete()) {
            LOGGER.info("Filter marked for deletion: {}.", (Object)filterMoRef);
            this.removeFilter(updatesHandler);
        } else if (!this._disposed.get()) {
            this._waitForUpdatesRunner.start();
        } else {
            LOGGER.warn("FilterManager was disposed.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onFilterCreationError(Exception error, Promise<ManagedObjectReference> filterPromise, FilterUpdatesHandler updatesHandler) {
        LOGGER.warn("Filter creation failed with: {}.", (Object)error.getMessage());
        if (this._disposed.get()) {
            LOGGER.warn("FilterManager is disposed! Ignoring filter creation error.");
            return;
        }
        FilterManager filterManager = this;
        synchronized (filterManager) {
            this._pendingFilterCreationMap.remove(filterPromise);
            this.stopIfNoFilters();
        }
        if (updatesHandler.isMarkForDelete()) {
            LOGGER.info("The stream for this filter is marked for deletion. Ignoring error.");
            return;
        }
        updatesHandler.handleError(error);
    }

    private void processUpdates(PropertyCollector.FilterUpdate[] updates) {
        LOGGER.info("ProcessUpdates called for {} updates.", (Object)updates.length);
        if (this._disposed.get()) {
            LOGGER.warn("FilterManager is disposed! Ignoring processUpdates request.");
            return;
        }
        Map<ManagedObjectReference, List<PropertyCollector.FilterUpdate>> filterToUpdates = IndexUtils.indexBy(Arrays.asList(updates), value -> value.filter);
        filterToUpdates.forEach((filter, filterUpdates) -> {
            FilterUpdatesHandler resultStream;
            FilterManager filterManager = this;
            synchronized (filterManager) {
                resultStream = this._filterMoRefToStream.get(filter);
            }
            if (resultStream != null) {
                LOGGER.info("Publish result for filter {}.", filter);
                LOGGER.trace("Publish result for update {}.", (Object)filterUpdates.stream().map(PropertyCollector.FilterUpdate::toString).collect(Collectors.joining()));
                resultStream.handleUpdate(new PcUpdateResultImpl((Collection<PropertyCollector.FilterUpdate>)filterUpdates));
            } else if (this.hasPendingFilterCreations()) {
                LOGGER.info("Unable to find result stream. Adding to pending updates.");
                filterManager = this;
                synchronized (filterManager) {
                    this._pendingUpdates.computeIfAbsent((ManagedObjectReference)filter, mapKey -> new ArrayList(filterUpdates.size())).addAll(filterUpdates);
                }
            } else {
                LOGGER.warn("Unable to find result stream. No pending filter creations either.Destroying {}.", filter);
                PropertyCollector.Filter filterStub = (PropertyCollector.Filter)this._service.createStub((ManagedObjectReference)filter);
                filterStub.destroy((Future)new FuturePromise());
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processError(Exception error) {
        Collection<FilterUpdatesHandler> updatesStreams;
        if (this._disposed.get()) {
            LOGGER.warn("FilterManager is disposed! Ignoring processError request.");
            return;
        }
        if (error instanceof ManagedObjectNotFound) {
            this._monfErrorHandler.accept((ManagedObjectNotFound)error);
            return;
        }
        LOGGER.info("Publish error to all filters.");
        FilterManager filterManager = this;
        synchronized (filterManager) {
            updatesStreams = this._filterMoRefToStream.values();
        }
        updatesStreams.forEach(updatesStream -> updatesStream.handleError(error));
    }

    private synchronized boolean hasPendingFilterCreations() {
        return !this._pendingFilterCreationMap.isEmpty();
    }

    private synchronized void stopIfNoFilters() {
        if (this._filterMoRefToStream.isEmpty() && this._streamToFilterMoRef.isEmpty() && this._pendingFilterCreationMap.isEmpty()) {
            LOGGER.info("No active filters for server {}.", (Object)this._service.getServerUrl());
            this._waitForUpdatesRunner.stop();
        }
    }
}

