/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.dr.ui.tools.utilities;

import com.vmware.dr.ui.tools.utilities.HashUtils;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class StringUtils {
    private static final char NEW_LINE = '\n';
    private static final char QUOTE = '\"';
    private static final char COMMA_SEPARATOR = ',';
    private static final String KEY_VAL_SEPARATOR = "\t:\n";
    private static final char OPEN_SQUARE_BRACKET = '[';
    private static final String CLOSE_SQUARE_BRACKET = "\n]";
    private static final char OPEN_CURLY_BRACKET = '{';
    private static final String CLOSE_CURLY_BRACKET = "\n}";
    private static final String OBJECT_ALREADY_SEEN = "<already seen>";
    private static final Object NULL = new Object(){

        public String toString() {
            return "null";
        }
    };
    private static final ThreadLocal<Set<Object>> SEEN = ThreadLocal.withInitial(() -> Collections.newSetFromMap(new IdentityHashMap()));

    public static String getToStringValue(String className, Map<String, Object> memberByName) {
        if (className == null) {
            throw new IllegalArgumentException("className");
        }
        if (memberByName == null) {
            throw new IllegalArgumentException("memberByName");
        }
        StringBuilder builder = new StringBuilder();
        builder.append(className);
        builder.append(" {");
        for (Map.Entry<String, Object> entry : memberByName.entrySet()) {
            builder.append("\n");
            String key = entry.getKey();
            builder.append(key);
            builder.append(" = ");
            HashUtils.HelperList value = entry.getValue();
            if (value == null) {
                value = NULL;
            } else if (value.getClass().isArray()) {
                value = new HashUtils.HelperList(value);
            }
            builder.append(StringUtils.indent(((Object)value).toString(), false));
        }
        builder.append(CLOSE_CURLY_BRACKET);
        return builder.toString();
    }

    public static String trimQuotes(String str) {
        if (org.apache.commons.lang.StringUtils.isEmpty((String)str)) {
            return str;
        }
        if (str.startsWith("\"") && str.endsWith("\"")) {
            return str.substring(1, str.length() - 1);
        }
        return str;
    }

    public static String toStringMemberObject(String prefix, Object o) {
        return prefix + StringUtils.toStringMemberObject(o);
    }

    public static String toStringMemberObject(Object o) {
        try (Helper h = new Helper(o);){
            if (!h.added()) {
                String string = OBJECT_ALREADY_SEEN;
                return string;
            }
            if (o == null) {
                String string = NULL.toString();
                return string;
            }
            if (o instanceof String) {
                String string = StringUtils.toStringMemberObject((String)o);
                return string;
            }
            if (o.getClass().isArray()) {
                String string = StringUtils.toStringMemberObject(StringUtils.buildArray(o));
                return string;
            }
            if (o instanceof Iterable) {
                String string = StringUtils.toStringMemberObject((Iterable)o);
                return string;
            }
            if (o instanceof Map) {
                String string = StringUtils.toStringMemberObject((Map)o);
                return string;
            }
            if (StringUtils.isPrimitiveWrapper(o)) {
                String string = String.valueOf(o);
                return string;
            }
            String string = o.toString();
            return string;
        }
    }

    public static String indent(String str, boolean isArray) {
        StringBuilder res = new StringBuilder();
        String[] lines = str.split("\n");
        res.append(lines[0]);
        if (lines.length > 1) {
            res.append("\n");
        }
        for (int i = 1; i < lines.length; ++i) {
            if (isArray) {
                res.append("      ");
            } else {
                res.append("   ");
            }
            res.append(lines[i]);
            if (i >= lines.length - 1) continue;
            res.append("\n");
        }
        return res.toString();
    }

    private static String toStringMemberObject(String str) {
        if (str == null) {
            return NULL.toString();
        }
        return '\"' + str + '\"';
    }

    private static String toStringMemberObject(Object[] arr) {
        if (arr == null) {
            return NULL.toString();
        }
        StringBuilder result = new StringBuilder();
        result.append('[');
        StringBuilder content = new StringBuilder();
        for (int i = 0; i < arr.length; ++i) {
            content.append('\n').append(StringUtils.toStringMemberObject(arr[i]));
            if (i >= arr.length - 1) continue;
            content.append(',');
        }
        result.append(StringUtils.indent(content.toString(), true));
        result.append(CLOSE_SQUARE_BRACKET);
        return result.toString();
    }

    private static String toStringMemberObject(Iterable<?> iterable) {
        if (iterable == null) {
            return NULL.toString();
        }
        StringBuilder result = new StringBuilder();
        result.append('{');
        StringBuilder content = new StringBuilder();
        Iterator<?> i = iterable.iterator();
        while (i.hasNext()) {
            content.append('\n').append(StringUtils.toStringMemberObject(i.next()));
            if (!i.hasNext()) continue;
            content.append(',');
        }
        result.append(StringUtils.indent(content.toString(), true));
        result.append(CLOSE_CURLY_BRACKET);
        return result.toString();
    }

    private static String toStringMemberObject(Map<?, ?> map) {
        if (map == null) {
            return NULL.toString();
        }
        StringBuilder result = new StringBuilder();
        result.append('{');
        StringBuilder content = new StringBuilder();
        map.forEach((key, value) -> content.append('\n').append(StringUtils.toStringMemberObject(key)).append(KEY_VAL_SEPARATOR).append(StringUtils.toStringMemberObject(value)).append(','));
        content.deleteCharAt(content.length() - 1);
        result.append(StringUtils.indent(content.toString(), false));
        result.append(CLOSE_CURLY_BRACKET);
        return result.toString();
    }

    private static Object[] buildArray(Object array) {
        if (array.getClass().getComponentType().isPrimitive()) {
            ArrayList<Object> result = new ArrayList<Object>();
            for (int i = 0; i < Array.getLength(array); ++i) {
                result.add(Array.get(array, i));
            }
            return result.toArray();
        }
        return (Object[])array;
    }

    private static boolean isPrimitiveWrapper(Object o) {
        return o instanceof Boolean || o instanceof Character || o instanceof Byte || o instanceof Short || o instanceof Integer || o instanceof Long || o instanceof Float || o instanceof Double;
    }

    private static final class Helper
    implements AutoCloseable {
        private final Object _obj;
        private final boolean _added;

        Helper(Object obj) {
            this._obj = obj == null ? new Object() : obj;
            this._added = ((Set)SEEN.get()).add(this._obj);
        }

        boolean added() {
            return this._added;
        }

        @Override
        public void close() {
            if (this._added) {
                ((Set)SEEN.get()).remove(this._obj);
            }
        }
    }
}

