/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.infrastructure.websso;

import com.vmware.dr.ui.tools.reactive.Promise;
import com.vmware.identity.websso.client.SPConfiguration;
import com.vmware.srm.client.infrastructure.websso.SpConfigSerializer;
import com.vmware.srm.client.reactive.impl.FuturePromise;
import com.vmware.srm.client.topology.impl.common.SyncUtils;
import com.vmware.srm.client.topology.impl.lspp.monitor.model.LsppService;
import com.vmware.srm.client.topology.impl.lspp.monitor.model.LsppServiceEndpoint;
import com.vmware.srm.client.topology.impl.sso.CertificateUtils;
import com.vmware.srm.client.topology.impl.sso.SsoServiceImpl;
import com.vmware.srm.client.topology.impl.sso.SsoUtils;
import com.vmware.srm.client.topology.impl.vmomi.TokenProvider;
import com.vmware.vim.binding.sso.admin.ConfigurationManagementService;
import com.vmware.vim.binding.sso.admin.ServiceContent;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.vmomi.core.Future;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.Collection;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;

public class SpConfigUpdater {
    private final SsoServiceImpl _service;
    private final SpConfigSerializer _serializer = new SpConfigSerializer();

    public SpConfigUpdater(LsppService sso, TokenProvider provider) throws CertificateException, KeyStoreException, NoSuchAlgorithmException, IOException {
        LsppServiceEndpoint adminEp = SsoUtils.getAdminEndpoint((LsppService)sso);
        KeyStore store = CertificateUtils.createTrustStore((Collection)adminEp.getCertificates());
        this._service = new SsoServiceImpl(adminEp.url, null, store, provider);
    }

    public void update(SPConfiguration config) throws ParserConfigurationException, IOException, TransformerException {
        String content = this._serializer.getStringValue(config);
        ManagedObjectReference cmsRef = ((ServiceContent)SyncUtils.getSync((Promise)this._service.getContent())).getConfigurationManagementService();
        ConfigurationManagementService cms = (ConfigurationManagementService)this._service.createStub(cmsRef);
        FuturePromise result = new FuturePromise();
        cms.importSAMLMetadata(content, (Future)result);
        SyncUtils.getSync((Promise)result);
    }

    public void dispose() {
        this._service.dispose();
    }
}

