@REM This batchfile generates JAXWS client stubs
@REM (proxy code) from the drconfig WSDL and then compiles
@REM the client sample applications.
@REM
@REM To compile the client applications without re-generating the client stubs,
@REM pass the -w as an argument to the script. For example:
@REM build -w
@REM
@REM Note that this batchfile requires you to set environment
@REM variable:
@REM   JAVAHOME
@REM
@REM See the Developer's Setup Guide for more information about
@REM JAVAHOME.
@REM Alternatively, you can modify the settings of
@REM these three variables in the batchfile. Be careful if you do so.
@REM


@echo off

setlocal
set SAMPLEDIR=.
set SAMPLEJARDIR=.

if NOT DEFINED JAVAHOME (
   @echo JAVAHOME not defined. Must be defined to build java apps.
   goto END
)

if NOT "x%1" == "x-w" (
   set WSDLDRCONFIG=drconfig-service.wsdl
   set WSDLLOCATION=..\..\..\wsdl\drconfig
)

:SETENV
set PATH=%JAVAHOME%\bin;%PATH%

set LOCALCLASSPATH=%CD%

for %%i in ("lib\*.jar") do call lcp.bat %CD%\%%i

:DOBUILD
call clean.bat %1

cd %SAMPLEDIR%

@echo Building JAXWS stub optimization utility
@if not exist FixJaxWsWsdlResource.class goto BUILDJAXWSUTIL
del /q/f FixJaxWsWsdlResource.class

:BUILDJAXWSUTIL
javac FixJaxWsWsdlResource.java

if NOT "x%1" == "x-w" (
   IF EXIST com\vmware\drconfig (
      rmdir /s/q com\vmware\drconfig
   )
   mkdir com\vmware\drconfig

   xcopy /q/i/s %WSDLLOCATION%\*.* .
   xcopy /q/i/s %WSDLLOCATION%\*.* com\vmware\drconfig

   @echo Generating stubs from wsdl
   wsimport -wsdllocation %WSDLDRCONFIG% -b jaxb-customizations.xjb -b ws-customizations.xml -s . %WSDLDRCONFIG%

   @echo Compiling stubs.
   @echo Adding classes to vim25.jar
   jar cf %SAMPLEJARDIR%\vim25.jar com\vmware\vim25\*.class

   @rem fix DrConfigService class to get the wsdl from the drconfig.jar
   @echo Generating FixJaxWsWsdlResource
   java -classpath "%LOCALCLASSPATH%" FixJaxWsWsdlResource "%CD%\com\vmware\drconfig\DrConfigService.java"
   del /q/f com\vmware\drconfig\DrConfigService.class
   javac -classpath "%LOCALCLASSPATH%;%SAMPLEJARDIR%\drconfig.jar" com\vmware\drconfig\DrConfigService.java

   @echo Adding classes to drconfig.jar
   jar cf %SAMPLEJARDIR%\drconfig.jar com\vmware\drconfig\*.class com\vmware\drconfig\*.wsdl com\vmware\drconfig\*.xsd

   @echo Deleting temporary files
   del /q/f .\*.wsdl
   del /q/f .\*.xsd
   del /q/f com\vmware\drconfig\*.wsdl
   del /q/f com\vmware\drconfig\*.xsd
   del /q/f com\vmware\drconfig\*.class

   @echo Done compiling stubs.
)

@echo Compiling samples

javac -classpath "%LOCALCLASSPATH%;%SAMPLEJARDIR%\samples.jar" com\vmware\samples\connection\*.java com\vmware\samples\drconfig\*.java
if %ERRORLEVEL% neq 0 goto ABORT

jar cfm %SAMPLEJARDIR%\samples.jar .\manifest-addition.txt com\vmware\samples\connection\*.class com\vmware\samples\drconfig\*.class

:END
@echo Done.

:ABORT
@echo on
