#!/bin/sh -e
# This script generates JAXWS client stubs (proxy code) from the SRM WSDL and
# then compiles the client sample applications.
#
# To compile the client applications without re-generating the client stubs,
# pass the -w as an argument to the script. For example:
# build -w
#
# Note that this batchfile requires you to set environment
# variable:
#   JAVAHOME
#
# See the Developer's Setup Guide for more information about JAVAHOME.
#
# Alternatively, you can modify the settings of these three variables in the
# script.  Be careful if you do so.
#


SAMPLEDIR=.
SAMPLEJARDIR=.

if [ "${JAVAHOME}" == "" ] ; then
    echo "JAVAHOME not defined.  Must be defined to run java apps.">&2
    exit 2
fi

if [ "x$1" != "x-w" ] ; then
    WSDLSRM=srm-Service.wsdl
    WSDLLOCATION=../../../wsdl/srm
fi

PATH="${JAVAHOME}/bin:${PATH}"
export PATH

LOCALCLASSPATH=${PWD}

./clean.sh $1

cd ${SAMPLEDIR}

echo "Building JAXWS stub optimization utility"
if [ -f FixJaxWsWsdlResource.class ] ; then
    rm -f FixJaxWsWsdlResource.class
fi
javac FixJaxWsWsdlResource.java

if [ "x$1" != "x-w" ] ; then
    rm -rf com/vmware/srm
    mkdir -p com/vmware/srm

    cp -a ${WSDLLOCATION}/* .
    cp -a ${WSDLLOCATION}/* com/vmware/srm

    echo "Generating stubs from wsdl"
    wsimport -wsdllocation ${WSDLSRM} -b jaxb-customizations.xjb -b ws-customizations.xml -b vim-types.xsd -s . ${WSDLSRM}

    echo "Compiling stubs."
    jar cf ${SAMPLEJARDIR}/vim25.jar com/vmware/vim25/*.class

    # fix SrmService class to get the wsdl from the srm.jar
    java -classpath "${LOCALCLASSPATH}" FixJaxWsWsdlResource "${PWD}/com/vmware/srm/SrmService.java"
    rm -f com/vmware/srm/SrmService.class
    javac -classpath "${LOCALCLASSPATH}:${SAMPLEJARDIR}/vim25.jar" com/vmware/srm/SrmService.java

    jar cf ${SAMPLEJARDIR}/srm.jar com/vmware/vim25/*.class com/vmware/srm/*.class com/vmware/srm/*.wsdl com/vmware/srm/*.xsd

    rm -f ./*.wsdl
    rm -f ./*.xsd
    rm -f com/vmware/srm/*.wsdl
    rm -f com/vmware/srm/*.xsd
    rm -f com/vmware/srm/*.class
    rm -f com/vmware/vim25/*.class

    echo "Done compiling stubs."
fi

echo "Compiling samples"

javac -classpath "${LOCALCLASSPATH}:${SAMPLEJARDIR}/srm.jar" com/vmware/samples/recovery/*.java com/vmware/samples/srm/*.java

jar cf ${SAMPLEJARDIR}/samples.jar com/vmware/samples/recovery/*.class com/vmware/samples/srm/*.class

echo "Done."
