/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.dr.ui.tools.reactive.impl;

import com.vmware.dr.ui.tools.reactive.Promise;
import com.vmware.dr.ui.tools.reactive.Publisher;
import com.vmware.dr.ui.tools.reactive.Stream;
import com.vmware.dr.ui.tools.reactive.Subscriber;
import com.vmware.dr.ui.tools.reactive.Subscription;
import com.vmware.dr.ui.tools.reactive.impl.FilterTransformStream;
import com.vmware.dr.ui.tools.reactive.impl.FlatMapTransformStream;
import com.vmware.dr.ui.tools.reactive.impl.MapTransformStream;
import com.vmware.dr.ui.tools.reactive.impl.MaterializeTransformStream;
import com.vmware.dr.ui.tools.reactive.impl.PromiseImpl;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.commons.lang.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class TransformStream<T, U>
implements Stream<U> {
    private static Logger LOGGER = LoggerFactory.getLogger(TransformStream.class);
    private final Publisher<T> _publisher;

    TransformStream(Publisher<T> publisher) {
        this._publisher = publisher;
    }

    @Override
    public Subscription<U> subscribe(final Subscriber<? super U> subscriber) {
        final Subscription<T> inner = this._publisher.subscribe(new SubscriberHelper(subscriber));
        return new Subscription<U>(){

            @Override
            public Publisher<U> getPublisher() {
                return TransformStream.this;
            }

            @Override
            public Subscriber<? super U> getSubscriber() {
                return subscriber;
            }

            @Override
            public void cancel() {
                inner.cancel();
            }
        };
    }

    protected abstract void processNext(T var1, Subscriber<? super U> var2);

    protected void processError(Exception exc, Subscriber<? super U> subscriber) {
        subscriber.onError(exc);
    }

    protected void processComplete(boolean cancelled, Subscriber<? super U> subscriber) {
        subscriber.onComplete(cancelled);
    }

    @Override
    public Stream<U> filter(Predicate<? super U> predicate) {
        return new FilterTransformStream<U>(this, predicate);
    }

    @Override
    public <R> Stream<R> map(Function<? super U, ? extends R> mapper) {
        return new MapTransformStream<U, R>(this, mapper);
    }

    @Override
    public <R> Stream<R> flatMap(Function<? super U, ? extends Publisher<? extends R>> mapper) {
        return new FlatMapTransformStream(this, mapper);
    }

    @Override
    public <R> Promise<R> reduce(final R identity, final BiFunction<R, ? super U, R> accumulator) {
        final UnsubscribePromise result = new UnsubscribePromise();
        result.init(this.subscribe(new Subscriber<U>(){
            R _current;
            {
                this._current = identity;
            }

            @Override
            public void onNext(U item) {
                try {
                    this._current = accumulator.apply(this._current, item);
                }
                catch (Exception exc) {
                    LOGGER.warn("Accumulator '{}' failed.", (Object)accumulator, (Object)exc);
                    result.setError(exc);
                }
            }

            @Override
            public void onComplete(boolean cancelled) {
                result.setResult(this._current);
            }

            @Override
            public void onError(Exception err) {
                result.setError(err);
                this._current = null;
            }
        }));
        return result;
    }

    @Override
    public Promise<U> next() {
        final UnsubscribePromise result = new UnsubscribePromise();
        result.init(this.subscribe(new Subscriber<U>(){

            @Override
            public void onNext(U item) {
                result.setResult(item);
            }

            @Override
            public void onComplete(boolean cancelled) {
                result.setError(new Stream.StreamCompleteException());
            }

            @Override
            public void onError(Exception err) {
                result.setError(err);
            }
        }));
        return result;
    }

    @Override
    public Stream<Stream.StreamEvent<U>> materialize() {
        return new MaterializeTransformStream(this);
    }

    private static final class UnsubscribePromise<U>
    extends PromiseImpl<U> {
        private AtomicReference<Subscription<?>> _subRef = new AtomicReference<Object>(null);

        private UnsubscribePromise() {
        }

        void init(Subscription<?> sub) {
            Validate.isTrue((boolean)this._subRef.compareAndSet(null, sub));
            if (this.isComplete()) {
                this.unsubscribe(true);
            }
        }

        @Override
        public boolean setResult(U value) {
            return this.unsubscribe(super.setResult(value));
        }

        @Override
        public boolean setError(Exception err) {
            return this.unsubscribe(super.setError(err));
        }

        boolean unsubscribe(boolean result) {
            Subscription sub = this._subRef.getAndSet(null);
            if (sub != null) {
                sub.cancel();
            }
            return result;
        }
    }

    private final class SubscriberHelper
    implements Subscriber<T> {
        private final Subscriber<? super U> _delegate;

        SubscriberHelper(Subscriber<? super U> delegate) {
            Validate.notNull(delegate);
            this._delegate = delegate;
        }

        @Override
        public void onNext(T item) {
            TransformStream.this.processNext(item, this._delegate);
        }

        @Override
        public void onComplete(boolean cancelled) {
            TransformStream.this.processComplete(cancelled, this._delegate);
        }

        @Override
        public void onError(Exception err) {
            TransformStream.this.processError(err, this._delegate);
        }
    }
}

