/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.reactive.impl.request;

import com.vmware.dr.ui.tools.reactive.Promise;
import com.vmware.dr.ui.tools.reactive.Publisher;
import com.vmware.dr.ui.tools.reactive.impl.PromiseImpl;
import com.vmware.dr.ui.tools.reactive.impl.Promises;
import com.vmware.dr.ui.tools.reactive.impl.Streams;
import com.vmware.dr.ui.tools.utilities.ContextApplier;
import com.vmware.dr.ui.tools.utilities.ContextApplierImpl;
import com.vmware.dr.ui.tools.utilities.ThreadContext;
import java.util.concurrent.Callable;
import org.apache.commons.lang.Validate;

public class RequestContext<T> {
    private static final ThreadLocal<RequestContext<?>> CONTEXT = new ThreadLocal();
    private final Callable<T> _task;
    private final PromiseImpl<Void> _complete;

    public static <S> RequestContext<S> create(Callable<S> task) {
        return new RequestContext<S>(task);
    }

    public static <S> S noContext(Callable<S> task) throws Exception {
        return (S)ThreadContext.extendContext(task, (ContextApplier)new ContextApplierImpl(CONTEXT, null));
    }

    public static RequestContext<?> getContext() {
        return CONTEXT.get();
    }

    private RequestContext(Callable<T> task) {
        Validate.notNull(task, (String)"task");
        this._task = task;
        this._complete = new PromiseImpl();
    }

    public T start() throws Exception {
        return (T)ThreadContext.extendContext(this._task, (ContextApplier)new ContextApplierImpl(CONTEXT, (Object)this));
    }

    public void end() {
        this._complete.setResult(null);
    }

    public void end(Exception exc) {
        this._complete.setError(exc);
    }

    public <V> Promise<V> bind(Promise<V> toBind) {
        Validate.notNull(toBind, (String)"toBind");
        return Streams.from((Publisher[])new Publisher[]{toBind, this._complete.materialize().thenCompose(pr -> {
            if (pr.isSuccessful()) {
                return Promises.reject((Exception)new RequestCompleted());
            }
            return Promises.reject((Exception)new RequestCompleted(pr.getError()));
        })}).next();
    }

    public static final class RequestCompleted
    extends RuntimeException {
        RequestCompleted() {
            super("Request has been completed.", null, true, false);
        }

        RequestCompleted(Exception cause) {
            super(cause.getMessage(), cause, true, false);
        }
    }
}

