/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.internal.protocol.client.rest;

import com.vmware.vapi.data.DataValue;
import com.vmware.vapi.data.ErrorValue;
import com.vmware.vapi.internal.protocol.client.rest.BaseResponseParser;
import com.vmware.vapi.internal.protocol.client.rest.BodyConverter;
import com.vmware.vapi.internal.protocol.client.rest.ErrorConverter;
import com.vmware.vapi.internal.protocol.client.rpc.HttpResponse;
import com.vmware.vapi.internal.util.Validate;

public class DefaultResponseParser
extends BaseResponseParser {
    private final BodyConverter bodyConverter;
    private final ErrorConverter errorConverter;

    public DefaultResponseParser(BodyConverter bodyConverter, ErrorConverter errorConverter) {
        Validate.notNull(bodyConverter);
        Validate.notNull(errorConverter);
        this.bodyConverter = bodyConverter;
        this.errorConverter = errorConverter;
    }

    @Override
    protected DataValue parseBody(String serviceId, String operationId, HttpResponse response) {
        return this.bodyConverter.getResult(serviceId, operationId, response);
    }

    @Override
    protected ErrorValue parseError(HttpResponse response) {
        return this.errorConverter.getError(response);
    }
}

