/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.infrastructure.tasks;

import com.vmware.dr.ui.tools.reactive.Promise;
import com.vmware.dr.ui.tools.reactive.impl.Promises;
import com.vmware.dr.ui.tools.reactive.impl.Streams;
import com.vmware.dr.ui.tools.utilities.Exceptions;
import com.vmware.dr.ui.tools.utilities.ExecutorUtils;
import com.vmware.srm.client.infrastructure.tasks.adapt.HmsTaskAdapter;
import com.vmware.srm.client.infrastructure.tasks.adapt.PCTaskAdapter;
import com.vmware.srm.client.infrastructure.tasks.create.TaskHandle;
import com.vmware.srm.client.infrastructure.tasks.create.impl.TaskHandleImpl;
import com.vmware.srm.client.infrastructure.utils.L10N;
import com.vmware.srm.client.reactive.impl.request.RequestContext;
import com.vmware.srm.client.topology.client.view.ServersView;
import com.vmware.vim.binding.vim.TaskInfo;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.fault.ManagedObjectNotFound;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TasksFacade {
    private static final Logger LOGGER = LoggerFactory.getLogger(TasksFacade.class);
    private static final ReferenceQueue<TaskHandle<?>> REF_QUEUE = new ReferenceQueue();
    private static final TaskHandleGCThread GC = new TaskHandleGCThread();
    private static final ConcurrentMap<ManagedObjectReference, TaskRef> TASKS = new ConcurrentHashMap<ManagedObjectReference, TaskRef>();
    private static final String GUID = "00000000-0000-0000-0000-000000000000";
    private static final String TYPE = "DR-UI-MANAGED-TASK";
    private static final int TTL_MINUTES = 2;

    public static boolean isManagedTask(ManagedObjectReference task) {
        Validate.notNull((Object)task, (String)"task");
        return GUID.equals(task.getServerGuid()) && TYPE.equals(task.getType());
    }

    public static <T> TaskHandle<T> createManagedTaskHandle() {
        ManagedObjectReference moRef = new ManagedObjectReference(TYPE, UUID.randomUUID().toString(), GUID);
        TaskHandleImpl handle = new TaskHandleImpl(moRef);
        TasksFacade.registerTask(handle);
        LOGGER.info("Created new task '{}'.", (Object)moRef);
        return handle;
    }

    public static <T> ManagedObjectReference createManagedTask(Consumer<TaskHandle<T>> handleConsumer) {
        Validate.notNull(handleConsumer, (String)"handleConsumer");
        try {
            return (ManagedObjectReference)RequestContext.noContext(() -> {
                TaskHandle handle = TasksFacade.createManagedTaskHandle();
                try {
                    handleConsumer.accept(handle);
                }
                catch (Exception exc) {
                    handle.fail(exc);
                }
                return handle.getRef();
            });
        }
        catch (Exception e) {
            LOGGER.error("Failed to create task for '{}'", handleConsumer, (Object)e);
            throw Exceptions.getRuntimeException((Throwable)e);
        }
    }

    public static TaskInfo getTaskProgress(ManagedObjectReference managedTask) {
        return TasksFacade.getHandle(managedTask).getTaskInfo();
    }

    public static ManagedObjectReference createSrmOrVcMultiTask(ServersView view, ManagedObjectReference ... vmomiTasks) {
        Set<ManagedObjectReference> tasks = Arrays.stream(vmomiTasks).collect(Collectors.toSet());
        return new PCTaskAdapter(view).start(tasks).getRef();
    }

    public static ManagedObjectReference createHmsMultiTask(ServersView view, ManagedObjectReference ... vmomiTasks) {
        Set<ManagedObjectReference> tasks = Arrays.stream(vmomiTasks).collect(Collectors.toSet());
        return new HmsTaskAdapter(view).start(tasks).getRef();
    }

    public static ManagedObjectReference createCompositeMultiTask(ManagedObjectReference ... multiTasks) {
        TaskHandle taskHandle = TasksFacade.createManagedTaskHandle();
        if (multiTasks.length == 0) {
            taskHandle.complete(null);
            return taskHandle.getRef();
        }
        try {
            TasksFacade.monitorCompositeMultiTask(multiTasks).onError(taskHandle::fail).onSuccess(taskHandle::complete);
        }
        catch (Exception exc) {
            taskHandle.fail(exc);
        }
        return taskHandle.getRef();
    }

    public static <T> Promise<T> monitorSrmOrVcTask(ServersView view, ManagedObjectReference taskRef) {
        return new PCTaskAdapter(view).start(taskRef).thenApply(Function.identity());
    }

    public static Promise<Void> monitorSrmOrVcMultiTask(ServersView view, ManagedObjectReference ... vmomiTasks) {
        Set<ManagedObjectReference> tasks = Arrays.stream(vmomiTasks).collect(Collectors.toSet());
        return new PCTaskAdapter(view).start(tasks).thenApply(Function.identity());
    }

    public static <T> Promise<T> monitorHmsTask(ServersView view, ManagedObjectReference taskRef) {
        return new HmsTaskAdapter(view).start(taskRef).thenApply(Function.identity());
    }

    public static Promise<Void> monitorHmsMultiTask(ServersView view, ManagedObjectReference ... vmomiTasks) {
        Set<ManagedObjectReference> tasks = Arrays.stream(vmomiTasks).collect(Collectors.toSet());
        return new HmsTaskAdapter(view).start(tasks).thenApply(Function.identity());
    }

    public static <T> Promise<T> monitorManagedTask(ManagedObjectReference managedTaskRef) {
        TaskHandle<?> handle;
        Validate.notNull((Object)managedTaskRef, (String)"Task is null.");
        try {
            handle = TasksFacade.getHandle(managedTaskRef);
        }
        catch (ManagedObjectNotFound monf) {
            return Promises.reject((Exception)((Object)monf));
        }
        return handle.thenApply(result -> result);
    }

    public static Promise<Void> monitorCompositeMultiTask(ManagedObjectReference ... multiTasks) {
        if (multiTasks.length == 0) {
            return Promises.resolve(null);
        }
        return Streams.from(Arrays.asList(multiTasks)).flatMap(moRef -> TasksFacade.getHandle(moRef).thenApply(ignored -> null)).reduce(null, (ignored, taskResult) -> ignored);
    }

    private static void registerTask(TaskHandleImpl<?> handle) {
        if (TASKS.putIfAbsent(handle.getRef(), new TaskRef(handle)) != null) {
            throw new IllegalArgumentException("Task '" + handle.getRef() + "' already registered.");
        }
        handle.materialize().onSuccess(pr -> {
            if (pr.isSuccessful()) {
                LOGGER.info("Task '{}' completed successfully.", (Object)handle.getRef());
            } else {
                LOGGER.warn("Task '{}' completed with error.", (Object)handle.getRef(), (Object)pr.getError());
            }
            ExecutorUtils.getScheduledExecutor().schedule(() -> {
                LOGGER.info("Removing handle for task '{}'", (Object)handle.getRef());
                TASKS.remove(handle.getRef());
            }, 2L, TimeUnit.MINUTES);
        });
    }

    private static TaskHandle<?> getHandle(ManagedObjectReference task) {
        TaskHandle handle;
        Validate.notNull((Object)task, (String)"Task is null.");
        TaskRef taskRef = (TaskRef)TASKS.get(task);
        if (taskRef == null || (handle = (TaskHandle)taskRef.get()) == null) {
            ManagedObjectNotFound fault = new ManagedObjectNotFound(task);
            fault.setMessage(L10N.localize("tasks.monf", task));
            throw fault;
        }
        return handle;
    }

    static {
        GC.start();
    }

    private static final class TaskHandleGCThread
    extends Thread {
        TaskHandleGCThread() {
            super("task-handle-gc-thread");
            this.setDaemon(true);
        }

        @Override
        public void run() {
            try {
                while (true) {
                    TaskRef ref = (TaskRef)REF_QUEUE.remove();
                    if (TASKS.remove(ref._taskRef) != ref) continue;
                    LOGGER.error("Removed abandoned task handle for '{}'", (Object)ref._taskRef);
                }
            }
            catch (InterruptedException e) {
                LOGGER.warn("task-handle-gc-thread interrupted.");
                this.interrupt();
                return;
            }
        }
    }

    private static final class TaskRef
    extends WeakReference<TaskHandleImpl<?>> {
        private final ManagedObjectReference _taskRef;

        private TaskRef(TaskHandleImpl<?> handle) {
            super(handle, REF_QUEUE);
            this._taskRef = handle.getRef();
        }
    }
}

