/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.impex.importers.mappings;

import com.vmware.dr.ui.tools.reactive.Promise;
import com.vmware.dr.ui.tools.reactive.impl.Promises;
import com.vmware.srm.client.impex.configurables.mappings.FolderMappingsConverter;
import com.vmware.srm.client.impex.configurables.mappings.IeFolderMapping;
import com.vmware.srm.client.impex.configurables.mappings.IeMappings;
import com.vmware.srm.client.impex.configurables.mappings.IeNetworkMapping;
import com.vmware.srm.client.impex.configurables.mappings.IeResourceMapping;
import com.vmware.srm.client.impex.configurables.mappings.IeStorageProfileMapping;
import com.vmware.srm.client.impex.configurables.mappings.IeTestNetworkMapping;
import com.vmware.srm.client.impex.configurables.mappings.InventoryTestNetworkMappingConverter;
import com.vmware.srm.client.impex.configurables.mappings.ResourcePoolMappingsConverter;
import com.vmware.srm.client.impex.configurables.mappings.StorageProfileMappingsConverter;
import com.vmware.srm.client.impex.importers.inventory.InventoryExtractor;
import com.vmware.srm.client.impex.importers.mappings.NetworkMappingsImporter;
import com.vmware.srm.client.impex.tool.ImpexImportSrmContext;
import com.vmware.srm.client.impex.utils.IContextUtil;
import com.vmware.srm.client.impex.utils.ImpexL10N;
import com.vmware.srm.client.reactive.impl.FuturePromise;
import com.vmware.srm.client.topology.client.view.availability.srm.SrmPairSetup;
import com.vmware.srm.client.topology.client.view.availability.srm.SrmServer;
import com.vmware.srm.client.topology.client.vmomi.availability.srm.SrmService;
import com.vmware.vim.binding.dr.InventoryMapper;
import com.vmware.vim.binding.dr.InventoryMapperBase;
import com.vmware.vim.binding.dr.site.RemoteSite;
import com.vmware.vim.binding.pbm.profile.Profile;
import com.vmware.vim.vmomi.core.Future;
import java.util.ArrayList;
import org.apache.commons.lang.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MappingsImporter {
    private static final Logger LOGGER = LoggerFactory.getLogger(MappingsImporter.class);
    private final boolean _local;
    private final InventoryExtractor.InventoryLookup _inventory;
    private final Profile[] _localProfiles;
    private final Profile[] _remoteProfiles;
    private IeNetworkMapping[] _networkMappings;
    private IeFolderMapping[] _folderMappings;
    private IeResourceMapping[] _resourceMappings;
    private IeStorageProfileMapping[] _storageProfileMappings;
    private IeTestNetworkMapping[] _testNetworkMappings;

    public MappingsImporter(InventoryExtractor.InventoryLookup inventory, Profile[] localProfiles, Profile[] remoteProfiles, boolean local) {
        this._inventory = inventory;
        this._localProfiles = localProfiles;
        this._remoteProfiles = remoteProfiles;
        this._local = local;
        this.initIeMappings();
    }

    public Promise<Void> create() {
        LOGGER.info("MappingsImporter::create");
        SrmPairSetup pairSetup = (SrmPairSetup)(this._local ? ImpexImportSrmContext.get().getServersDataWrapper().getLocalPair() : ImpexImportSrmContext.get().getServersDataWrapper().getRemotePair());
        SrmServer server = (SrmServer)pairSetup.server();
        RemoteSite remoteSite = (RemoteSite)((SrmService)server.service()).createStub(pairSetup.pairServerVmomiRef());
        FuturePromise mapperMoRefPromise = new FuturePromise();
        remoteSite.getInventoryMapper((Future)mapperMoRefPromise);
        return mapperMoRefPromise.onError(error -> {
            String message = ImpexL10N.localize("mappings.inventoryMapper", server.vc().guid());
            LOGGER.warn(message, (Throwable)error);
            ImpexImportSrmContext.get().addError(message, (Exception)error);
        }).thenCompose(mapperMoRef -> {
            InventoryMapper mapper = (InventoryMapper)((SrmService)server.service()).createStub(mapperMoRef);
            Promise networkResult = new NetworkMappingsImporter(!this._local, mapper, this._networkMappings, this._inventory).create().onError(error -> {
                LOGGER.warn("Network mapping creation failed - skipping test network mapping creation.", (Throwable)error);
                ImpexImportSrmContext.get().addError(ImpexL10N.localize("mappings.network", new Object[0]), (Exception)error);
            });
            ArrayList<Object> results = new ArrayList<Object>();
            results.add(this.createFolderMappings(this._folderMappings, mapper));
            results.add(this.createResourceMappings(this._resourceMappings, mapper));
            results.add(this.createStorageProfileMappings(mapper));
            results.add(networkResult.thenCompose(result -> this.createTestNetworkMappings(this._testNetworkMappings, mapper)));
            return Promises.allWithException((Promise[])results.toArray(new Promise[results.size()])).thenApply(unused -> null);
        });
    }

    private void initIeMappings() {
        IeMappings ieMappings = ImpexImportSrmContext.get().getConfigurablesWrapper().getMappings().stream().filter(mapping -> mapping.isLocal() == this._local).findFirst().orElse(null);
        if (ieMappings != null) {
            this._networkMappings = ieMappings.getNetworks();
            this._folderMappings = ieMappings.getFolders();
            this._resourceMappings = ieMappings.getResources();
            this._storageProfileMappings = ieMappings.getStorageProfiles();
            this._testNetworkMappings = ieMappings.getTestNetworks();
        }
    }

    private Promise<Void> createFolderMappings(IeFolderMapping[] ieMappings, InventoryMapper mapper) {
        if (ieMappings == null) {
            LOGGER.debug("No folder mappings found for mapper with guid '{}'.", (Object)mapper._getRef().getServerGuid());
            return Promises.resolve(null);
        }
        Object[] toCreate = FolderMappingsConverter.toVmodl(ieMappings, this._inventory);
        if (ArrayUtils.isEmpty((Object[])toCreate)) {
            LOGGER.info("No folder mappings added.");
            return Promises.resolve(null);
        }
        FuturePromise result = new FuturePromise();
        mapper.addFolderMappings((InventoryMapperBase.FolderMapping[])toCreate, (Future)result);
        result.onSuccess(done -> LOGGER.info("Folder mappings were created successfully.")).onError(error -> {
            String message = ImpexL10N.localize("mappings.folder", new Object[0]);
            LOGGER.warn(message, (Throwable)error);
            ImpexImportSrmContext.get().addError(message, (Exception)error);
        });
        return result;
    }

    private Promise<Void> createResourceMappings(IeResourceMapping[] ieMappings, InventoryMapper mapper) {
        if (ieMappings == null) {
            LOGGER.debug("No resource mappings found for mapper with guid: '{}'.", (Object)mapper._getRef().getServerGuid());
            return Promises.resolve(null);
        }
        Object[] toCreate = ResourcePoolMappingsConverter.toVmodl(ieMappings, this._inventory);
        if (ArrayUtils.isEmpty((Object[])toCreate)) {
            LOGGER.debug("No resource pool mappings added.");
            return Promises.resolve(null);
        }
        FuturePromise result = new FuturePromise();
        mapper.addResourcePoolMappings((InventoryMapperBase.ResourcePoolMapping[])toCreate, (Future)result);
        result.onSuccess(done -> LOGGER.info("Resource pool mappings were created successfully.")).onError(error -> {
            String message = ImpexL10N.localize("mappings.resource", new Object[0]);
            LOGGER.warn(message, (Throwable)error);
            ImpexImportSrmContext.get().addError(message, (Exception)error);
        });
        return result;
    }

    private Promise<Void> createStorageProfileMappings(InventoryMapper mapper) {
        IeStorageProfileMapping[] ieMappings = this._storageProfileMappings;
        if (ieMappings == null) {
            LOGGER.debug("No storage profile mappings found for mapper with guid '{}'.", (Object)mapper._getRef().getServerGuid());
            return Promises.resolve(null);
        }
        SrmServer server = IContextUtil.getSrmServer(this._local);
        Object[] toCreate = StorageProfileMappingsConverter.toVmodl(ieMappings, server.vc().guid(), IContextUtil.getSrmServer(!this._local).vc().guid(), this._local ? this._localProfiles : this._remoteProfiles, this._local ? this._remoteProfiles : this._localProfiles);
        if (ArrayUtils.isEmpty((Object[])toCreate)) {
            LOGGER.debug("No storage profile mappings added.");
            return Promises.resolve(null);
        }
        FuturePromise result = new FuturePromise();
        mapper.addStorageProfileMappings((InventoryMapperBase.StorageProfileMapping[])toCreate, (Future)result);
        result.onSuccess(done -> LOGGER.info("Storage profile mappings were created successfully for server with guid '{}'.", (Object)server.guid())).onError(error -> {
            LOGGER.warn("Failed to create storage profile mappings for server with guid '{}'.", (Object)server.guid(), error);
            ImpexImportSrmContext.get().addError(ImpexL10N.localize("mappings.storageProfile", new Object[0]), (Exception)error);
        });
        return result;
    }

    private Promise<Void> createTestNetworkMappings(IeTestNetworkMapping[] ieMappings, InventoryMapper mapper) {
        if (ieMappings == null) {
            LOGGER.debug("No test network mappings found for mapper with guid '{}'.", (Object)mapper._getRef().getServerGuid());
            return Promises.resolve(null);
        }
        Object[] toCreate = InventoryTestNetworkMappingConverter.toVmodl(ieMappings, this._inventory);
        if (ArrayUtils.isEmpty((Object[])toCreate)) {
            LOGGER.debug("No test network mappings added.");
            return Promises.resolve(null);
        }
        FuturePromise result = new FuturePromise();
        mapper.addTestNetworkMappings((InventoryMapperBase.TestNetworkMapping[])toCreate, (Future)result);
        result.onSuccess(done -> LOGGER.info("Test network mappings were created successfully.")).onError(error -> {
            String message = ImpexL10N.localize("mappings.testNetwork", new Object[0]);
            LOGGER.warn(message, (Throwable)error);
            ImpexImportSrmContext.get().addError(message, (Exception)error);
        });
        return result;
    }
}

