/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.dr.ui.tools.utilities;

import com.vmware.dr.ui.tools.utilities.ExecuteOnceOpWrapper;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.Validate;

public abstract class CachingProducer<K, V> {
    private final Map<K, ValueHolder> _valueHolderByKey;

    public CachingProducer(Set<K> keys) {
        Validate.notEmpty(keys, (String)"keys");
        this._valueHolderByKey = new HashMap<K, ValueHolder>(keys.size());
        for (K key : keys) {
            this._valueHolderByKey.put(key, new ValueHolder(key));
        }
    }

    public V get(K key) {
        Validate.notNull(key, (String)"key");
        ValueHolder vh = this._valueHolderByKey.get(key);
        if (vh == null) {
            throw new IllegalArgumentException("Invalid key: " + key);
        }
        return vh.get(key);
    }

    protected abstract V produce(K var1) throws Exception;

    private class ValueHolder {
        private final ExecuteOnceOpWrapper<V> _opWrapper;

        ValueHolder(K key) {
            Validate.notNull(key, (String)"key");
            this._opWrapper = new ExecuteOnceOpWrapper<Object>(() -> CachingProducer.this.produce(key));
        }

        V get(K key) {
            return this._opWrapper.invoke().get();
        }
    }
}

