/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.dr.ui.tools.utilities;

import com.vmware.dr.ui.tools.utilities.Exceptions;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;

public class OperationWaiter<T> {
    protected volatile T _result;
    protected volatile Exception _error;
    protected final AtomicBoolean _complete = new AtomicBoolean(false);
    private final CountDownLatch _latch = new CountDownLatch(1);

    public T get() throws OperationWaiterException {
        this.waitToComplete();
        if (this._error != null) {
            throw new OperationWaiterException(this._error);
        }
        return this._result;
    }

    public Exception getError() {
        this.waitToComplete();
        return this._error;
    }

    public boolean getComplete() {
        return this._latch.getCount() == 0L;
    }

    public boolean setResult(T result) {
        if (!this._complete.compareAndSet(false, true)) {
            return false;
        }
        this._result = result;
        this._latch.countDown();
        return true;
    }

    public boolean setError(Exception e) {
        if (e == null) {
            throw new IllegalArgumentException("error");
        }
        if (!this._complete.compareAndSet(false, true)) {
            return false;
        }
        this._error = e;
        this._latch.countDown();
        return true;
    }

    private void waitToComplete() {
        if (this._latch.getCount() == 0L) {
            return;
        }
        try {
            this._latch.await();
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            throw Exceptions.getRuntimeException(ie);
        }
    }

    public static class OperationWaiterException
    extends RuntimeException {
        private static final long serialVersionUID = 6960647080618900088L;

        public OperationWaiterException(Exception cause) {
            super(cause);
        }
    }
}

