/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.bindings;

import com.vmware.vapi.internal.util.Validate;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public abstract class ApiEnumeration<E extends ApiEnumeration<E>>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String name;

    protected ApiEnumeration(String name) {
        Validate.notNull(name);
        this.name = name;
    }

    protected static <T extends ApiEnumeration<T>> Map<String, T> buildNameMap(T[] values) {
        Validate.notNull(values);
        HashMap<String, T> byName = new HashMap<String, T>();
        for (T value : values) {
            byName.put(((ApiEnumeration)value).name(), value);
        }
        return byName;
    }

    public String name() {
        return this.name;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!this.getClass().isInstance(obj)) {
            return false;
        }
        ApiEnumeration other = (ApiEnumeration)obj;
        return this.name().equals(other.name());
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return this.name();
    }
}

