/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.internal.bindings;

import com.vmware.vapi.bindings.convert.ConverterException;
import com.vmware.vapi.bindings.type.AnyErrorType;
import com.vmware.vapi.bindings.type.BinaryType;
import com.vmware.vapi.bindings.type.BooleanType;
import com.vmware.vapi.bindings.type.DateTimeType;
import com.vmware.vapi.bindings.type.DoubleType;
import com.vmware.vapi.bindings.type.DynamicStructType;
import com.vmware.vapi.bindings.type.EnumType;
import com.vmware.vapi.bindings.type.ErrorType;
import com.vmware.vapi.bindings.type.IdType;
import com.vmware.vapi.bindings.type.IntegerType;
import com.vmware.vapi.bindings.type.ListType;
import com.vmware.vapi.bindings.type.MapType;
import com.vmware.vapi.bindings.type.OpaqueType;
import com.vmware.vapi.bindings.type.OptionalType;
import com.vmware.vapi.bindings.type.SecretType;
import com.vmware.vapi.bindings.type.SetType;
import com.vmware.vapi.bindings.type.StringType;
import com.vmware.vapi.bindings.type.StructType;
import com.vmware.vapi.bindings.type.Type;
import com.vmware.vapi.bindings.type.TypeReference;
import com.vmware.vapi.bindings.type.TypeVisitor;
import com.vmware.vapi.bindings.type.UriType;
import com.vmware.vapi.bindings.type.VoidType;
import com.vmware.vapi.data.BlobValue;
import com.vmware.vapi.data.BooleanValue;
import com.vmware.vapi.data.DataType;
import com.vmware.vapi.data.DataValue;
import com.vmware.vapi.data.DoubleValue;
import com.vmware.vapi.data.ErrorValue;
import com.vmware.vapi.data.IntegerValue;
import com.vmware.vapi.data.ListValue;
import com.vmware.vapi.data.OptionalValue;
import com.vmware.vapi.data.SecretValue;
import com.vmware.vapi.data.StringValue;
import com.vmware.vapi.data.StructValue;
import com.vmware.vapi.data.VoidValue;
import com.vmware.vapi.internal.bindings.TypeConverter;
import com.vmware.vapi.internal.bindings.convert.ConverterFactory;
import com.vmware.vapi.internal.bindings.convert.impl.ConvertUtil;
import com.vmware.vapi.internal.bindings.convert.impl.DefaultConverterFactory;
import com.vmware.vapi.internal.util.Validate;
import org.apache.commons.codec.binary.Base64;

public final class TypeConverterImpl
implements TypeConverter {
    private final ConverterFactory converterFactory;
    private final boolean reuseForValidation;

    public TypeConverterImpl() {
        this(new DefaultConverterFactory());
    }

    public TypeConverterImpl(ConverterFactory converterFactory) {
        this(converterFactory, true, false);
    }

    public TypeConverterImpl(boolean permissive) {
        this(new DefaultConverterFactory(), true, false);
    }

    public TypeConverterImpl(ConverterFactory converterFactory, boolean permissive, boolean reuseForValidation) {
        Validate.notNull(converterFactory);
        this.converterFactory = converterFactory;
        this.reuseForValidation = reuseForValidation;
    }

    @Override
    public <T> T convertToJava(DataValue value, Type type) {
        if (!(type instanceof OptionalType) && value == null) {
            throw new ConverterException("vapi.bindings.typeconverter.fromvalue.value.missing", new String[0]);
        }
        if (type == null) {
            throw new ConverterException("vapi.bindings.typeconverter.fromvalue.type.missing", new String[0]);
        }
        ValueToJavaVisitor visitor = new ValueToJavaVisitor(this, value);
        type.accept(visitor);
        return visitor.getJavaObject();
    }

    @Override
    public DataValue convertToVapi(Object obj, Type type) {
        return this.convertToVapi(obj, type, new TypeConverter.ConversionContext());
    }

    @Override
    public DataValue convertToVapi(Object obj, Type type, TypeConverter.ConversionContext cc) {
        if (type == null) {
            throw new ConverterException("vapi.bindings.typeconverter.tovalue.type.missing", new String[0]);
        }
        JavaToValueVisitor visitor = new JavaToValueVisitor(this, obj, cc);
        type.accept(visitor);
        return visitor.getValue();
    }

    @Override
    public TypeConverter reusableThis() {
        if (this.reuseForValidation) {
            return this;
        }
        return null;
    }

    private class JavaToValueVisitor
    implements TypeVisitor {
        private final TypeConverter typeConverter;
        private final Object obj;
        private DataValue value;
        private TypeConverter.ConversionContext cc;

        public JavaToValueVisitor(TypeConverter typeConverter, Object obj, TypeConverter.ConversionContext cc) {
            this.typeConverter = typeConverter;
            this.obj = obj;
            this.cc = cc;
        }

        public DataValue getValue() {
            return this.value;
        }

        @Override
        public void visit(VoidType type) {
            this.value = TypeConverterImpl.this.converterFactory.getVoidConverter().toValue(this.obj);
        }

        @Override
        public void visit(BooleanType type) {
            this.value = TypeConverterImpl.this.converterFactory.getBooleanConverter().toValue(this.obj);
        }

        @Override
        public void visit(IntegerType type) {
            this.value = TypeConverterImpl.this.converterFactory.getIntegerConverter().toValue(this.obj);
        }

        @Override
        public void visit(DoubleType type) {
            this.value = TypeConverterImpl.this.converterFactory.getDoubleConverter().toValue(this.obj);
        }

        @Override
        public void visit(StringType type) {
            this.value = TypeConverterImpl.this.converterFactory.getStringConverter().toValue(this.obj);
        }

        @Override
        public void visit(BinaryType type) {
            this.value = TypeConverterImpl.this.converterFactory.getBinaryConverter().toValue(this.obj);
        }

        @Override
        public void visit(SecretType type) {
            this.value = TypeConverterImpl.this.converterFactory.getSecretConverter().toValue(this.obj);
        }

        @Override
        public void visit(DateTimeType type) {
            this.value = TypeConverterImpl.this.converterFactory.getDateTimeConverter().toValue(this.obj);
        }

        @Override
        public void visit(UriType type) {
            this.value = TypeConverterImpl.this.converterFactory.getUriConverter().toValue(this.obj);
        }

        @Override
        public void visit(OptionalType type) {
            this.value = TypeConverterImpl.this.converterFactory.getOptionalConverter().toValue(this.obj, type, this.typeConverter, this.cc);
        }

        @Override
        public void visit(ListType type) {
            this.value = TypeConverterImpl.this.converterFactory.getListConverter().toValue(this.obj, type, this.typeConverter, this.cc);
        }

        @Override
        public void visit(SetType type) {
            this.value = TypeConverterImpl.this.converterFactory.getSetConverter().toValue(this.obj, type, this.typeConverter, this.cc);
        }

        @Override
        public void visit(MapType type) {
            this.value = TypeConverterImpl.this.converterFactory.getMapConverter().toValue(this.obj, type, this.typeConverter, this.cc);
        }

        @Override
        public void visit(StructType type) {
            StructValue structValue = (StructValue)TypeConverterImpl.this.converterFactory.getStructConverter().toValue(this.obj, type, this.typeConverter, this.cc);
            type.validate(structValue);
            this.value = structValue;
        }

        @Override
        public void visit(OpaqueType type) {
            this.value = TypeConverterImpl.this.converterFactory.getOpaqueConverter().toValue(this.obj);
        }

        @Override
        public void visit(TypeReference<? extends Type> type) {
            Type referredType = type.resolve();
            referredType.accept(this);
        }

        @Override
        public void visit(EnumType type) {
            this.value = TypeConverterImpl.this.converterFactory.getEnumConverter().toValue(this.obj, type, this.typeConverter, this.cc);
        }

        @Override
        public void visit(ErrorType type) {
            StructValue errorValue = (StructValue)TypeConverterImpl.this.converterFactory.getErrorConverter().toValue(this.obj, type, this.typeConverter, this.cc);
            type.validate(errorValue);
            this.value = errorValue;
        }

        @Override
        public void visit(IdType idType) {
            this.value = TypeConverterImpl.this.converterFactory.getIdConverter().toValue(this.obj);
        }

        @Override
        public void visit(DynamicStructType type) {
            this.value = TypeConverterImpl.this.converterFactory.getDynamicStructureConverter().toValue(this.obj, type, this.typeConverter, this.cc);
            type.validate(ConvertUtil.narrowType(this.value, StructValue.class), TypeConverterImpl.this.reusableThis());
        }

        @Override
        public void visit(AnyErrorType type) {
            this.value = TypeConverterImpl.this.converterFactory.getAnyErrorConverter().toValue(this.obj, type, this.typeConverter, this.cc);
        }
    }

    private class ValueToJavaVisitor
    implements TypeVisitor {
        private static final String UNRESOLVEABLE_NAME = "unresolved_39DFA178-BED8-4A21-BF2F-2F648C0DDFF4";
        private final TypeConverter typeConverter;
        private final DataValue value;
        private Object obj;

        ValueToJavaVisitor(TypeConverter typeConverter, DataValue value) {
            this.typeConverter = typeConverter;
            this.value = value;
        }

        <T> T getJavaObject() {
            Object result = this.obj;
            return (T)result;
        }

        @Override
        public void visit(VoidType type) {
            VoidValue v = ConvertUtil.narrowType(this.value, VoidValue.class);
            this.obj = TypeConverterImpl.this.converterFactory.getVoidConverter().fromValue(v);
        }

        @Override
        public void visit(BooleanType type) {
            BooleanValue v = this.convertDynamically(false) ? BooleanValue.getInstance(Boolean.parseBoolean(this.getAsString(this.value))) : ConvertUtil.narrowType(this.value, BooleanValue.class);
            this.obj = TypeConverterImpl.this.converterFactory.getBooleanConverter().fromValue(v);
        }

        @Override
        public void visit(IntegerType type) {
            IntegerValue v = this.convertDynamically(false) ? new IntegerValue(Long.parseLong(this.getAsString(this.value))) : ConvertUtil.narrowType(this.value, IntegerValue.class);
            this.obj = TypeConverterImpl.this.converterFactory.getIntegerConverter().fromValue(v);
        }

        @Override
        public void visit(DoubleType type) {
            DoubleValue v = this.convertDynamically(false) ? new DoubleValue(Double.parseDouble(this.getAsString(this.value))) : ConvertUtil.narrowType(this.value, DoubleValue.class);
            this.obj = TypeConverterImpl.this.converterFactory.getDoubleConverter().fromValue(v);
        }

        @Override
        public void visit(StringType type) {
            StringValue v = ConvertUtil.narrowType(this.value, StringValue.class);
            this.obj = TypeConverterImpl.this.converterFactory.getStringConverter().fromValue(v);
        }

        @Override
        public void visit(BinaryType type) {
            BlobValue v = this.convertDynamically(false) ? new BlobValue(Base64.decodeBase64((String)this.getAsString(this.value))) : ConvertUtil.narrowType(this.value, BlobValue.class);
            this.obj = TypeConverterImpl.this.converterFactory.getBinaryConverter().fromValue(v);
        }

        @Override
        public void visit(SecretType type) {
            SecretValue v = this.convertDynamically(false) ? new SecretValue(this.getAsString(this.value).toCharArray()) : ConvertUtil.narrowType(this.value, SecretValue.class);
            this.obj = TypeConverterImpl.this.converterFactory.getSecretConverter().fromValue(v);
        }

        @Override
        public void visit(DateTimeType type) {
            StringValue v = ConvertUtil.narrowType(this.value, StringValue.class);
            this.obj = TypeConverterImpl.this.converterFactory.getDateTimeConverter().fromValue(v);
        }

        @Override
        public void visit(UriType type) {
            StringValue v = ConvertUtil.narrowType(this.value, StringValue.class);
            this.obj = TypeConverterImpl.this.converterFactory.getUriConverter().fromValue(v);
        }

        @Override
        public void visit(IdType idType) {
            StringValue v = ConvertUtil.narrowType(this.value, StringValue.class);
            this.obj = TypeConverterImpl.this.converterFactory.getIdConverter().fromValue(v);
        }

        @Override
        public void visit(OptionalType type) {
            OptionalValue v = null;
            if (this.value != null) {
                boolean addOptional = this.value.getType() != DataType.OPTIONAL;
                v = addOptional ? new OptionalValue(this.value) : ConvertUtil.narrowType(this.value, OptionalValue.class);
            }
            this.obj = TypeConverterImpl.this.converterFactory.getOptionalConverter().fromValue(v, type, this.typeConverter);
        }

        @Override
        public void visit(ListType type) {
            ListValue v = this.convertListValue();
            this.obj = TypeConverterImpl.this.converterFactory.getListConverter().fromValue(v, type, this.typeConverter);
        }

        @Override
        public void visit(SetType type) {
            ListValue v = this.convertListValue();
            this.obj = TypeConverterImpl.this.converterFactory.getSetConverter().fromValue(v, type, this.typeConverter);
        }

        @Override
        public void visit(MapType type) {
            DataValue v = this.value.getType() == DataType.STRUCTURE ? this.value : this.convertListValue();
            this.obj = TypeConverterImpl.this.converterFactory.getMapConverter().fromValue(v, type, this.typeConverter);
        }

        @Override
        public void visit(StructType type) {
            StructValue structValue = this.convertDynamically(true) ? new StructValue(type.getName()) : ConvertUtil.narrowType(this.value, StructValue.class);
            type.validate(structValue);
            this.obj = TypeConverterImpl.this.converterFactory.getStructConverter().fromValue(structValue, type, this.typeConverter);
        }

        private ListValue convertListValue() {
            return this.convertDynamically(true) ? new ListValue() : ConvertUtil.narrowType(this.value, ListValue.class);
        }

        @Override
        public void visit(OpaqueType type) {
            this.obj = TypeConverterImpl.this.converterFactory.getOpaqueConverter().fromValue(this.value);
        }

        @Override
        public void visit(TypeReference<? extends Type> type) {
            Type referredType = type.resolve();
            referredType.accept(this);
        }

        @Override
        public void visit(EnumType type) {
            StringValue v = ConvertUtil.narrowType(this.value, StringValue.class);
            this.obj = TypeConverterImpl.this.converterFactory.getEnumConverter().fromValue(v, type, this.typeConverter);
        }

        @Override
        public void visit(ErrorType type) {
            ErrorValue errorValue = this.coerceErrorValue(type.getName());
            type.validate(errorValue);
            this.obj = TypeConverterImpl.this.converterFactory.getErrorConverter().fromValue(errorValue, type, this.typeConverter);
        }

        @Override
        public void visit(DynamicStructType type) {
            StructValue structValue = ConvertUtil.narrowType(this.value, StructValue.class);
            type.validate(structValue, TypeConverterImpl.this.reusableThis());
            this.obj = TypeConverterImpl.this.converterFactory.getDynamicStructureConverter().fromValue(structValue, type, this.typeConverter);
        }

        @Override
        public void visit(AnyErrorType type) {
            ErrorValue errorValue = this.coerceErrorValue(UNRESOLVEABLE_NAME);
            this.obj = TypeConverterImpl.this.converterFactory.getAnyErrorConverter().fromValue(errorValue, type, this.typeConverter);
        }

        private boolean convertDynamically(boolean emptyValueAllowed) {
            if (this.value.getType() == DataType.STRING) {
                StringValue stringValue = ConvertUtil.narrowType(this.value, StringValue.class);
                if (emptyValueAllowed) {
                    return stringValue.getValue().isEmpty();
                }
                return !stringValue.getValue().isEmpty();
            }
            return false;
        }

        private ErrorValue coerceErrorValue(String errName) {
            DataValue valueToConvert = this.value;
            if (this.convertDynamically(true)) {
                valueToConvert = new ErrorValue(errName);
            } else if (!ErrorValue.class.isInstance(valueToConvert) && StructValue.class.isInstance(valueToConvert)) {
                ErrorValue ev = new ErrorValue(errName);
                StructValue sv = (StructValue)valueToConvert;
                for (String name : sv.getFieldNames()) {
                    ev.setField(name, sv.getField(name));
                }
                valueToConvert = ev;
            }
            return ConvertUtil.narrowType(valueToConvert, ErrorValue.class);
        }

        private String getAsString(DataValue value) {
            return ConvertUtil.narrowType(value, StringValue.class).getValue();
        }
    }
}

