/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.internal.protocol.client.msg.json;

import com.vmware.vapi.client.exception.MessageProtocolException;
import com.vmware.vapi.core.ApiProvider;
import com.vmware.vapi.core.AsyncHandle;
import com.vmware.vapi.core.Consumer;
import com.vmware.vapi.core.ExecutionContext;
import com.vmware.vapi.core.MethodResult;
import com.vmware.vapi.data.DataValue;
import com.vmware.vapi.data.ErrorValue;
import com.vmware.vapi.data.StringValue;
import com.vmware.vapi.internal.core.abort.AbortHandle;
import com.vmware.vapi.internal.core.abort.AbortHandleProvider;
import com.vmware.vapi.internal.protocol.client.rpc.CorrelatingClient;
import com.vmware.vapi.internal.protocol.client.rpc.ExecutorAsyncHandle;
import com.vmware.vapi.internal.protocol.common.Util;
import com.vmware.vapi.internal.protocol.common.json.JsonApiRequest;
import com.vmware.vapi.internal.protocol.common.json.JsonApiResponse;
import com.vmware.vapi.internal.protocol.common.json.JsonBaseResponse;
import com.vmware.vapi.internal.protocol.common.json.JsonConstants;
import com.vmware.vapi.internal.protocol.common.json.JsonDeserializer;
import com.vmware.vapi.internal.protocol.common.json.JsonInvokeRequestParams2;
import com.vmware.vapi.internal.protocol.common.json.JsonMsgDeserializer2;
import com.vmware.vapi.internal.protocol.common.json.JsonMsgSerializer2;
import com.vmware.vapi.internal.protocol.common.json.JsonProgressResponse;
import com.vmware.vapi.internal.protocol.common.msg.JsonMessageProtocolExceptionTranslator;
import com.vmware.vapi.internal.tracing.TracingScope;
import com.vmware.vapi.internal.tracing.TracingSpan;
import com.vmware.vapi.internal.tracing.otel.TracingAttributeKey;
import com.vmware.vapi.internal.util.StringUtils;
import com.vmware.vapi.internal.util.io.IoUtil;
import com.vmware.vapi.internal.util.io.ReleasableInputStream;
import com.vmware.vapi.protocol.ClientConfiguration;
import com.vmware.vapi.protocol.Constants;
import com.vmware.vapi.protocol.RequestProcessor;
import com.vmware.vapi.tracing.Tracer;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JsonApiProvider
implements ApiProvider {
    private static final String UTF8_CHARSET = "UTF-8";
    private static Logger logger = LoggerFactory.getLogger(JsonApiProvider.class);
    private final JsonMsgSerializer2 jsonSerializer2;
    private Map<String, JsonDeserializer> deserializers;
    private final List<RequestProcessor> processorChain;
    private final CorrelatingClient client;
    private final Executor executor;
    private final Tracer tracer;

    public JsonApiProvider(CorrelatingClient client, ClientConfiguration config) {
        this(client, config, JsonApiProvider.prepareDeserializers(false));
    }

    public JsonApiProvider(CorrelatingClient client, ClientConfiguration config, Map<String, JsonDeserializer> deserializers) {
        this.client = client;
        if (config == null) {
            config = new ClientConfiguration.Builder().getConfig();
        }
        this.processorChain = Collections.unmodifiableList(config.getRequestProcessors());
        this.jsonSerializer2 = new JsonMsgSerializer2();
        this.deserializers = deserializers;
        this.executor = config.getExecutor();
        this.tracer = config.getTracer();
    }

    public static Map<String, JsonDeserializer> prepareDeserializers(ClientConfiguration clientConfig) {
        boolean streaming = clientConfig == null ? true : clientConfig.isSteamingEnabled();
        return JsonApiProvider.prepareDeserializers(streaming);
    }

    private static Map<String, JsonDeserializer> prepareDeserializers(boolean enableStreaming) {
        JsonMsgDeserializer2 defaultJson = new JsonMsgDeserializer2();
        HashMap<String, JsonDeserializer> deserializers = new HashMap<String, JsonDeserializer>();
        deserializers.put("application/json", defaultJson);
        deserializers.put("application/vnd.vmware.vapi.framed", defaultJson);
        if (enableStreaming) {
            deserializers.put("application/vnd.vmware.vapi.stream.json", defaultJson);
        }
        return deserializers;
    }

    private void sendRequest(Object jsonRequestObj, Map<String, Object> processorMetaData, ExecutionContext ctx, AbortHandle abortHandle, CorrelatingClient.ResponseCallbackFactory cbFactory, String serviceId, String operationId, TracingSpan tracingSpan) {
        if (Util.checkRequestAborted(abortHandle, cbFactory)) {
            return;
        }
        byte[] jsonRequest = this.jsonSerializer2.serialize(jsonRequestObj);
        for (RequestProcessor proc : this.processorChain) {
            if (Util.checkRequestAborted(abortHandle, cbFactory)) {
                return;
            }
            jsonRequest = proc.process(jsonRequest, processorMetaData, null);
        }
        if (logger.isDebugEnabled() && Constants.shouldLogRawRequestResponse()) {
            try {
                String jsonRequestString = new String(jsonRequest, UTF8_CHARSET);
                logger.debug("JSON request: {}", (Object)jsonRequestString);
            }
            catch (UnsupportedEncodingException ex) {
                logger.debug("Cound not decode JSON request", (Throwable)ex);
            }
        }
        logger.debug("Sending request of size: {}", (Object)jsonRequest.length);
        ByteArrayInputStream requestAsByteIS = new ByteArrayInputStream(jsonRequest);
        ReleasableInputStream releasableRequest = new ReleasableInputStream(requestAsByteIS);
        this.client.send(new CorrelatingClient.SendParams(serviceId, operationId, releasableRequest, jsonRequest.length, ctx, cbFactory, abortHandle, "application/json", this.deserializers.keySet(), tracingSpan));
    }

    private static String generateUUID() {
        return UUID.randomUUID().toString();
    }

    private void checkResponseId(JsonBaseResponse response, String UUID2) {
        String responseId = response.getId();
        if (!responseId.equals(UUID2)) {
            throw new MessageProtocolException("UUID mismatch in getProviderIdentifier");
        }
    }

    private CorrelatingClient.ResponseCallback decorateCallbackWithExceptionTranslation(final CorrelatingClient.ResponseCallback cb) {
        return new CorrelatingClient.ResponseCallback(){

            @Override
            public void received(InputStream response, CorrelatingClient.TransportControl control) {
                try {
                    cb.received(response, control);
                }
                catch (Exception e) {
                    throw JsonMessageProtocolExceptionTranslator.translate(e);
                }
            }

            @Override
            public void failed(RuntimeException error) {
                try {
                    cb.failed(error);
                }
                catch (Exception e) {
                    throw JsonMessageProtocolExceptionTranslator.translate(e);
                }
            }

            @Override
            public void completed() {
                try {
                    cb.completed();
                }
                catch (Exception e) {
                    throw JsonMessageProtocolExceptionTranslator.translate(e);
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invoke(String serviceId, String operationId, DataValue input, ExecutionContext ctx, AsyncHandle<MethodResult> asyncHandle) {
        AbortHandle requestAbortHandle = asyncHandle instanceof AbortHandleProvider ? ((AbortHandleProvider)((Object)asyncHandle)).getAbortHandle() : null;
        String UUID2 = JsonApiProvider.generateUUID();
        AsyncHandle<MethodResult> resultHandle = null;
        boolean isTaskOperation = operationId.endsWith("$task");
        TracingSpan tracingSpan = this.startTracingSpan(ctx, serviceId, operationId, isTaskOperation);
        try (TracingScope tracingScope = tracingSpan.makeCurrent();){
            resultHandle = this.tryDecorateHandleWithExecutor(JsonApiProvider.decorateHandleWithTracing(asyncHandle, isTaskOperation, tracingSpan), this.executor);
            JsonInvokeRequestParams2 jsonInvokeParams = new JsonInvokeRequestParams2(serviceId, operationId, ctx, input);
            JsonApiRequest jsonApiRequest = new JsonApiRequest(UUID2, jsonInvokeParams);
            ResponseCallbackFactoryImpl cb = new ResponseCallbackFactoryImpl(resultHandle, requestAbortHandle, UUID2, tracingSpan);
            HashMap<String, Object> metadata = new HashMap<String, Object>();
            metadata.put("security_context", jsonInvokeParams.getCtx().retrieveSecurityContext());
            this.sendRequest(jsonApiRequest, metadata, ctx, requestAbortHandle, cb, serviceId, operationId, tracingSpan);
        }
        catch (RuntimeException e) {
            if (resultHandle != null) {
                resultHandle.setError(JsonMessageProtocolExceptionTranslator.translate(e));
            }
            try {
                tracingSpan.setStatusError(e);
            }
            finally {
                tracingSpan.end();
            }
        }
    }

    private TracingSpan startTracingSpan(ExecutionContext execCtx, String serviceId, String operationId, boolean isTaskOperation) {
        String opId;
        ExecutionContext.ApplicationData appData;
        TracingSpan tracingSpan = this.tracer.createClientSpan(serviceId + "." + operationId);
        ExecutionContext.ApplicationData applicationData = appData = execCtx != null ? execCtx.retrieveApplicationData() : null;
        if (appData != null && !StringUtils.isBlank(opId = appData.getProperty("opId"))) {
            tracingSpan.setAttribute(TracingAttributeKey.OP_ID, opId);
        }
        if (isTaskOperation) {
            tracingSpan.setAttribute(TracingAttributeKey.TASK, true);
        }
        return tracingSpan;
    }

    private AsyncHandle<MethodResult> tryDecorateHandleWithExecutor(AsyncHandle<MethodResult> ah, Executor executor) {
        if (executor != null && ah != null) {
            logger.trace(String.format("Decorating async handle - %h, with executor.", ah));
            return new ExecutorAsyncHandle<MethodResult>(ah, executor);
        }
        return ah;
    }

    private static AsyncHandle<MethodResult> decorateHandleWithTracing(final AsyncHandle<MethodResult> asyncHandle, final boolean isTaskOperation, final TracingSpan span) {
        return new AsyncHandle<MethodResult>(){

            @Override
            public void updateProgress(DataValue progress) {
                asyncHandle.updateProgress(progress);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setResult(MethodResult result) {
                try {
                    DataValue resultOutput = result.getOutput();
                    if (result.success()) {
                        if (isTaskOperation && resultOutput instanceof StringValue) {
                            span.setAttribute(TracingAttributeKey.TASK_ID, ((StringValue)resultOutput).getValue());
                        }
                        span.setStatusOk();
                    } else {
                        ErrorValue errorValue = result.getError();
                        span.setStatusError(errorValue);
                    }
                }
                finally {
                    span.end();
                }
                asyncHandle.setResult(result);
            }

            @Override
            public void setError(RuntimeException error) {
                try {
                    span.setStatusError(error);
                }
                finally {
                    span.end();
                }
                asyncHandle.setError(error);
            }
        };
    }

    private class ResponseCallbackImpl
    implements CorrelatingClient.ResponseCallback {
        private AsyncHandle<MethodResult> asyncHandle;
        private final AbortHandle abortHandle;
        private final String UUID;
        private final JsonDeserializer deserializer;
        private volatile boolean terminalFrameReceived = false;

        ResponseCallbackImpl(AsyncHandle<MethodResult> asyncHandle, AbortHandle abortHandle, String UUID, JsonDeserializer deserializer, TracingSpan tracingSpan) {
            this.asyncHandle = asyncHandle;
            this.abortHandle = abortHandle;
            this.UUID = UUID;
            this.deserializer = deserializer;
        }

        @Override
        public void failed(RuntimeException error) {
            logger.debug(String.format("Callback - %h, failed.", this));
            this.setError(JsonMessageProtocolExceptionTranslator.translate(error));
        }

        @Override
        public void completed() {
            logger.debug(String.format("Streaming has been completed in callback - %h.", this));
            if (!this.terminalFrameReceived && this.asyncHandle != null) {
                logger.debug(String.format("Terminal frame was not received in callback - %h.", this));
                this.setResult(MethodResult.EMPTY);
            }
        }

        @Override
        public void received(InputStream response, final CorrelatingClient.TransportControl control) {
            if (logger.isDebugEnabled() && Constants.shouldLogRawRequestResponse()) {
                try {
                    byte[] responseBytes = IoUtil.readAll(response);
                    String responseText = new String(responseBytes, JsonApiProvider.UTF8_CHARSET);
                    logger.debug("JSON response: {}", (Object)responseText);
                    response = new ByteArrayInputStream(responseBytes);
                }
                catch (IOException ex) {
                    logger.debug("Could not log JSON response", (Throwable)ex);
                }
            }
            if (Util.checkRequestAborted(this.abortHandle, this)) {
                return;
            }
            if (this.terminalFrameReceived) {
                logger.error(String.format("Terminal frame received in callback - %h, but reading is not terminated.", this));
                this.setError(JsonMessageProtocolExceptionTranslator.translate(new IllegalStateException("The client found a terminal frame, but server keeps transmitting.")));
                return;
            }
            MethodResult result = null;
            DataValue progress = null;
            JsonBaseResponse jsonObj = this.deserializer.responseDeserialize(response, JsonConstants.RequestType.invoke);
            if (jsonObj instanceof JsonProgressResponse) {
                progress = ((JsonProgressResponse)jsonObj).retrieveProgress();
            } else if (jsonObj instanceof JsonApiResponse) {
                result = this.decodeResponse((JsonApiResponse)jsonObj);
                this.terminalFrameReceived = ((JsonApiResponse)jsonObj).isLast();
            } else {
                throw new RuntimeException("Unknown JsonBaseResponse sub-type");
            }
            if (Util.checkRequestAborted(this.abortHandle, this)) {
                return;
            }
            if (!this.terminalFrameReceived) {
                logger.trace(String.format("Suspending I/O for TransportControl - %h.", control));
                control.suspendRead();
            }
            if (result != null && !this.terminalFrameReceived) {
                logger.trace("Next handle consumer added.");
                result.setNext(new Consumer<AsyncHandle<MethodResult>>(){
                    private AtomicBoolean accepted = new AtomicBoolean();

                    @Override
                    public void accept(AsyncHandle<MethodResult> handle) {
                        if (!this.accepted.compareAndSet(false, true)) {
                            logger.debug(String.format("Consumer and handle already utilized.", new Object[0]));
                            return;
                        }
                        logger.trace(String.format("New handle provided - %h.", handle));
                        handle = JsonApiProvider.this.tryDecorateHandleWithExecutor(handle, JsonApiProvider.this.executor);
                        ResponseCallbackImpl.this.updateAsyncHandle(handle);
                        control.resumeRead();
                    }
                });
            }
            if (progress != null) {
                this.updateProgress(progress);
            } else {
                this.setResult(result);
            }
        }

        private synchronized void updateAsyncHandle(AsyncHandle<MethodResult> newHandle) {
            if (this.asyncHandle == null) {
                logger.trace(String.format("Updating async handle with new handle - %h.", newHandle));
                this.asyncHandle = newHandle;
            } else {
                logger.error(String.format("Two handles exist at the same time for a single server response;old handle - %h, new handle - %h.", new Object[0]), this.asyncHandle, newHandle);
                this.asyncHandle.setError(new IllegalStateException("Two handles exist at the same time for a single server response."));
            }
        }

        private synchronized void updateProgress(DataValue progress) {
            if (this.asyncHandle != null) {
                logger.trace(String.format("Update operation progress via handle - %h.", this.asyncHandle));
                this.asyncHandle.updateProgress(progress);
            } else {
                logger.error(String.format("Async handle missing in callback - %h, progress could not be updated.", this));
            }
        }

        private synchronized void setResult(MethodResult result) {
            if (this.asyncHandle != null) {
                logger.trace(String.format("Setting result. The current handle - %h, is cleared.", this.asyncHandle));
                AsyncHandle<MethodResult> temp = this.asyncHandle;
                this.asyncHandle = null;
                temp.setResult(result);
            } else {
                logger.error(String.format("Async handle missing in callback - %h, result will not be received.", this));
            }
        }

        private synchronized void setError(RuntimeException error) {
            if (this.asyncHandle != null) {
                logger.trace(String.format("Setting error via handle - %h.", this.asyncHandle));
                this.asyncHandle.setError(error);
                this.asyncHandle = null;
            } else {
                logger.error(String.format("Async handle missing in callback - %h, error will not be received.", this));
            }
        }

        protected MethodResult decodeResponse(JsonApiResponse jsonResponse) {
            JsonApiProvider.this.checkResponseId(jsonResponse, this.UUID);
            return jsonResponse.getResult();
        }
    }

    private class ResponseCallbackFactoryImpl
    implements CorrelatingClient.ResponseCallbackFactory {
        private final AsyncHandle<MethodResult> asyncHandle;
        private final AbortHandle abortHandle;
        private final String UUID;
        private final TracingSpan tracingSpan;

        public ResponseCallbackFactoryImpl(AsyncHandle<MethodResult> asyncHandle, AbortHandle abortHandle, String UUID, TracingSpan tracingSpan) {
            this.asyncHandle = asyncHandle;
            this.abortHandle = abortHandle;
            this.UUID = UUID;
            this.tracingSpan = tracingSpan;
        }

        @Override
        public CorrelatingClient.ResponseCallback createResponseCallback(CorrelatingClient.ResponseCallbackParams params) {
            JsonDeserializer deserializer = new JsonMsgDeserializer2();
            String contentType = params.getContentType();
            for (String key : JsonApiProvider.this.deserializers.keySet()) {
                if (contentType == null || !contentType.contains(key)) continue;
                deserializer = (JsonDeserializer)JsonApiProvider.this.deserializers.get(key);
            }
            return JsonApiProvider.this.decorateCallbackWithExceptionTranslation(new ResponseCallbackImpl(this.asyncHandle, this.abortHandle, this.UUID, deserializer, this.tracingSpan));
        }

        @Override
        public void failed(RuntimeException error) {
            logger.debug("Abort prior callback creation.");
            this.asyncHandle.setError(JsonMessageProtocolExceptionTranslator.translate(error));
        }
    }
}

