/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.internal.protocol.client.rpc;

import com.vmware.vapi.core.ExecutionContext;
import com.vmware.vapi.internal.core.abort.AbortHandle;
import com.vmware.vapi.internal.tracing.TracingSpan;
import java.io.InputStream;
import java.util.Collection;
import java.util.Objects;

public interface CorrelatingClient {
    public static final TransportControl NO_OP_CONTROL = new TransportControl(){

        @Override
        public void suspendRead() {
        }

        @Override
        public void resumeRead() {
        }

        @Override
        public void cancel() {
        }
    };

    public void send(SendParams var1);

    public void close();

    public static class SendParams {
        private final InputStream request;
        private final int requestLength;
        private ExecutionContext executionContext;
        private AbortHandle abortHandle;
        private final ResponseCallbackFactory cbFactory;
        private final String serviceId;
        private final String operationId;
        private final String contentType;
        private final Collection<String> acceptedTypes;
        private final TracingSpan tracingSpan;

        public SendParams(String serviceId, String operationId, InputStream request, int requestLength, ExecutionContext executionContext, ResponseCallbackFactory cbFactory, AbortHandle abortHandle, String contentType, Collection<String> acceptedTypes, TracingSpan tracingSpan) {
            Objects.requireNonNull(serviceId);
            Objects.requireNonNull(operationId);
            Objects.requireNonNull(request);
            Objects.requireNonNull(executionContext);
            Objects.requireNonNull(cbFactory);
            Objects.requireNonNull(contentType);
            Objects.requireNonNull(acceptedTypes);
            Objects.requireNonNull(tracingSpan);
            if (requestLength < -1) {
                throw new IllegalArgumentException("Invalid request length.");
            }
            this.serviceId = serviceId;
            this.operationId = operationId;
            this.request = request;
            this.requestLength = requestLength;
            this.executionContext = executionContext;
            this.cbFactory = cbFactory;
            this.abortHandle = abortHandle;
            this.contentType = contentType;
            this.acceptedTypes = acceptedTypes;
            this.tracingSpan = tracingSpan;
        }

        public InputStream getRequest() {
            return this.request;
        }

        public int getRequestLength() {
            return this.requestLength;
        }

        public ExecutionContext getExecutionContext() {
            return this.executionContext;
        }

        public void setExecutionContext(ExecutionContext executionContext) {
            this.executionContext = executionContext;
        }

        public AbortHandle getAbortHandle() {
            return this.abortHandle;
        }

        public void setAbortHandle(AbortHandle abortHandle) {
            this.abortHandle = abortHandle;
        }

        public ResponseCallbackFactory getCbFactory() {
            return this.cbFactory;
        }

        public String getServiceId() {
            return this.serviceId;
        }

        public String getOperationId() {
            return this.operationId;
        }

        public String getContentType() {
            return this.contentType;
        }

        public Collection<String> getAcceptedTypes() {
            return this.acceptedTypes;
        }

        public TracingSpan getTracingSpan() {
            return this.tracingSpan;
        }
    }

    public static class ResponseCallbackParams {
        private String contentType;

        public ResponseCallbackParams(String contentType) {
            this.contentType = contentType;
        }

        public String getContentType() {
            return this.contentType;
        }
    }

    public static interface ResponseCallbackFactory {
        public ResponseCallback createResponseCallback(ResponseCallbackParams var1);

        public void failed(RuntimeException var1);
    }

    public static interface ResponseCallback {
        public void failed(RuntimeException var1);

        public void received(InputStream var1, TransportControl var2);

        public void completed();
    }

    public static interface TransportControl {
        public void suspendRead();

        public void resumeRead();

        public void cancel();
    }
}

