/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.internal.provider.introspection;

import com.vmware.vapi.client.exception.MessageProtocolException;
import com.vmware.vapi.core.ApiProvider;
import com.vmware.vapi.core.AsyncHandle;
import com.vmware.vapi.core.AsyncHandleSyncAdapter;
import com.vmware.vapi.core.ErrorValueException;
import com.vmware.vapi.core.ExecutionContext;
import com.vmware.vapi.core.InterfaceDefinition;
import com.vmware.vapi.core.InterfaceIdentifier;
import com.vmware.vapi.core.MethodDefinition;
import com.vmware.vapi.core.MethodIdentifier;
import com.vmware.vapi.core.MethodResult;
import com.vmware.vapi.core.ProviderDefinition;
import com.vmware.vapi.data.DataValue;
import com.vmware.vapi.data.StructValue;
import com.vmware.vapi.internal.provider.introspection.IntrospectionDataFactory;
import com.vmware.vapi.internal.util.Validate;
import com.vmware.vapi.provider.introspection.ApiIntrospectionStub;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ApiIntrospectionStubImpl
implements ApiIntrospectionStub {
    private final ApiProvider provider;
    private static Logger logger = LoggerFactory.getLogger(ApiIntrospectionStubImpl.class);

    public ApiIntrospectionStubImpl(ApiProvider provider) {
        this.provider = provider;
    }

    private static ExecutionContext newCtx() {
        return new ExecutionContext();
    }

    @Override
    public ProviderDefinition getDefinition() {
        return this.getDefinition(ApiIntrospectionStubImpl.newCtx());
    }

    @Override
    public Set<InterfaceIdentifier> getInterfaceIdentifiers() {
        return this.getInterfaceIdentifiers(ApiIntrospectionStubImpl.newCtx());
    }

    @Override
    public InterfaceDefinition getInterface(InterfaceIdentifier ifaceId) {
        return this.getInterface(ApiIntrospectionStubImpl.newCtx(), ifaceId);
    }

    @Override
    public MethodDefinition getMethod(MethodIdentifier methodId) {
        return this.getMethod(ApiIntrospectionStubImpl.newCtx(), methodId);
    }

    @Override
    public ProviderDefinition getDefinition(ExecutionContext ctx) {
        AsyncHandleSyncAdapter<ProviderDefinition> handle = new AsyncHandleSyncAdapter<ProviderDefinition>();
        this.getDefinition(ctx, handle);
        return handle.get();
    }

    @Override
    public Set<InterfaceIdentifier> getInterfaceIdentifiers(ExecutionContext ctx) {
        AsyncHandleSyncAdapter<Set<InterfaceIdentifier>> handle = new AsyncHandleSyncAdapter<Set<InterfaceIdentifier>>();
        this.getInterfaceIdentifiers(ctx, handle);
        return handle.get();
    }

    @Override
    public InterfaceDefinition getInterface(ExecutionContext ctx, InterfaceIdentifier ifaceId) {
        AsyncHandleSyncAdapter<InterfaceDefinition> handle = new AsyncHandleSyncAdapter<InterfaceDefinition>();
        this.getInterface(ctx, ifaceId, handle);
        return handle.get();
    }

    @Override
    public MethodDefinition getMethod(ExecutionContext ctx, MethodIdentifier methodId) {
        AsyncHandleSyncAdapter<MethodDefinition> handle = new AsyncHandleSyncAdapter<MethodDefinition>();
        this.getMethod(ctx, methodId, handle);
        return handle.get();
    }

    @Override
    public void getDefinition(ExecutionContext ctx, AsyncHandle<ProviderDefinition> asyncHandle) {
        Validate.notNull(ctx);
        Validate.notNull(asyncHandle);
        MethodIdentifier method = IntrospectionDataFactory.PROVIDER_GET_METHOD_ID;
        StructValue input = IntrospectionDataFactory.createMethodInput();
        AsyncHandleImpl<ProviderDefinition> cb = new AsyncHandleImpl<ProviderDefinition>(asyncHandle){

            @Override
            protected ProviderDefinition convert(DataValue result) {
                return IntrospectionDataFactory.fromProviderInfo(result);
            }
        };
        this.provider.invoke(method.getInterfaceIdentifier().getName(), method.getName(), input, ctx, cb);
    }

    @Override
    public void getInterfaceIdentifiers(ExecutionContext ctx, AsyncHandle<Set<InterfaceIdentifier>> asyncHandle) {
        Validate.notNull(ctx);
        Validate.notNull(asyncHandle);
        MethodIdentifier method = IntrospectionDataFactory.SERVICE_LIST_METHOD_ID;
        StructValue input = IntrospectionDataFactory.createMethodInput();
        AsyncHandleImpl<Set<InterfaceIdentifier>> cb = new AsyncHandleImpl<Set<InterfaceIdentifier>>(asyncHandle){

            @Override
            protected Set<InterfaceIdentifier> convert(DataValue result) {
                return IntrospectionDataFactory.fromServiceIdList(result);
            }
        };
        this.provider.invoke(method.getInterfaceIdentifier().getName(), method.getName(), input, ctx, cb);
    }

    @Override
    public void getInterface(ExecutionContext ctx, final InterfaceIdentifier ifaceId, AsyncHandle<InterfaceDefinition> asyncHandle) {
        Validate.notNull(ctx);
        Validate.notNull(ifaceId);
        Validate.notNull(asyncHandle);
        MethodIdentifier method = IntrospectionDataFactory.SERVICE_GET_METHOD_ID;
        StructValue input = IntrospectionDataFactory.createMethodInput();
        input.setField("id", ifaceId.getName());
        AsyncHandleImpl<InterfaceDefinition> cb = new AsyncHandleImpl<InterfaceDefinition>(asyncHandle){

            @Override
            protected InterfaceDefinition convert(DataValue result) {
                return IntrospectionDataFactory.fromServiceInfo(result, ifaceId);
            }

            @Override
            public void setResult(MethodResult result) {
                if (!result.success() && "com.vmware.vapi.std.errors.not_found".equals(result.getError().getName())) {
                    this.handle.setResult(null);
                } else {
                    super.setResult(result);
                }
            }
        };
        this.provider.invoke(method.getInterfaceIdentifier().getName(), method.getName(), input, ctx, cb);
    }

    @Override
    public void getMethod(ExecutionContext ctx, final MethodIdentifier methodId, AsyncHandle<MethodDefinition> asyncHandle) {
        Validate.notNull(ctx);
        Validate.notNull(methodId);
        Validate.notNull(asyncHandle);
        MethodIdentifier method = IntrospectionDataFactory.OPERATION_GET_METHOD_ID;
        StructValue input = IntrospectionDataFactory.createMethodInput();
        input.setField("service_id", methodId.getInterfaceIdentifier().getName());
        input.setField("operation_id", methodId.getName());
        AsyncHandleImpl<MethodDefinition> cb = new AsyncHandleImpl<MethodDefinition>(asyncHandle){

            @Override
            protected MethodDefinition convert(DataValue result) {
                return IntrospectionDataFactory.fromOperationInfo(result, methodId);
            }

            @Override
            public void setResult(MethodResult result) {
                if (!result.success() && "com.vmware.vapi.std.errors.not_found".equals(result.getError().getName())) {
                    this.handle.setResult(null);
                } else {
                    super.setResult(result);
                }
            }
        };
        this.provider.invoke(method.getInterfaceIdentifier().getName(), method.getName(), input, ctx, cb);
    }

    private static abstract class AsyncHandleImpl<T>
    extends AsyncHandle<MethodResult> {
        protected final AsyncHandle<T> handle;

        public AsyncHandleImpl(AsyncHandle<T> handle) {
            this.handle = handle;
        }

        protected abstract T convert(DataValue var1);

        @Override
        public void updateProgress(DataValue progress) {
            this.handle.updateProgress(progress);
        }

        @Override
        public void setResult(MethodResult result) {
            if (result.success()) {
                try {
                    this.tryReadHttpTerminalFrame(result);
                    this.handle.setResult(this.convert(result.getOutput()));
                }
                catch (RuntimeException ex) {
                    this.handle.setError(new MessageProtocolException(ex));
                }
            } else {
                this.handle.setError(new ErrorValueException(result.getError()));
            }
        }

        @Override
        public void setError(RuntimeException error) {
            this.handle.setError(error);
        }

        private void tryReadHttpTerminalFrame(MethodResult methodResult) {
            try {
                logger.debug("Attempting to close the TCP connection.");
                if (methodResult != null && methodResult.getNext() != null) {
                    logger.debug("Reading HTTP terminal frame.");
                    methodResult.getNext().accept(null);
                }
            }
            catch (Exception e) {
                logger.warn("Failed to read HTTP terminal frame. Connection not closed.", (Throwable)e);
            }
        }
    }
}

