/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.std.errors;

import com.vmware.vapi.bindings.ApiEnumeration;
import com.vmware.vapi.bindings.ApiError;
import com.vmware.vapi.bindings.StaticStructure;
import com.vmware.vapi.bindings.Structure;
import com.vmware.vapi.bindings.type.DynamicStructType;
import com.vmware.vapi.bindings.type.EnumType;
import com.vmware.vapi.bindings.type.ErrorType;
import com.vmware.vapi.bindings.type.ListType;
import com.vmware.vapi.bindings.type.OptionalType;
import com.vmware.vapi.bindings.type.StructType;
import com.vmware.vapi.bindings.type.TypeReference;
import com.vmware.vapi.client.exception.BindingsException;
import com.vmware.vapi.data.DataValue;
import com.vmware.vapi.data.ErrorValue;
import com.vmware.vapi.data.StructValue;
import com.vmware.vapi.internal.bindings.BindingsUtil;
import com.vmware.vapi.std.LocalizableMessage;
import com.vmware.vapi.std.errors.StructDefinitions;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Error
extends ApiError
implements Serializable,
StaticStructure {
    private static final long serialVersionUID = 1L;
    private List<LocalizableMessage> messages;
    private Structure data;
    private final Type errorType;
    protected StructValue __dynamicStructureFields;

    public Error(List<LocalizableMessage> messages, Structure data) {
        this();
        this.messages = messages;
        this.data = data;
    }

    public Error() {
        this((StructValue)null);
    }

    protected Error(StructValue __dynamicStructureFields) {
        this(__dynamicStructureFields, Type.ERROR);
    }

    protected Error(StructValue __dynamicStructureFields, Type errorType) {
        this.__dynamicStructureFields = __dynamicStructureFields;
        this.setMessages(Collections.emptyList());
        this.errorType = errorType;
    }

    public List<LocalizableMessage> getMessages() {
        return this.messages;
    }

    public void setMessages(List<LocalizableMessage> messages) {
        this.messages = messages;
    }

    public Structure getData() {
        return this.data;
    }

    public void setData(Structure data) {
        this.data = data;
    }

    public Type getErrorType() {
        return this.errorType;
    }

    @Override
    public ErrorType _getType() {
        return StructDefinitions.error;
    }

    @Override
    public StructValue _getDataValue() {
        StructValue dataValue = this.__dynamicStructureFields != null ? this.__dynamicStructureFields.copy() : Error.createEmptyStructValue();
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(StructValue structValue) {
        structValue.setField("messages", BindingsUtil.toDataValue(this.messages, this._getType().getField("messages")));
        structValue.setField("data", BindingsUtil.toDataValue(this.data, this._getType().getField("data")));
        structValue.setField("error_type", BindingsUtil.toDataValue(this.errorType, this._getType().getField("error_type")));
    }

    @Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    public boolean equals(Object obj) {
        return BindingsUtil.areEqual(this, obj);
    }

    public int hashCode() {
        return BindingsUtil.computeHashCode(this);
    }

    @Override
    public String getMessage() {
        return BindingsUtil.convertToString(this, this.__dynamicStructureFields);
    }

    @Override
    public boolean _hasTypeNameOf(Class<? extends Structure> clazz) {
        return BindingsUtil.hasTypeNameOf(this._getDataValue(), clazz);
    }

    @Override
    public <T extends Structure> T _convertTo(Class<T> clazz) {
        return BindingsUtil.convertTo(this, clazz);
    }

    @Override
    public void _setDynamicField(String fieldName, DataValue fieldValue) {
        if (this._getType().getFieldNames().contains(fieldName)) {
            throw new BindingsException("The structure contains static field with name " + fieldName);
        }
        if (this.__dynamicStructureFields == null) {
            this.__dynamicStructureFields = Error.createEmptyStructValue();
        }
        this.__dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @Override
    public DataValue _getDynamicField(String fieldName) {
        if (this.__dynamicStructureFields == null || !this.__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return this.__dynamicStructureFields.getField(fieldName);
    }

    @Override
    public Set<String> _getDynamicFieldNames() {
        if (this.__dynamicStructureFields == null) {
            return Collections.emptySet();
        }
        return this.__dynamicStructureFields.getFieldNames();
    }

    public static ErrorType _getClassType() {
        return StructDefinitions.error;
    }

    @Override
    public String _getCanonicalName() {
        if (this.__dynamicStructureFields != null) {
            return this.__dynamicStructureFields.getName();
        }
        return StructDefinitions.error.getName();
    }

    public static String _getCanonicalTypeName() {
        return Error._getClassType().getName();
    }

    private static StructValue createEmptyStructValue() {
        return new ErrorValue(Error._getCanonicalTypeName());
    }

    public static Error _newInstance(StructValue structValue) {
        return new Error(structValue);
    }

    public static Error _newInstance2(StructValue structValue) {
        return new Error(structValue);
    }

    static ErrorType __initStructType() {
        StructType.FieldNameDetails details = null;
        LinkedHashMap<String, com.vmware.vapi.bindings.type.Type> fields = new LinkedHashMap<String, com.vmware.vapi.bindings.type.Type>();
        HashMap<String, StructType.FieldNameDetails> fieldNameDetails = new HashMap<String, StructType.FieldNameDetails>();
        fields.put("messages", new ListType(new TypeReference<StructType>(){

            @Override
            public StructType resolve() {
                return com.vmware.vapi.std.StructDefinitions.localizableMessage;
            }
        }));
        details = new StructType.FieldNameDetails("messages", "messages", "getMessages", "setMessages");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("data", new OptionalType(new DynamicStructType()));
        details = new StructType.FieldNameDetails("data", "data", "getData", "setData");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("error_type", new OptionalType(new EnumType("com.vmware.vapi.std.errors.error.type", Type.class)));
        details = new StructType.FieldNameDetails("error_type", "errorType", "getErrorType", null);
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new ErrorType("com.vmware.vapi.std.errors.error", fields, Error.class, fieldNameDetails);
    }

    public static final class Builder {
        private List<LocalizableMessage> messages;
        private Structure data;

        public Builder(List<LocalizableMessage> messages) {
            this.messages = messages;
        }

        public Builder setData(Structure data) {
            this.data = data;
            return this;
        }

        public Error build() {
            Error result = new Error();
            result.setMessages(this.messages);
            result.setData(this.data);
            return result;
        }
    }

    public static final class Type
    extends ApiEnumeration<Type> {
        public static final Type ERROR = new Type("ERROR");
        public static final Type ALREADY_EXISTS = new Type("ALREADY_EXISTS");
        public static final Type ALREADY_IN_DESIRED_STATE = new Type("ALREADY_IN_DESIRED_STATE");
        public static final Type CANCELED = new Type("CANCELED");
        public static final Type CONCURRENT_CHANGE = new Type("CONCURRENT_CHANGE");
        public static final Type FEATURE_IN_USE = new Type("FEATURE_IN_USE");
        public static final Type INTERNAL_SERVER_ERROR = new Type("INTERNAL_SERVER_ERROR");
        public static final Type INVALID_ARGUMENT = new Type("INVALID_ARGUMENT");
        public static final Type INVALID_ELEMENT_CONFIGURATION = new Type("INVALID_ELEMENT_CONFIGURATION");
        public static final Type INVALID_ELEMENT_TYPE = new Type("INVALID_ELEMENT_TYPE");
        public static final Type INVALID_REQUEST = new Type("INVALID_REQUEST");
        public static final Type NOT_ALLOWED_IN_CURRENT_STATE = new Type("NOT_ALLOWED_IN_CURRENT_STATE");
        public static final Type NOT_FOUND = new Type("NOT_FOUND");
        public static final Type OPERATION_NOT_FOUND = new Type("OPERATION_NOT_FOUND");
        public static final Type RESOURCE_BUSY = new Type("RESOURCE_BUSY");
        public static final Type RESOURCE_IN_USE = new Type("RESOURCE_IN_USE");
        public static final Type RESOURCE_INACCESSIBLE = new Type("RESOURCE_INACCESSIBLE");
        public static final Type SERVICE_UNAVAILABLE = new Type("SERVICE_UNAVAILABLE");
        public static final Type TIMED_OUT = new Type("TIMED_OUT");
        public static final Type UNABLE_TO_ALLOCATE_RESOURCE = new Type("UNABLE_TO_ALLOCATE_RESOURCE");
        public static final Type UNAUTHENTICATED = new Type("UNAUTHENTICATED");
        public static final Type UNAUTHORIZED = new Type("UNAUTHORIZED");
        public static final Type UNEXPECTED_INPUT = new Type("UNEXPECTED_INPUT");
        public static final Type UNSUPPORTED = new Type("UNSUPPORTED");
        public static final Type UNVERIFIED_PEER = new Type("UNVERIFIED_PEER");
        private static final long serialVersionUID = 1L;
        private static final Type[] $VALUES = new Type[]{ERROR, ALREADY_EXISTS, ALREADY_IN_DESIRED_STATE, CANCELED, CONCURRENT_CHANGE, FEATURE_IN_USE, INTERNAL_SERVER_ERROR, INVALID_ARGUMENT, INVALID_ELEMENT_CONFIGURATION, INVALID_ELEMENT_TYPE, INVALID_REQUEST, NOT_ALLOWED_IN_CURRENT_STATE, NOT_FOUND, OPERATION_NOT_FOUND, RESOURCE_BUSY, RESOURCE_IN_USE, RESOURCE_INACCESSIBLE, SERVICE_UNAVAILABLE, TIMED_OUT, UNABLE_TO_ALLOCATE_RESOURCE, UNAUTHENTICATED, UNAUTHORIZED, UNEXPECTED_INPUT, UNSUPPORTED, UNVERIFIED_PEER};
        private static final Map<String, Type> $NAME_TO_VALUE_MAP = ApiEnumeration.buildNameMap((ApiEnumeration[])$VALUES);

        private Type() {
            super(Values._UNKNOWN.name());
        }

        private Type(String name) {
            super(name);
        }

        public static Type[] values() {
            return (Type[])$VALUES.clone();
        }

        public static Type valueOf(String name) {
            if (name == null) {
                throw new NullPointerException();
            }
            Type predefined = $NAME_TO_VALUE_MAP.get(name);
            if (predefined != null) {
                return predefined;
            }
            return new Type(name);
        }

        public boolean isUnknown() {
            return this.getEnumValue() == Values._UNKNOWN;
        }

        public Values getEnumValue() {
            try {
                return Values.valueOf(this.name());
            }
            catch (IllegalArgumentException ex) {
                return Values._UNKNOWN;
            }
        }

        private Object readResolve() {
            return Type.valueOf(this.name());
        }

        public static enum Values {
            ERROR,
            ALREADY_EXISTS,
            ALREADY_IN_DESIRED_STATE,
            CANCELED,
            CONCURRENT_CHANGE,
            FEATURE_IN_USE,
            INTERNAL_SERVER_ERROR,
            INVALID_ARGUMENT,
            INVALID_ELEMENT_CONFIGURATION,
            INVALID_ELEMENT_TYPE,
            INVALID_REQUEST,
            NOT_ALLOWED_IN_CURRENT_STATE,
            NOT_FOUND,
            OPERATION_NOT_FOUND,
            RESOURCE_BUSY,
            RESOURCE_IN_USE,
            RESOURCE_INACCESSIBLE,
            SERVICE_UNAVAILABLE,
            TIMED_OUT,
            UNABLE_TO_ALLOCATE_RESOURCE,
            UNAUTHENTICATED,
            UNAUTHORIZED,
            UNEXPECTED_INPUT,
            UNSUPPORTED,
            UNVERIFIED_PEER,
            _UNKNOWN;

        }
    }
}

