/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.infrastructure.localization;

import com.vmware.srm.client.infrastructure.authentication.SessionWrapper;
import com.vmware.srm.client.infrastructure.localization.LocalizationUtil;
import com.vmware.srm.client.infrastructure.localization.catalogManager.VcCatalogManager;
import com.vmware.srm.client.reactive.impl.request.RequestContext;
import com.vmware.srm.client.topology.client.Topology;
import com.vmware.srm.client.topology.impl.core.TopologyImpl;
import java.io.IOException;
import java.util.concurrent.Executors;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class CatalogDownloadFilter
implements Filter {
    private static final String CATALOGS_DIR = "catalogs";
    private volatile VcCatalogManager _manager;

    public void init(FilterConfig filterConfig) {
        String catalogsPath = filterConfig.getServletContext().getRealPath("") + CATALOGS_DIR;
        LocalizationUtil.init(catalogsPath);
        this._manager = new VcCatalogManager(catalogsPath);
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)servletRequest;
        try {
            RequestContext.noContext(Executors.callable(() -> this.process(httpRequest.getSession(false))));
        }
        catch (Exception exception) {
            throw new ServletException((Throwable)exception);
        }
        filterChain.doFilter(servletRequest, servletResponse);
    }

    private void process(HttpSession session) {
        TopologyImpl topology;
        if (session == null) {
            return;
        }
        try {
            topology = SessionWrapper.getTopology(session);
        }
        catch (IllegalStateException iae) {
            return;
        }
        if (topology == null) {
            return;
        }
        this._manager.process((Topology)topology);
    }

    public void destroy() {
    }
}

