/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.binding.hms;

import com.vmware.vim.binding.hms.CollectionPage;
import com.vmware.vim.binding.hms.UserSession;
import com.vmware.vim.binding.hms.version.version18;
import com.vmware.vim.binding.hms.version.version7;
import com.vmware.vim.binding.impl.vmodl.DynamicDataImpl;
import com.vmware.vim.binding.vmodl.ManagedObject;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.data;
import com.vmware.vim.binding.vmodl.faults;
import com.vmware.vim.binding.vmodl.fullyQualifiedVmodlName;
import com.vmware.vim.binding.vmodl.internal;
import com.vmware.vim.binding.vmodl.list;
import com.vmware.vim.binding.vmodl.managed;
import com.vmware.vim.binding.vmodl.managedObjectType;
import com.vmware.vim.binding.vmodl.map;
import com.vmware.vim.binding.vmodl.name;
import com.vmware.vim.binding.vmodl.optional;
import com.vmware.vim.binding.vmodl.privilege;
import com.vmware.vim.binding.vmodl.propertyOrder;
import com.vmware.vim.binding.vmodl.readonly;
import com.vmware.vim.binding.vmodl.versionClass;
import com.vmware.vim.binding.vmodl.wsdlName;
import com.vmware.vim.vmomi.core.Future;
import com.vmware.vim.vmomi.core.util.StringUtil;

@fullyQualifiedVmodlName(value="hms.SessionManager")
@managed
@internal
@versionClass(value=version7.class)
@wsdlName(value="HmsSessionManager")
public interface SessionManager
extends ManagedObject {
    @readonly
    @name(value="sessions")
    @privilege(value="HmsSession.com.vmware.vcHms.Session.Terminate")
    @versionClass(value=version7.class)
    @optional
    @map
    public void getSessions(@optional Future<UserSession[]> var1);

    @readonly
    @name(value="currentSession")
    @privilege(value="System.Anonymous")
    @versionClass(value=version7.class)
    @optional
    public void getCurrentSession(@optional Future<UserSession> var1);

    @readonly
    @name(value="supportedLocaleList")
    @privilege(value="System.Anonymous")
    @versionClass(value=version7.class)
    @optional
    @map
    public void getSupportedLocaleList(@optional Future<String[]> var1);

    @readonly
    @name(value="defaultLocale")
    @privilege(value="System.Anonymous")
    @versionClass(value=version7.class)
    public void getDefaultLocale(Future<String> var1);

    @versionClass(value=version7.class)
    @wsdlName(value="HmsSessionManagerGetSessionsInternal")
    @privilege(value="HmsSession.com.vmware.vcHms.Session.Terminate")
    @internal
    @map
    public void getSessionsInternal(@optional @map Future<UserSession[]> var1);

    @versionClass(value=version7.class)
    @wsdlName(value="HmsSessionManagerGetUserSessionPage")
    @privilege(value="HmsSession.com.vmware.vcHms.Session.Terminate")
    @internal
    public void getUserSessionPage(@name(value="start") @versionClass(value=version7.class) int var1, @name(value="count") @versionClass(value=version7.class) int var2, Future<UserSessionPage> var3);

    @versionClass(value=version7.class)
    @wsdlName(value="HmsSessionManagerGetCurrentSessionInternal")
    @privilege(value="System.Anonymous")
    @internal
    public void getCurrentSessionInternal(@optional Future<UserSession> var1);

    @versionClass(value=version7.class)
    @wsdlName(value="HmsSessionManagerLogin")
    @privilege(value="System.Anonymous")
    @internal
    @faults(value={"InvalidLogin", "HmsFaultAlreadyLoggedIn", "HmsFaultCannotVerifyCredentialsFault"})
    public void login(@name(value="peer") @versionClass(value=version7.class) @optional @managedObjectType(value="com.vmware.vim.binding.hms.remote.HmsServer") ManagedObjectReference var1, @name(value="peerToken") @versionClass(value=version7.class) @optional String var2, @name(value="locale") @versionClass(value=version7.class) @optional String var3, Future<UserSession> var4);

    @versionClass(value=version7.class)
    @wsdlName(value="HmsSessionManagerCheckCurrentSessionHealth")
    @privilege(value="System.View")
    @internal
    public void checkCurrentSessionHealth(Future<Void> var1);

    @versionClass(value=version7.class)
    @wsdlName(value="HmsSessionManagerLoginByVcSessionId")
    @privilege(value="System.Anonymous")
    @internal
    @faults(value={"InvalidLogin", "HmsFaultAlreadyLoggedIn", "HmsFaultCannotVerifyCredentialsFault"})
    @Deprecated
    public void loginByVcSessionId(@name(value="vcSessionId") @versionClass(value=version7.class) String var1, @name(value="username") @versionClass(value=version7.class) String var2, @name(value="locale") @versionClass(value=version7.class) @optional String var3, Future<UserSession> var4);

    @versionClass(value=version7.class)
    @wsdlName(value="HmsSessionManagerLoginSite")
    @privilege(value="System.Anonymous")
    @internal
    @faults(value={"InvalidLogin", "HmsFaultAlreadyLoggedIn"})
    public void loginSite(@name(value="locale") @versionClass(value=version7.class) @optional String var1, @name(value="peerUuid") @versionClass(value=version7.class) @optional String var2, Future<UserSession> var3);

    @versionClass(value=version7.class)
    @wsdlName(value="RemoteCheckSession")
    @privilege(value="System.View")
    @internal
    @faults(value={"InvalidLogin"})
    public void remoteCheckSession(@name(value="sessionId") @versionClass(value=version7.class) String var1, @name(value="username") @versionClass(value=version7.class) String var2, Future<Void> var3);

    @versionClass(value=version7.class)
    @wsdlName(value="HmsSessionManagerLoginHmsServer")
    @privilege(value="System.View")
    @internal
    @faults(value={"InvalidLogin", "HmsFaultAlreadyLoggedIn", "HmsFaultCannotVerifyCredentialsFault"})
    @Deprecated
    public void loginHmsServerByVcSessionId(@name(value="site") @versionClass(value=version7.class) @managedObjectType(value="com.vmware.vim.binding.hms.remote.HmsServer") ManagedObjectReference var1, @name(value="userName") @versionClass(value=version7.class) String var2, @name(value="vcSessionId") @versionClass(value=version7.class) String var3, @name(value="locale") @versionClass(value=version7.class) @optional String var4, Future<UserSession> var5);

    @versionClass(value=version7.class)
    @wsdlName(value="HmsSessionManagerLoginHmsServerByToken")
    @privilege(value="System.View")
    @internal
    @faults(value={"InvalidLogin", "HmsFaultAlreadyLoggedIn"})
    public void loginHmsServerByToken(@name(value="site") @versionClass(value=version7.class) @managedObjectType(value="com.vmware.vim.binding.hms.remote.HmsServer") ManagedObjectReference var1, @name(value="delegatedToken") @versionClass(value=version7.class) String var2, @name(value="locale") @versionClass(value=version7.class) @optional String var3, Future<UserSession> var4);

    @versionClass(value=version7.class)
    @wsdlName(value="HmsSessionManagerLogoutHmsServer")
    @privilege(value="System.View")
    @internal
    @Deprecated
    public void logoutHmsServer(@name(value="site") @versionClass(value=version7.class) @managedObjectType(value="com.vmware.vim.binding.hms.remote.HmsServer") ManagedObjectReference var1, Future<Void> var2);

    @versionClass(value=version7.class)
    @wsdlName(value="HmsSessionManagerLoginPeerByToken")
    @privilege(value="System.Anonymous")
    @internal
    @faults(value={"InvalidLogin", "HmsFaultCannotVerifyCredentialsFault"})
    public void remoteLoginPeerByToken(@name(value="delegatedToken") @versionClass(value=version7.class) String var1, @name(value="locale") @versionClass(value=version7.class) @optional String var2, Future<UserSession> var3);

    @versionClass(value=version7.class)
    @wsdlName(value="HmsSessionManagerDebug")
    @privilege(value="System.Anonymous")
    @internal
    @map
    @faults(value={"NotAuthenticated"})
    public void debug(@name(value="strings") @versionClass(value=version7.class) @optional @map String[] var1, @name(value="objects") @versionClass(value=version7.class) @optional @list Object[] var2, @map Future<String[]> var3);

    @versionClass(value=version7.class)
    @wsdlName(value="HmsSessionManagerLogout")
    @privilege(value="System.View")
    @internal
    public void logout(Future<Void> var1);

    @versionClass(value=version7.class)
    @wsdlName(value="HmsSessionManagerTerminate")
    @privilege(value="HmsSession.com.vmware.vcHms.Session.Terminate")
    @internal
    public void terminate(@name(value="sessionId") @versionClass(value=version7.class) @map String[] var1, Future<Void> var2);

    @versionClass(value=version18.class)
    @wsdlName(value="HmsSessionManagerCreatePeerAuthRequest")
    @privilege(value="System.Read")
    @internal
    @faults(value={"ManagedObjectNotFound", "HmsRemoteFaultHmsServerNotRegistered", "HmsRemoteFaultConnectionFault", "NotSupported"})
    public void createPeerAuthRequest(@name(value="peer") @versionClass(value=version18.class) @managedObjectType(value="com.vmware.vim.binding.hms.remote.HmsServer") ManagedObjectReference var1, @name(value="authSpec") @versionClass(value=version18.class) PeerAuthRequestSpec var2, Future<String> var3);

    @versionClass(value=version18.class)
    @wsdlName(value="HmsSessionManagerRemoteSetPeerAuthRequest")
    @privilege(value="HmsRemote.com.vmware.vcHms.Hms.Manage")
    @internal
    @faults(value={"ManagedObjectNotFound"})
    public void remoteSetPeerAuthRequest(@name(value="peer") @versionClass(value=version18.class) @managedObjectType(value="com.vmware.vim.binding.hms.remote.HmsServer") ManagedObjectReference var1, @name(value="authSpec") @versionClass(value=version18.class) @optional PeerAuthRequestSpec var2, @name(value="sessionId") @versionClass(value=version18.class) String var3, Future<String> var4);

    @versionClass(value=version18.class)
    @wsdlName(value="HmsSessionManagerGetAuthRequest")
    @privilege(value="System.Anonymous")
    @internal
    @faults(value={"NotFound", "InvalidLogin", "HmsRemoteFaultConnectionFault"})
    public void getAuthRequest(@name(value="authRequestId") @versionClass(value=version18.class) String var1, Future<PeerAuthRequestSpec> var2);

    @versionClass(value=version7.class)
    @wsdlName(value="HmsSessionManagerSetLocale")
    @privilege(value="System.View")
    @internal
    public void setLocale(@name(value="locale") @versionClass(value=version7.class) String var1, Future<Void> var2);

    @versionClass(value=version7.class)
    @wsdlName(value="HmsSessionManagerGetSupportedLocaleListInternal")
    @privilege(value="System.Anonymous")
    @internal
    @map
    public void getSupportedLocaleListInternal(@optional @map Future<String[]> var1);

    @versionClass(value=version7.class)
    @wsdlName(value="HmsSessionManagerGetDefaultLocaleInternal")
    @privilege(value="System.Anonymous")
    @internal
    public void getDefaultLocaleInternal(Future<String> var1);

    @internal
    @versionClass(value=version18.class)
    @wsdlName(value="HmsSessionManagerPeerAuthRequestSpec")
    @data
    @propertyOrder(value={"authResponseEndpoint", "noPrompt", "username"})
    public static class PeerAuthRequestSpec
    extends DynamicDataImpl {
        private static final long serialVersionUID = 1L;
        public String authResponseEndpoint;
        public Boolean noPrompt;
        public String username;

        public PeerAuthRequestSpec() {
        }

        public PeerAuthRequestSpec(String authResponseEndpoint, Boolean noPrompt, String username) {
            this.authResponseEndpoint = authResponseEndpoint;
            this.noPrompt = noPrompt;
            this.username = username;
        }

        @versionClass(value=version18.class)
        public String getAuthResponseEndpoint() {
            return this.authResponseEndpoint;
        }

        @versionClass(value=version18.class)
        public void setAuthResponseEndpoint(String authResponseEndpoint) {
            this.authResponseEndpoint = authResponseEndpoint;
        }

        @optional
        @versionClass(value=version18.class)
        @Deprecated
        public Boolean isNoPrompt() {
            return this.noPrompt;
        }

        @optional
        @versionClass(value=version18.class)
        public Boolean getNoPrompt() {
            return this.noPrompt;
        }

        @optional
        @versionClass(value=version18.class)
        public void setNoPrompt(Boolean noPrompt) {
            this.noPrompt = noPrompt;
        }

        @optional
        @versionClass(value=version18.class)
        public String getUsername() {
            return this.username;
        }

        @optional
        @versionClass(value=version18.class)
        public void setUsername(String username) {
            this.username = username;
        }

        public String toString() {
            StringBuilder objString = new StringBuilder(200);
            objString.append("(hms.PeerAuthRequestSpec) {\n");
            objString.append("   ");
            objString.append("dynamicType = ");
            objString.append(this.getDynamicType());
            objString.append(",\n");
            objString.append("   ");
            objString.append("dynamicProperty = ");
            if (this.getDynamicProperty() == null) {
                objString.append("null");
            } else {
                objString.append("(vmodl.DynamicProperty) [\n");
                for (int i = 0; i < this.getDynamicProperty().length; ++i) {
                    objString.append("      ");
                    objString.append(StringUtil.indent((String)("" + this.getDynamicProperty()[i]), (boolean)true));
                    if (i < this.getDynamicProperty().length - 1) {
                        objString.append(",");
                    }
                    objString.append("\n");
                }
                objString.append("   ");
                objString.append("]");
            }
            objString.append(",\n");
            objString.append("   ");
            objString.append("authResponseEndpoint = ");
            objString.append(this.getAuthResponseEndpoint());
            objString.append(",\n");
            objString.append("   ");
            objString.append("noPrompt = ");
            objString.append(this.isNoPrompt());
            objString.append(",\n");
            objString.append("   ");
            objString.append("username = ");
            objString.append(this.getUsername());
            objString.append("\n}");
            return objString.toString();
        }
    }

    @internal
    @versionClass(value=version7.class)
    @wsdlName(value="HmsSessionManagerUserSessionPage")
    @data
    @propertyOrder(value={"sessions"})
    public static class UserSessionPage
    extends CollectionPage {
        private static final long serialVersionUID = 1L;
        public UserSession[] sessions;

        public UserSessionPage() {
        }

        public UserSessionPage(int startPosition, int requestedCount, int totalCount, UserSession[] sessions) {
            super(startPosition, requestedCount, totalCount);
            this.sessions = sessions;
        }

        @map
        @optional
        @versionClass(value=version7.class)
        public UserSession[] getSessions() {
            return this.sessions;
        }

        @map
        @optional
        @versionClass(value=version7.class)
        public void setSessions(UserSession[] sessions) {
            this.sessions = sessions;
        }

        @Override
        public String toString() {
            int i;
            StringBuilder objString = new StringBuilder(240);
            objString.append("(hms.UserSessionPage) {\n");
            objString.append("   ");
            objString.append("dynamicType = ");
            objString.append(this.getDynamicType());
            objString.append(",\n");
            objString.append("   ");
            objString.append("dynamicProperty = ");
            if (this.getDynamicProperty() == null) {
                objString.append("null");
            } else {
                objString.append("(vmodl.DynamicProperty) [\n");
                for (i = 0; i < this.getDynamicProperty().length; ++i) {
                    objString.append("      ");
                    objString.append(StringUtil.indent((String)("" + this.getDynamicProperty()[i]), (boolean)true));
                    if (i < this.getDynamicProperty().length - 1) {
                        objString.append(",");
                    }
                    objString.append("\n");
                }
                objString.append("   ");
                objString.append("]");
            }
            objString.append(",\n");
            objString.append("   ");
            objString.append("startPosition = ");
            objString.append(this.getStartPosition());
            objString.append(",\n");
            objString.append("   ");
            objString.append("requestedCount = ");
            objString.append(this.getRequestedCount());
            objString.append(",\n");
            objString.append("   ");
            objString.append("totalCount = ");
            objString.append(this.getTotalCount());
            objString.append(",\n");
            objString.append("   ");
            objString.append("sessions = ");
            if (this.getSessions() == null) {
                objString.append("null");
            } else {
                objString.append("(hms.UserSession) [\n");
                for (i = 0; i < this.getSessions().length; ++i) {
                    objString.append("      ");
                    objString.append(StringUtil.indent((String)("" + this.getSessions()[i]), (boolean)true));
                    if (i < this.getSessions().length - 1) {
                        objString.append(",");
                    }
                    objString.append("\n");
                }
                objString.append("   ");
                objString.append("]");
            }
            objString.append("\n}");
            return objString.toString();
        }
    }
}

