/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.dsig.json;

import com.vmware.vapi.CoreException;
import com.vmware.vapi.Message;
import com.vmware.vapi.MessageFactory;
import com.vmware.vapi.core.ExecutionContext;
import com.vmware.vapi.internal.protocol.common.json.JsonSecurityContextSerializer;
import com.vmware.vapi.internal.util.Validate;
import com.vmware.vapi.protocol.RequestProcessor;
import java.io.UnsupportedEncodingException;
import java.util.Map;

public abstract class SecurityContextProcessor
implements RequestProcessor {
    public static final String SCHEME_ID_KEY = "schemeId";
    private static final Message DECODE_ERROR = MessageFactory.getMessage("vapi.proc.secctx.decoderequest", new String[0]);
    private final JsonSecurityContextSerializer serializer = new JsonSecurityContextSerializer();

    @Override
    public byte[] process(byte[] request, Map<String, Object> metadata, RequestProcessor.Request vapiRequest) {
        Validate.notNull(request);
        Validate.notNull(metadata);
        Object secCtx = metadata.get("security_context");
        if (secCtx == null || !(secCtx instanceof ExecutionContext.SecurityContext)) {
            return request;
        }
        ExecutionContext.SecurityContext context = (ExecutionContext.SecurityContext)secCtx;
        Object schemeId = context.getProperty("authn_scheme_id");
        if (schemeId == null || !(schemeId instanceof String)) {
            return request;
        }
        byte[] result = request;
        if (this.isSchemeSupported((String)schemeId)) {
            try {
                String requestStr = new String(request, "UTF-8");
                Map<String, Object> props = this.getSecurityContextProperties(context);
                result = this.serializer.serializeSecurityContext(props, requestStr).getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new CoreException(DECODE_ERROR);
            }
        }
        return result;
    }

    public abstract boolean isSchemeSupported(String var1);

    public abstract Map<String, Object> getSecurityContextProperties(ExecutionContext.SecurityContext var1);
}

