/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.internal.bindings;

import com.vmware.vapi.MessageFactory;
import com.vmware.vapi.data.ConstraintValidationException;
import com.vmware.vapi.data.DataValue;
import com.vmware.vapi.data.StringValue;
import com.vmware.vapi.data.StructValue;
import com.vmware.vapi.internal.data.ConstraintValidator;
import com.vmware.vapi.internal.util.Validate;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class IsOneOfValidator
implements ConstraintValidator {
    private final String fieldName;
    private final Set<String> allowedValues;

    public IsOneOfValidator(String fieldName, String[] allowedValues) {
        Validate.notNull(fieldName);
        Validate.notEmpty(allowedValues);
        this.fieldName = fieldName;
        this.allowedValues = new HashSet<String>(Arrays.asList(allowedValues));
    }

    @Override
    public void validate(DataValue dataValue) {
        if (!(dataValue instanceof StructValue)) {
            throw new ConstraintValidationException(MessageFactory.getMessage("vapi.data.structure.isoneof.type.input.mismatch", new String[0]));
        }
        StructValue struct = (StructValue)dataValue;
        if (!struct.hasField(this.fieldName)) {
            throw new ConstraintValidationException(MessageFactory.getMessage("vapi.data.structure.isoneof.missing", struct.getName(), this.fieldName));
        }
        DataValue fieldValue = struct.getField(this.fieldName);
        if (!(fieldValue instanceof StringValue)) {
            throw new ConstraintValidationException(MessageFactory.getMessage("vapi.data.structure.isoneof.type.mismatch", this.fieldName));
        }
        if (!this.allowedValues.contains(((StringValue)fieldValue).getValue())) {
            throw new ConstraintValidationException(MessageFactory.getMessage("vapi.data.structure.isoneof.value.invalid", fieldValue.toString(), this.fieldName));
        }
    }
}

