/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.internal.bindings.server.impl;

import com.vmware.vapi.MessageFactory;
import com.vmware.vapi.bindings.server.AsyncContext;
import com.vmware.vapi.bindings.server.InvocationContext;
import com.vmware.vapi.bindings.type.Type;
import com.vmware.vapi.core.AsyncHandle;
import com.vmware.vapi.core.ExecutionContext;
import com.vmware.vapi.core.MethodResult;
import com.vmware.vapi.data.DataValue;
import com.vmware.vapi.data.ErrorValue;
import com.vmware.vapi.data.StructValue;
import com.vmware.vapi.internal.bindings.ApiMethodSkeleton;
import com.vmware.vapi.internal.bindings.ProgressConverter;
import com.vmware.vapi.internal.bindings.TypeConverter;
import com.vmware.vapi.std.Progress;
import com.vmware.vapi.std.StandardDataFactory;
import java.util.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AsyncContextImpl<T>
extends AsyncContext<T> {
    private static final Logger logger = LoggerFactory.getLogger(AsyncContextImpl.class);
    private final InvocationContext invocationContext;
    private final AsyncHandle<MethodResult> asyncHandle;
    private final TypeConverter typeConverter;
    private final Type outputType;
    private final ApiMethodSkeleton method;

    public AsyncContextImpl(TypeConverter typeConverter, Type outputType, InvocationContext invocationContext, AsyncHandle<MethodResult> asyncHandle, ApiMethodSkeleton method) {
        this.typeConverter = typeConverter;
        this.outputType = outputType;
        this.invocationContext = invocationContext;
        this.asyncHandle = asyncHandle;
        this.method = method;
    }

    @Override
    public InvocationContext getInvocationContext() {
        return this.invocationContext;
    }

    @Override
    public void updateProgress(Progress progress) {
        StructValue progressValue = ProgressConverter.toValue(progress);
        this.asyncHandle.updateProgress(progressValue);
    }

    @Override
    public void setResult(T result) {
        DataValue output;
        try {
            ExecutionContext ec = this.invocationContext.getExecutionContext();
            TypeConverter.ConversionContext cc = new TypeConverter.ConversionContext(ec);
            output = this.typeConverter.convertToVapi(result, this.outputType, cc);
        }
        catch (RuntimeException e) {
            this.setError(e);
            return;
        }
        this.asyncHandle.setResult(MethodResult.newResult(output));
    }

    @Override
    public void setError(RuntimeException error) {
        ErrorValue value;
        try {
            if (error != null) {
                ExecutionContext ec = this.invocationContext.getExecutionContext();
                value = this.method.toErrorValue(this.typeConverter, error, ec);
            } else {
                value = this.createDefaultErrorValue(null);
            }
        }
        catch (RuntimeException e) {
            value = this.createDefaultErrorValue(e);
        }
        this.asyncHandle.setResult(MethodResult.newErrorResult(value));
    }

    private ErrorValue createDefaultErrorValue(RuntimeException e) {
        if (e == null) {
            logger.debug("Unknown exception occured", (Throwable)new RuntimeException("For stack trace purpose"));
        } else {
            logger.debug("Unexpected exception occured", (Throwable)e);
        }
        ErrorValue value = StandardDataFactory.createErrorValueForMessages("com.vmware.vapi.std.errors.internal_server_error", Collections.singletonList(MessageFactory.getMessage("vapi.bindings.asynccontext.error.convert", String.valueOf(e.getMessage()))));
        return value;
    }
}

