/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.internal.protocol.client.rpc;

import com.vmware.vapi.internal.protocol.client.rpc.CorrelatingClient;
import com.vmware.vapi.internal.util.Validate;
import java.io.InputStream;
import java.util.concurrent.Executor;

public final class ExecutorResponseCallback
implements CorrelatingClient.ResponseCallback {
    private final CorrelatingClient.ResponseCallback cb;
    private final Executor executor;

    public ExecutorResponseCallback(CorrelatingClient.ResponseCallback cb, Executor executor) {
        Validate.notNull(cb);
        Validate.notNull(executor);
        this.cb = cb;
        this.executor = executor;
    }

    @Override
    public void received(final InputStream response, final CorrelatingClient.TransportControl control) {
        Runnable task = new Runnable(){

            @Override
            public void run() {
                try {
                    ExecutorResponseCallback.this.cb.received(response, control);
                }
                catch (RuntimeException ex) {
                    ExecutorResponseCallback.this.cb.failed(ex);
                }
            }
        };
        this.executor.execute(task);
    }

    @Override
    public void failed(final RuntimeException error) {
        Runnable task = new Runnable(){

            @Override
            public void run() {
                ExecutorResponseCallback.this.cb.failed(error);
            }
        };
        this.executor.execute(task);
    }

    @Override
    public void completed() {
        Runnable task = new Runnable(){

            @Override
            public void run() {
                ExecutorResponseCallback.this.cb.completed();
            }
        };
        this.executor.execute(task);
    }
}

