/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.internal.tracing.otel;

import com.vmware.vapi.internal.tracing.otel.OtelTracingSpan;
import com.vmware.vapi.internal.tracing.otel.TracingAttributeKey;
import com.vmware.vapi.internal.tracing.otel.TracingRequestAdapter;
import com.vmware.vapi.tracing.Tracer;
import com.vmware.vapi.tracing.TracingLevel;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.propagation.TextMapGetter;
import io.opentelemetry.context.propagation.TextMapPropagator;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OtelTracer
implements Tracer {
    private static final String TRACER_NAME = "com.vmware.vapi";
    private static final Logger LOGGER = LoggerFactory.getLogger(OtelTracer.class);
    private static final short USER_AGENT_MAX_LEN = 128;
    private final TracingLevel tracingLevel;
    private final OpenTelemetry otel;
    private final io.opentelemetry.api.trace.Tracer tracer;

    public OtelTracer(OpenTelemetry otel, TracingLevel tracingLevel) {
        this.otel = Objects.requireNonNull(otel);
        this.tracingLevel = Objects.requireNonNull(tracingLevel);
        this.tracer = otel.getTracer(TRACER_NAME);
    }

    @Override
    public OtelTracingSpan attachServerSpan(HttpServletRequest request) {
        TextMapPropagator propagator = this.otel.getPropagators().getTextMapPropagator();
        Context context = propagator.extract(Context.current(), (Object)request, (TextMapGetter)new TracingRequestAdapter());
        Span decorated = this.tracer.spanBuilder("").setParent(context).setSpanKind(SpanKind.SERVER).startSpan();
        OtelTracingSpan span = new OtelTracingSpan(this.otel, decorated, this.tracingLevel);
        span.setAttribute(TracingAttributeKey.COMPONENT, "VAPI");
        String peerAddress = OtelTracer.getPeerAddress(request);
        span.setAttribute(TracingAttributeKey.PEER_ADDRESS, peerAddress);
        span.setAttribute(TracingAttributeKey.IS_INTERNAL, OtelTracer.isInternal(peerAddress));
        String agent = OtelTracer.getUserAgentTrimmed(request);
        if (agent != null) {
            span.setAttribute(TracingAttributeKey.HTTP_USER_AGENT, agent);
        }
        LOGGER.trace("Started new span {}", (Object)decorated);
        return span;
    }

    @Override
    public OtelTracingSpan createClientSpan(String name) {
        Span decorated = this.tracer.spanBuilder("").setSpanKind(SpanKind.CLIENT).startSpan();
        OtelTracingSpan otelSpan = new OtelTracingSpan(this.otel, decorated, this.tracingLevel);
        otelSpan.updateName(name);
        otelSpan.setAttribute(TracingAttributeKey.COMPONENT, "VAPI");
        otelSpan.addEvent("user >> vAPI client", TracingAttributeKey.THREAD_NAME, Thread.currentThread().getName());
        LOGGER.trace("Started new span {}", (Object)decorated);
        return otelSpan;
    }

    static String getUserAgentTrimmed(HttpServletRequest request) {
        String agent = request.getHeader("User-Agent");
        if (agent == null) {
            return null;
        }
        if (agent.length() > 128) {
            return agent.substring(0, 128);
        }
        return agent;
    }

    static String getPeerAddress(HttpServletRequest request) {
        String forwardedFor = request.getHeader("X-Forwarded-For");
        if (forwardedFor == null) {
            return request.getRemoteAddr();
        }
        return forwardedFor;
    }

    static boolean isInternal(String peerAddress) {
        String[] addresses;
        if (peerAddress == null) {
            return false;
        }
        for (String address : addresses = peerAddress.split(",")) {
            if (OtelTracer.isLocalAddress(address)) continue;
            return false;
        }
        return true;
    }

    static boolean isLocalAddress(String ip) {
        return ip.startsWith("127.") || "::1".equals(ip);
    }

    public OpenTelemetry getOpenTelemetry() {
        return this.otel;
    }

    public TracingLevel getTraceLevel() {
        return this.tracingLevel;
    }
}

