/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.std;

import com.vmware.vapi.CoreException;
import com.vmware.vapi.Message;
import com.vmware.vapi.data.DataDefinition;
import com.vmware.vapi.data.DataValue;
import com.vmware.vapi.data.DoubleDefinition;
import com.vmware.vapi.data.DynamicStructDefinition;
import com.vmware.vapi.data.ErrorDefinition;
import com.vmware.vapi.data.ErrorValue;
import com.vmware.vapi.data.IntegerDefinition;
import com.vmware.vapi.data.ListDefinition;
import com.vmware.vapi.data.ListValue;
import com.vmware.vapi.data.OptionalDefinition;
import com.vmware.vapi.data.OptionalValue;
import com.vmware.vapi.data.StringDefinition;
import com.vmware.vapi.data.StringValue;
import com.vmware.vapi.data.StructDefinition;
import com.vmware.vapi.data.StructRefDefinition;
import com.vmware.vapi.data.StructValue;
import com.vmware.vapi.internal.util.Validate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class StandardDataFactory {
    public static final String VALUE_FIELD_NAME = "value";
    public static final String KEY_FIELD_NAME = "key";
    public static final String MAP_ENTRY_TYPE = "map-entry";
    private static final StringDefinition STRING_DEF = StringDefinition.getInstance();
    private static final OptionalDefinition OPT_STRING_DEF = new OptionalDefinition(STRING_DEF);
    private static final OptionalDefinition OPT_LONG_DEF = new OptionalDefinition(IntegerDefinition.getInstance());
    private static final OptionalDefinition OPT_DOUBLE_DEF = new OptionalDefinition(DoubleDefinition.getInstance());
    public static final String ALREADY_EXISTS = "com.vmware.vapi.std.errors.already_exists";
    public static final String INTERNAL_SERVER_ERROR = "com.vmware.vapi.std.errors.internal_server_error";
    public static final String OPERATION_NOT_FOUND = "com.vmware.vapi.std.errors.operation_not_found";
    public static final String INVALID_ARGUMENT = "com.vmware.vapi.std.errors.invalid_argument";
    public static final String NOT_FOUND = "com.vmware.vapi.std.errors.not_found";
    public static final String UNAUTHENTICATED = "com.vmware.vapi.std.errors.unauthenticated";
    public static final String UNEXPECTED_INPUT = "com.vmware.vapi.std.errors.unexpected_input";
    public static final String MESSAGE_STRUCT_NAME = "com.vmware.vapi.std.localizable_message";
    public static final String PARAM_STRUCT_NAME = "com.vmware.vapi.std.localization_param";
    public static final String NESTED_MSG_STRUCT_NAME = "com.vmware.vapi.std.nested_localizable_message";
    public static final String ID_FIELD_NAME = "id";
    public static final String DEFAUL_MSG_FIELD_NAME = "default_message";
    public static final String ARGS_FIELD_NAME = "args";
    public static final String LOCALIZED_FIELD_NAME = "localized";
    public static final String PARAMS_FIELD_NAME = "params";
    public static final String MESSAGES_FIELD_NAME = "messages";
    public static final String DATA_FIELD_NAME = "data";
    public static final String TYPE_FIELD_NAME = "error_type";
    private static StructDefinition locMessageDef;
    public static final Map<String, DataDefinition> STANDARD_ERROR_FIELDS;

    private static DataDefinition mapDef(DataDefinition key, DataDefinition value) {
        HashMap<String, DataDefinition> fields = new HashMap<String, DataDefinition>();
        fields.put(KEY_FIELD_NAME, key);
        fields.put(VALUE_FIELD_NAME, value);
        return new ListDefinition(new StructDefinition(MAP_ENTRY_TYPE, fields));
    }

    private static DataDefinition nestedDef() {
        StructRefDefinition ref = new StructRefDefinition(PARAM_STRUCT_NAME);
        HashMap<String, DataDefinition> fields = new HashMap<String, DataDefinition>();
        fields.put(ID_FIELD_NAME, STRING_DEF);
        fields.put(PARAMS_FIELD_NAME, new OptionalDefinition(StandardDataFactory.mapDef(STRING_DEF, ref)));
        return new StructDefinition(NESTED_MSG_STRUCT_NAME, fields);
    }

    private static DataDefinition paramDef() {
        HashMap<String, DataDefinition> fields = new HashMap<String, DataDefinition>();
        fields.put("s", OPT_STRING_DEF);
        fields.put("dt", OPT_STRING_DEF);
        fields.put("d", OPT_DOUBLE_DEF);
        fields.put("precision", OPT_LONG_DEF);
        fields.put("format", OPT_STRING_DEF);
        fields.put("i", OPT_LONG_DEF);
        fields.put("l", new OptionalDefinition(StandardDataFactory.nestedDef()));
        return new StructDefinition(PARAM_STRUCT_NAME, fields);
    }

    public static StructDefinition getLocalizableMessageDefinition() {
        return locMessageDef;
    }

    public static ErrorDefinition createStandardErrorDefinition(String errorName) {
        return new ErrorDefinition(errorName, STANDARD_ERROR_FIELDS);
    }

    public static ErrorValue createErrorValueForMessages(String errorName, List<Message> messages) {
        return StandardDataFactory.createErrorValueForMessages(StandardDataFactory.createStandardErrorDefinition(errorName), messages);
    }

    public static ErrorValue createErrorValueForMessages(ErrorDefinition errorDef, List<Message> messages) {
        Validate.notNull(errorDef);
        Validate.notNull(messages);
        if (messages.size() < 1) {
            throw new IllegalArgumentException("The messages parameter must contain at least 1 message");
        }
        try {
            if (messages.contains(null)) {
                throw new IllegalArgumentException("null message detected");
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        ListValue msgListValue = new ListValue();
        for (Message m : messages) {
            msgListValue.add(StandardDataFactory.convertMessageToDataValue(m));
        }
        String discriminator = StandardDataFactory.extractDiscriminator(errorDef.getName());
        ErrorValue result = errorDef.newInstance();
        result.setField(MESSAGES_FIELD_NAME, msgListValue);
        result.setField(DATA_FIELD_NAME, OptionalValue.UNSET);
        result.setField(TYPE_FIELD_NAME, new OptionalValue(discriminator));
        return result;
    }

    static String extractDiscriminator(String name) {
        String discriminator = name;
        int lastDotIndex = discriminator.lastIndexOf(46);
        if (lastDotIndex > -1) {
            discriminator = discriminator.substring(lastDotIndex + 1);
        }
        return discriminator.toUpperCase(Locale.ENGLISH);
    }

    private static StructValue convertMessageToDataValue(Message msg) {
        StructDefinition resultDef = StandardDataFactory.getLocalizableMessageDefinition();
        StructValue result = resultDef.newInstance();
        result.setField(ID_FIELD_NAME, msg.getId());
        result.setField(DEFAUL_MSG_FIELD_NAME, msg.getDefaultMessage());
        result.setField(ARGS_FIELD_NAME, StandardDataFactory.convertArgsToDataValue(msg.getArgs()));
        result.setField(LOCALIZED_FIELD_NAME, OptionalValue.UNSET);
        result.setField(PARAMS_FIELD_NAME, OptionalValue.UNSET);
        return result;
    }

    private static DataValue convertArgsToDataValue(String[] args) {
        ListValue result = new ListValue();
        if (args != null) {
            for (String argument : args) {
                result.add(new StringValue(argument));
            }
        }
        return result;
    }

    public static List<Message> getMessagesFromErrorValue(StructValue error) {
        try {
            ListValue messageList = error.getList(MESSAGES_FIELD_NAME);
            ArrayList<Message> result = new ArrayList<Message>();
            for (DataValue messageStruct : messageList) {
                result.add(StandardDataFactory.buildLegacyMessage((StructValue)messageStruct));
            }
            return result;
        }
        catch (CoreException ex) {
            return Collections.emptyList();
        }
    }

    private static Message buildLegacyMessage(StructValue messageStruct) {
        String id = messageStruct.getString(ID_FIELD_NAME);
        String defaultMessage = messageStruct.getString(DEFAUL_MSG_FIELD_NAME);
        ListValue argsList = messageStruct.getList(ARGS_FIELD_NAME);
        List<String> stringArgsList = argsList.getStringList();
        return new Message(id, defaultMessage, stringArgsList.toArray(new String[stringArgsList.size()]));
    }

    static {
        HashMap<String, DataDefinition> msgFields = new HashMap<String, DataDefinition>();
        msgFields.put(ID_FIELD_NAME, STRING_DEF);
        msgFields.put(DEFAUL_MSG_FIELD_NAME, STRING_DEF);
        msgFields.put(ARGS_FIELD_NAME, new ListDefinition(STRING_DEF));
        msgFields.put(LOCALIZED_FIELD_NAME, OPT_STRING_DEF);
        msgFields.put(PARAMS_FIELD_NAME, new OptionalDefinition(StandardDataFactory.mapDef(STRING_DEF, StandardDataFactory.paramDef())));
        locMessageDef = new StructDefinition(MESSAGE_STRUCT_NAME, msgFields);
        STANDARD_ERROR_FIELDS = new HashMap<String, DataDefinition>();
        STANDARD_ERROR_FIELDS.put(MESSAGES_FIELD_NAME, new ListDefinition(locMessageDef));
        STANDARD_ERROR_FIELDS.put(DATA_FIELD_NAME, new OptionalDefinition(DynamicStructDefinition.getInstance()));
        STANDARD_ERROR_FIELDS.put(TYPE_FIELD_NAME, OPT_STRING_DEF);
    }
}

