/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.impex.utils;

import com.vmware.dr.ui.tools.reactive.Promise;
import com.vmware.dr.ui.tools.reactive.impl.Promises;
import com.vmware.srm.client.reactive.impl.FuturePromise;
import com.vmware.srm.client.topology.client.vmomi.availability.srm.SrmService;
import com.vmware.srm.client.topology.client.vmomi.pbm.SpbmService;
import com.vmware.vim.binding.dr.IpSubnetMapper;
import com.vmware.vim.binding.dr.ServiceInstanceContent;
import com.vmware.vim.binding.dr.recovery.RecoveryManager;
import com.vmware.vim.binding.pbm.profile.CapabilityBasedProfile;
import com.vmware.vim.binding.pbm.profile.Profile;
import com.vmware.vim.binding.pbm.profile.ProfileManager;
import com.vmware.vim.binding.pbm.profile.ResourceType;
import com.vmware.vim.binding.pbm.profile.ResourceTypeEnum;
import com.vmware.vim.vmomi.core.Future;
import java.util.Arrays;

public class MappingUtil {
    public static Promise<IpSubnetMapper> getIpSubnetMapper(SrmService service, ServiceInstanceContent localContent) {
        RecoveryManager recoveryManager = (RecoveryManager)service.createStub(localContent.getRecoveryManager());
        FuturePromise mapperFP = new FuturePromise();
        recoveryManager.getIpSubnetMapper((Future)mapperFP);
        return mapperFP.thenApply(arg_0 -> ((SrmService)service).createStub(arg_0));
    }

    public static String getProfileId(Profile[] profiles, String name) {
        if (profiles == null || name == null) {
            return null;
        }
        return Arrays.stream(profiles).filter(profile -> profile.getName().equals(name)).findFirst().map(profile -> profile.getProfileId().getUniqueId()).orElse(null);
    }

    public static Promise<Profile[]> getProfiles(SpbmService spbmService) {
        if (spbmService == null) {
            return Promises.resolve(null);
        }
        return MappingUtil.getProfileManager(spbmService).thenCompose(profileManager -> {
            ResourceType resource = new ResourceType(ResourceTypeEnum.STORAGE.name());
            String category = CapabilityBasedProfile.ProfileCategoryEnum.REQUIREMENT.name();
            FuturePromise profileIdsPromise = new FuturePromise();
            profileManager.queryProfile(resource, category, (Future)profileIdsPromise);
            return profileIdsPromise.thenCompose(profileIds -> {
                FuturePromise profilesPromise = new FuturePromise();
                profileManager.retrieveContent(profileIds, (Future)profilesPromise);
                return profilesPromise;
            });
        });
    }

    private static Promise<ProfileManager> getProfileManager(SpbmService spbmService) {
        return spbmService.getContent().thenApply(content -> (ProfileManager)spbmService.createStub(content.getProfileManager()));
    }
}

