#!/bin/sh -e
# This script generates client stubs (proxy code) from the DrConfig WSDL and then
# compiles the client sample applications.
#
# To compile the client applications without re-generating the client stubs,
# pass the -w as an argument to the script.  For example:
# ./build.sh -w
#
# Note that this batchfile requires you to set two environment
# variables:
#   AXIS2_HOME
#   JAVAHOME
#
# See the Developer's Setup Guide for more information about AXIS2_HOME and
# JAVAHOME.  Alternatively, you can modify the settings of these two variables
# in the batchfile.  Be careful if you do so.
#

SAMPLEDIR=.
SAMPLEJARDIR=.

if [ "${AXIS2_HOME}" == "" ] ; then
    echo "AXIS2_HOME not defined.  Must be defined to run java apps.">&2
    exit 2
fi

if [ "${JAVAHOME}" == "" ] ; then
    echo "JAVAHOME not defined.  Must be defined to run java apps.">&2
    exit 2
fi

if [ "x$1" != "x-w" ] ; then
    WSDLFILECONFIG="../../../../wsdl/drconfig/drconfig-service.wsdl"
fi

PATH="${JAVAHOME}/bin:${AXIS2_HOME}/bin:${PATH}"
export PATH

# update classpath
LOCALCLASSPATH="${PWD}"
for f in "$AXIS2_HOME"/lib/*.jar
do
  LOCALCLASSPATH="${LOCALCLASSPATH}":$f
done
LOCALCLASSPATH="${LOCALCLASSPATH}:${CLASSPATH}"

./clean.sh $1

cd ${SAMPLEDIR}

if [ "x$1" != "x-w" ] ; then
    echo "Generating stubs from WSDL"
    java -Xms512M -Xmx1024M -Xss512k -classpath "${LOCALCLASSPATH}" org.apache.axis2.wsdl.WSDL2Java -d adb -p com.vmware.drconfig -ns2p urn:drConfig0=com.vmware.drconfig,urn:vim25=com.vmware.vim25 -u -or -o ./ -S ./ -uri ${WSDLFILECONFIG}

    echo "Compiling stubs."
    javac -J-Xms512M -J-Xmx512M -classpath "${LOCALCLASSPATH}" com/vmware/drconfig/*.java

    javac -J-Xms512M -J-Xmx512M -classpath "${LOCALCLASSPATH}" com/vmware/vim25/*.java

    jar cf "${SAMPLEJARDIR}/vim25.jar" com/vmware/vim25/*.class

    jar cf "${SAMPLEJARDIR}/drconfig.jar" com/vmware/drconfig/*.class
    echo "Done compiling stubs."

fi

echo "Compiling sample utilities"
javac -classpath "${LOCALCLASSPATH}" com/vmware/samples/connection/*.java
jar cf "${SAMPLEJARDIR}/apputils.jar" com/vmware/samples/connection/*.class

echo "Done compiling apputil"

echo "Compiling samples"
javac -classpath "${LOCALCLASSPATH}" com/vmware/samples/drconfig/*.java
jar cf "${SAMPLEJARDIR}/samples.jar" com/vmware/samples/drconfig/*.class

echo "Done."
