/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.binding.dr;

import com.vmware.vim.binding.dr.UserSession;
import com.vmware.vim.binding.dr.version.version0;
import com.vmware.vim.binding.dr.version.version18;
import com.vmware.vim.binding.impl.vmodl.DynamicDataImpl;
import com.vmware.vim.binding.vmodl.ManagedObject;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.data;
import com.vmware.vim.binding.vmodl.faults;
import com.vmware.vim.binding.vmodl.fullyQualifiedVmodlName;
import com.vmware.vim.binding.vmodl.internal;
import com.vmware.vim.binding.vmodl.managed;
import com.vmware.vim.binding.vmodl.managedObjectType;
import com.vmware.vim.binding.vmodl.map;
import com.vmware.vim.binding.vmodl.name;
import com.vmware.vim.binding.vmodl.optional;
import com.vmware.vim.binding.vmodl.privilege;
import com.vmware.vim.binding.vmodl.propertyOrder;
import com.vmware.vim.binding.vmodl.readonly;
import com.vmware.vim.binding.vmodl.versionClass;
import com.vmware.vim.binding.vmodl.wsdlName;
import com.vmware.vim.vmomi.core.Future;
import com.vmware.vim.vmomi.core.util.StringUtil;

@fullyQualifiedVmodlName(value="dr.SessionManager")
@managed
@versionClass(value=version0.class)
@wsdlName(value="DrSessionManager")
public interface SessionManager
extends ManagedObject {
    @readonly
    @name(value="sessionList")
    @privilege(value="Sessions.TerminateSession")
    @versionClass(value=version0.class)
    @optional
    @map
    public void getSessionList(@optional Future<UserSession[]> var1);

    @readonly
    @name(value="currentSession")
    @privilege(value="System.Anonymous")
    @versionClass(value=version0.class)
    @optional
    public void getCurrentSession(@optional Future<UserSession> var1);

    @readonly
    @name(value="supportedLocaleList")
    @privilege(value="System.Anonymous")
    @versionClass(value=version0.class)
    @optional
    @map
    public void getSupportedLocaleList(@optional Future<String[]> var1);

    @readonly
    @name(value="defaultLocale")
    @privilege(value="System.Anonymous")
    @versionClass(value=version0.class)
    public void getDefaultLocale(Future<String> var1);

    @versionClass(value=version18.class)
    @wsdlName(value="FindUserSession")
    @privilege(value="Sessions.TerminateSession")
    public void findUserSession(@name(value="id") @versionClass(value=version18.class) String var1, @optional Future<UserSession> var2);

    @versionClass(value=version0.class)
    @wsdlName(value="DrLoginByToken")
    @privilege(value="System.Anonymous")
    @faults(value={"InvalidLogin", "InvalidLocale", "DrFaultCancelled", "NoPermission", "DrFaultAlreadyLoggedInFault", "DrFaultCertificateVerificationError", "DrFaultSessionLimitExceeded"})
    public void loginByToken(@name(value="locale") @versionClass(value=version0.class) @optional String var1, Future<UserSession> var2);

    @versionClass(value=version0.class)
    @wsdlName(value="LoginRemoteSiteByToken")
    @privilege(value="System.Read")
    @faults(value={"InvalidLogin", "DrFaultCancelled", "NotAuthenticated", "DrFaultRemoteSiteNotFound", "DrFaultAlreadyLoggedInFault", "DrFaultSiteNotEnabled", "DrFaultCertificateVerificationError", "DrFaultSessionLimitExceeded", "DrFaultLoginDrInVcFailed", "DrFaultLoginDrInDrFailed"})
    public void loginRemoteSiteByToken(@name(value="site") @versionClass(value=version0.class) @managedObjectType(value="com.vmware.vim.binding.dr.site.RemoteSite") @privilege(value="System.Read") ManagedObjectReference var1, @name(value="locale") @versionClass(value=version0.class) @optional String var2, Future<Void> var3);

    @versionClass(value=version0.class)
    @wsdlName(value="LogoutRemoteSite")
    @privilege(value="System.Anonymous")
    @faults(value={"NotAuthenticated", "DrFaultSiteNotEnabled", "DrFaultRemoteSiteNotAuthenticated", "DrFaultRemoteSiteNotFound"})
    public void logoutRemoteSite(@name(value="site") @versionClass(value=version0.class) @managedObjectType(value="com.vmware.vim.binding.dr.site.RemoteSite") @privilege(value="System.View") ManagedObjectReference var1, Future<Void> var2);

    @versionClass(value=version0.class)
    @wsdlName(value="DrLogout")
    @privilege(value="System.View")
    @faults(value={"NotAuthenticated"})
    public void logout(Future<Void> var1);

    @versionClass(value=version18.class)
    @wsdlName(value="CreatePeerAuthRequest")
    @privilege(value="System.Read")
    @faults(value={"NotAuthenticated", "DrFaultSiteNotEnabled", "DrFaultRemoteSiteNotFound", "NotSupported"})
    public void createPeerAuthRequest(@name(value="peer") @versionClass(value=version18.class) @managedObjectType(value="com.vmware.vim.binding.dr.site.RemoteSite") ManagedObjectReference var1, @name(value="authSpec") @versionClass(value=version18.class) PeerAuthRequestSpec var2, Future<String> var3);

    @versionClass(value=version18.class)
    @wsdlName(value="RemoteSetPeerAuthRequest")
    @privilege(value="VcDr.Internal.com.vmware.vcDr.InternalAccess")
    @internal
    @faults(value={"NotAuthenticated", "DrFaultRemoteSiteNotFound"})
    public void remoteSetPeerAuthRequest(@name(value="peer") @versionClass(value=version18.class) @managedObjectType(value="com.vmware.vim.binding.dr.site.RemoteSite") ManagedObjectReference var1, @name(value="authSpec") @versionClass(value=version18.class) PeerAuthRequestSpec var2, @name(value="sessionId") @versionClass(value=version18.class) String var3, Future<String> var4);

    @versionClass(value=version18.class)
    @wsdlName(value="GetAuthRequest")
    @privilege(value="System.Anonymous")
    @faults(value={"InvalidLogin", "DrFaultNotFound"})
    public void getAuthRequest(@name(value="authRequestId") @versionClass(value=version18.class) String var1, Future<PeerAuthRequestSpec> var2);

    @versionClass(value=version0.class)
    @wsdlName(value="Terminate")
    @privilege(value="Sessions.TerminateSession")
    @faults(value={"NotFound"})
    public void terminate(@name(value="sessionId") @versionClass(value=version0.class) @optional @map String[] var1, Future<Void> var2);

    @versionClass(value=version0.class)
    @wsdlName(value="SetDrLocale")
    @privilege(value="System.View")
    @faults(value={"InvalidLocale"})
    public void setLocale(@name(value="locale") @versionClass(value=version0.class) String var1, Future<Void> var2);

    @versionClass(value=version18.class)
    @wsdlName(value="DrSessionManagerPeerAuthRequestSpec")
    @data
    @propertyOrder(value={"authResponseEndpoint", "noPrompt", "username"})
    public static class PeerAuthRequestSpec
    extends DynamicDataImpl {
        private static final long serialVersionUID = 1L;
        public String authResponseEndpoint;
        public Boolean noPrompt;
        public String username;

        public PeerAuthRequestSpec() {
        }

        public PeerAuthRequestSpec(String authResponseEndpoint, Boolean noPrompt, String username) {
            this.authResponseEndpoint = authResponseEndpoint;
            this.noPrompt = noPrompt;
            this.username = username;
        }

        @versionClass(value=version18.class)
        public String getAuthResponseEndpoint() {
            return this.authResponseEndpoint;
        }

        @versionClass(value=version18.class)
        public void setAuthResponseEndpoint(String authResponseEndpoint) {
            this.authResponseEndpoint = authResponseEndpoint;
        }

        @optional
        @versionClass(value=version18.class)
        @Deprecated
        public Boolean isNoPrompt() {
            return this.noPrompt;
        }

        @optional
        @versionClass(value=version18.class)
        public Boolean getNoPrompt() {
            return this.noPrompt;
        }

        @optional
        @versionClass(value=version18.class)
        public void setNoPrompt(Boolean noPrompt) {
            this.noPrompt = noPrompt;
        }

        @optional
        @versionClass(value=version18.class)
        public String getUsername() {
            return this.username;
        }

        @optional
        @versionClass(value=version18.class)
        public void setUsername(String username) {
            this.username = username;
        }

        public String toString() {
            StringBuilder objString = new StringBuilder(200);
            objString.append("(dr.PeerAuthRequestSpec) {\n");
            objString.append("   ");
            objString.append("dynamicType = ");
            objString.append(this.getDynamicType());
            objString.append(",\n");
            objString.append("   ");
            objString.append("dynamicProperty = ");
            if (this.getDynamicProperty() == null) {
                objString.append("null");
            } else {
                objString.append("(vmodl.DynamicProperty) [\n");
                for (int i = 0; i < this.getDynamicProperty().length; ++i) {
                    objString.append("      ");
                    objString.append(StringUtil.indent((String)String.valueOf(this.getDynamicProperty()[i]), (boolean)true));
                    if (i < this.getDynamicProperty().length - 1) {
                        objString.append(",");
                    }
                    objString.append("\n");
                }
                objString.append("   ");
                objString.append("]");
            }
            objString.append(",\n");
            objString.append("   ");
            objString.append("authResponseEndpoint = ");
            objString.append(this.getAuthResponseEndpoint());
            objString.append(",\n");
            objString.append("   ");
            objString.append("noPrompt = ");
            objString.append(this.isNoPrompt());
            objString.append(",\n");
            objString.append("   ");
            objString.append("username = ");
            objString.append(this.getUsername());
            objString.append("\n}");
            return objString.toString();
        }
    }
}

