/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.binding.dr.storage;

import com.vmware.vim.binding.dr.ManagedEntity;
import com.vmware.vim.binding.dr.storage.AdapterConnectionSpec;
import com.vmware.vim.binding.dr.storage.ArrayInfo;
import com.vmware.vim.binding.dr.version.version0;
import com.vmware.vim.binding.impl.vmodl.DynamicDataImpl;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.data;
import com.vmware.vim.binding.vmodl.faults;
import com.vmware.vim.binding.vmodl.fullyQualifiedVmodlName;
import com.vmware.vim.binding.vmodl.managed;
import com.vmware.vim.binding.vmodl.managedObjectType;
import com.vmware.vim.binding.vmodl.map;
import com.vmware.vim.binding.vmodl.name;
import com.vmware.vim.binding.vmodl.optional;
import com.vmware.vim.binding.vmodl.privilege;
import com.vmware.vim.binding.vmodl.propertyOrder;
import com.vmware.vim.binding.vmodl.readonly;
import com.vmware.vim.binding.vmodl.task;
import com.vmware.vim.binding.vmodl.versionClass;
import com.vmware.vim.binding.vmodl.wsdlName;
import com.vmware.vim.vmomi.core.Future;
import com.vmware.vim.vmomi.core.util.StringUtil;
import java.util.Calendar;

@fullyQualifiedVmodlName(value="dr.storage.ArrayManager")
@managed
@versionClass(value=version0.class)
@wsdlName(value="DrStorageArrayManager")
public interface ArrayManager
extends ManagedEntity {
    @readonly
    @name(value="name")
    @versionClass(value=version0.class)
    public void getName(Future<String> var1);

    @readonly
    @name(value="adapter")
    @versionClass(value=version0.class)
    @optional
    @managedObjectType(value="com.vmware.vim.binding.dr.storage.StorageAdapter")
    public void getAdapter(@optional @managedObjectType(value="com.vmware.vim.binding.dr.storage.StorageAdapter") Future<ManagedObjectReference> var1);

    @readonly
    @name(value="connectionSpec")
    @versionClass(value=version0.class)
    @optional
    @map
    public void getConnectionSpec(@optional Future<AdapterConnectionSpec[]> var1);

    @readonly
    @name(value="arrayInfo")
    @versionClass(value=version0.class)
    @optional
    @map
    public void getArrayInfo(@optional Future<ArrayInfo[]> var1);

    @readonly
    @name(value="arrayPair")
    @versionClass(value=version0.class)
    @optional
    @managedObjectType(value="com.vmware.vim.binding.dr.storage.ReplicatedArrayPair")
    @map
    public void getArrayPair(@optional @managedObjectType(value="com.vmware.vim.binding.dr.storage.ReplicatedArrayPair") Future<ManagedObjectReference[]> var1);

    @readonly
    @name(value="taskInProgress")
    @versionClass(value=version0.class)
    @optional
    @managedObjectType(value="com.vmware.vim.binding.vim.Task")
    @map
    public void getTaskInProgress(@optional @managedObjectType(value="com.vmware.vim.binding.vim.Task") Future<ManagedObjectReference[]> var1);

    @readonly
    @name(value="arrayDiscoveryStatus")
    @versionClass(value=version0.class)
    @optional
    public void getArrayDiscoveryStatus(@optional Future<ArrayDiscoveryStatus> var1);

    @versionClass(value=version0.class)
    @wsdlName(value="ArrayManagerReconfigure_Task")
    @privilege(value="VcDr.Storage.com.vmware.vcDr.Configure")
    @task
    @faults(value={"DrFaultDuplicateName", "DrFaultStringArgumentTooLong", "DrStorageFaultInvalidAdapterConnectionSpec", "DrStorageFaultCommandFailed", "DrStorageFaultStorageAdapterNotFound", "DrStorageFaultDuplicateArray", "DrStorageFaultArrayPairNotFound", "TaskInProgress"})
    public void reconfigure(@name(value="name") @versionClass(value=version0.class) String var1, @name(value="connectionSpec") @versionClass(value=version0.class) @optional @map AdapterConnectionSpec[] var2, @managedObjectType(value="com.vmware.vim.binding.vim.Task") Future<ManagedObjectReference> var3);

    @versionClass(value=version0.class)
    @wsdlName(value="DiscoverArrays_Task")
    @privilege(value="VcDr.Storage.com.vmware.vcDr.Configure")
    @task
    @map
    @faults(value={"DrStorageFaultCommandFailed", "DrStorageFaultStorageAdapterNotFound", "DrStorageFaultDuplicateArray", "DrStorageFaultArrayPairNotFound", "TaskInProgress"})
    public void discoverArrays(@managedObjectType(value="com.vmware.vim.binding.vim.Task") Future<ManagedObjectReference> var1);

    @versionClass(value=version0.class)
    @wsdlName(value="AddArrayPair_Task")
    @privilege(value="VcDr.Storage.com.vmware.vcDr.Configure")
    @task
    @faults(value={"DrStorageFaultArrayNotFound", "DrStorageFaultPeerArrayNotFound", "DrStorageFaultReplicatedArrayPairAlreadyExists", "DrFaultConnectionDownFault", "DrFaultRemoteSiteNotFound", "TaskInProgress"})
    public void addArrayPair(@name(value="arrayId") @versionClass(value=version0.class) String var1, @name(value="remoteSite") @versionClass(value=version0.class) @managedObjectType(value="com.vmware.vim.binding.dr.site.RemoteSite") ManagedObjectReference var2, @name(value="peerArrayId") @versionClass(value=version0.class) String var3, @managedObjectType(value="com.vmware.vim.binding.vim.Task") Future<ManagedObjectReference> var4);

    @versionClass(value=version0.class)
    @wsdlName(value="RemoveArrayPair_Task")
    @privilege(value="VcDr.Storage.com.vmware.vcDr.Configure")
    @task
    @faults(value={"DrStorageFaultArrayPairInUse", "DrFaultConnectionDownFault", "TaskInProgress"})
    public void removeArrayPair(@name(value="array") @versionClass(value=version0.class) @managedObjectType(value="com.vmware.vim.binding.dr.storage.ReplicatedArrayPair") ManagedObjectReference var1, @managedObjectType(value="com.vmware.vim.binding.vim.Task") Future<ManagedObjectReference> var2);

    @versionClass(value=version0.class)
    @wsdlName(value="DrStorageArrayManagerArrayDiscoveryStatus")
    @data
    @propertyOrder(value={"fault", "startTimestamp", "completeTimestamp"})
    public static class ArrayDiscoveryStatus
    extends DynamicDataImpl {
        private static final long serialVersionUID = 1L;
        public Exception fault;
        public Calendar startTimestamp;
        public Calendar completeTimestamp;

        public ArrayDiscoveryStatus() {
        }

        public ArrayDiscoveryStatus(Exception fault, Calendar startTimestamp, Calendar completeTimestamp) {
            this.fault = fault;
            this.startTimestamp = startTimestamp;
            this.completeTimestamp = completeTimestamp;
        }

        @optional
        @versionClass(value=version0.class)
        public Exception getFault() {
            return this.fault;
        }

        @optional
        @versionClass(value=version0.class)
        public void setFault(Exception fault) {
            this.fault = fault;
        }

        @versionClass(value=version0.class)
        public Calendar getStartTimestamp() {
            return this.startTimestamp;
        }

        @versionClass(value=version0.class)
        public void setStartTimestamp(Calendar startTimestamp) {
            this.startTimestamp = startTimestamp;
        }

        @optional
        @versionClass(value=version0.class)
        public Calendar getCompleteTimestamp() {
            return this.completeTimestamp;
        }

        @optional
        @versionClass(value=version0.class)
        public void setCompleteTimestamp(Calendar completeTimestamp) {
            this.completeTimestamp = completeTimestamp;
        }

        public String toString() {
            StringBuilder objString = new StringBuilder(200);
            objString.append("(dr.storage.ArrayDiscoveryStatus) {\n");
            objString.append("   ");
            objString.append("dynamicType = ");
            objString.append(this.getDynamicType());
            objString.append(",\n");
            objString.append("   ");
            objString.append("dynamicProperty = ");
            if (this.getDynamicProperty() == null) {
                objString.append("null");
            } else {
                objString.append("(vmodl.DynamicProperty) [\n");
                for (int i = 0; i < this.getDynamicProperty().length; ++i) {
                    objString.append("      ");
                    objString.append(StringUtil.indent((String)String.valueOf(this.getDynamicProperty()[i]), (boolean)true));
                    if (i < this.getDynamicProperty().length - 1) {
                        objString.append(",");
                    }
                    objString.append("\n");
                }
                objString.append("   ");
                objString.append("]");
            }
            objString.append(",\n");
            objString.append("   ");
            objString.append("fault = ");
            if (this.getFault() == null) {
                objString.append("null");
            } else {
                objString.append(StringUtil.indent((String)String.valueOf(this.getFault()), (boolean)false));
            }
            objString.append(",\n");
            objString.append("   ");
            objString.append("startTimestamp = ");
            objString.append(this.getStartTimestamp());
            objString.append(",\n");
            objString.append("   ");
            objString.append("completeTimestamp = ");
            objString.append(this.getCompleteTimestamp());
            objString.append("\n}");
            return objString.toString();
        }
    }
}

