/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.binding.dr.storage;

import com.vmware.vim.binding.dr.storage.AdapterConnectionPrompt;
import com.vmware.vim.binding.dr.storage.LocalizableString;
import com.vmware.vim.binding.dr.version.version0;
import com.vmware.vim.binding.dr.version.version19;
import com.vmware.vim.binding.impl.vmodl.DynamicDataImpl;
import com.vmware.vim.binding.vmodl.ManagedObject;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.data;
import com.vmware.vim.binding.vmodl.faults;
import com.vmware.vim.binding.vmodl.fullyQualifiedVmodlName;
import com.vmware.vim.binding.vmodl.list;
import com.vmware.vim.binding.vmodl.managed;
import com.vmware.vim.binding.vmodl.managedObjectType;
import com.vmware.vim.binding.vmodl.map;
import com.vmware.vim.binding.vmodl.name;
import com.vmware.vim.binding.vmodl.optional;
import com.vmware.vim.binding.vmodl.privilege;
import com.vmware.vim.binding.vmodl.propertyOrder;
import com.vmware.vim.binding.vmodl.readonly;
import com.vmware.vim.binding.vmodl.task;
import com.vmware.vim.binding.vmodl.versionClass;
import com.vmware.vim.binding.vmodl.wsdlName;
import com.vmware.vim.vmomi.core.Future;
import com.vmware.vim.vmomi.core.util.StringUtil;

@fullyQualifiedVmodlName(value="dr.storage.StorageAdapter")
@managed
@versionClass(value=version0.class)
@wsdlName(value="DrStorageStorageAdapter")
public interface StorageAdapter
extends ManagedObject {
    @readonly
    @name(value="info")
    @versionClass(value=version0.class)
    public void getInfo(Future<Info> var1);

    @readonly
    @name(value="peer")
    @versionClass(value=version0.class)
    @optional
    @map
    public void getPeer(@optional Future<Peer[]> var1);

    @readonly
    @name(value="replicationSoftware")
    @versionClass(value=version0.class)
    @optional
    @list
    public void getReplicationSoftware(@optional Future<ReplicationSoftware[]> var1);

    @readonly
    @name(value="arrayModel")
    @versionClass(value=version0.class)
    @optional
    @list
    public void getArrayModel(@optional Future<ArrayModel[]> var1);

    @readonly
    @name(value="supportedCommand")
    @versionClass(value=version0.class)
    @optional
    @list
    public void getSupportedCommand(@optional Future<Command[]> var1);

    @readonly
    @name(value="features")
    @versionClass(value=version0.class)
    public void getFeatures(Future<Features> var1);

    @readonly
    @name(value="connectionPrompt")
    @versionClass(value=version0.class)
    @optional
    @list
    public void getConnectionPrompt(@optional Future<AdapterConnectionPrompt[]> var1);

    @readonly
    @name(value="reloadFault")
    @versionClass(value=version0.class)
    @optional
    public void getReloadFault(@optional Future<Exception> var1);

    @readonly
    @name(value="reloadTask")
    @versionClass(value=version0.class)
    @optional
    @managedObjectType(value="com.vmware.vim.binding.vim.Task")
    public void getReloadTask(@optional @managedObjectType(value="com.vmware.vim.binding.vim.Task") Future<ManagedObjectReference> var1);

    @versionClass(value=version0.class)
    @wsdlName(value="StorageAdapterReload_Task")
    @privilege(value="VcDr.Storage.com.vmware.vcDr.Configure")
    @task
    @faults(value={"DrStorageFaultAdapterFault", "DrStorageFaultCannotLoadAdapter", "TaskInProgress"})
    public void reload(@managedObjectType(value="com.vmware.vim.binding.vim.Task") Future<ManagedObjectReference> var1);

    @versionClass(value=version0.class)
    @wsdlName(value="DrStorageStorageAdapterFeatures")
    @data
    @propertyOrder(value={"multiArrayDiscovery", "consistencyGroups", "dynamicAccessRestriction", "stretchedStorageSupport", "protocol", "deviceIdentification", "nvmeDeviceIdentification", "oneLunPerIScsiTarget", "syncLocation", "reverseReplicationLocation", "restoreReplicationLocation", "locale", "deviceCustomProperty", "quiescedVmSnapshotPattern"})
    public static class Features
    extends DynamicDataImpl {
        private static final long serialVersionUID = 1L;
        public boolean multiArrayDiscovery;
        public boolean consistencyGroups;
        public boolean dynamicAccessRestriction;
        public boolean stretchedStorageSupport;
        public Protocol[] protocol;
        public DeviceIdentification deviceIdentification;
        public NvmeDeviceIdentification nvmeDeviceIdentification;
        public boolean oneLunPerIScsiTarget;
        public ExecutionLocation syncLocation;
        public ExecutionLocation reverseReplicationLocation;
        public ExecutionLocation restoreReplicationLocation;
        public String[] locale;
        public DeviceCustomProperty[] deviceCustomProperty;
        public String quiescedVmSnapshotPattern;

        public Features() {
        }

        public Features(boolean multiArrayDiscovery, boolean consistencyGroups, boolean dynamicAccessRestriction, boolean stretchedStorageSupport, Protocol[] protocol, DeviceIdentification deviceIdentification, NvmeDeviceIdentification nvmeDeviceIdentification, boolean oneLunPerIScsiTarget, ExecutionLocation syncLocation, ExecutionLocation reverseReplicationLocation, ExecutionLocation restoreReplicationLocation, String[] locale, DeviceCustomProperty[] deviceCustomProperty, String quiescedVmSnapshotPattern) {
            this.multiArrayDiscovery = multiArrayDiscovery;
            this.consistencyGroups = consistencyGroups;
            this.dynamicAccessRestriction = dynamicAccessRestriction;
            this.stretchedStorageSupport = stretchedStorageSupport;
            this.protocol = protocol;
            this.deviceIdentification = deviceIdentification;
            this.nvmeDeviceIdentification = nvmeDeviceIdentification;
            this.oneLunPerIScsiTarget = oneLunPerIScsiTarget;
            this.syncLocation = syncLocation;
            this.reverseReplicationLocation = reverseReplicationLocation;
            this.restoreReplicationLocation = restoreReplicationLocation;
            this.locale = locale;
            this.deviceCustomProperty = deviceCustomProperty;
            this.quiescedVmSnapshotPattern = quiescedVmSnapshotPattern;
        }

        @versionClass(value=version0.class)
        public boolean isMultiArrayDiscovery() {
            return this.multiArrayDiscovery;
        }

        @versionClass(value=version0.class)
        public void setMultiArrayDiscovery(boolean multiArrayDiscovery) {
            this.multiArrayDiscovery = multiArrayDiscovery;
        }

        @versionClass(value=version0.class)
        public boolean isConsistencyGroups() {
            return this.consistencyGroups;
        }

        @versionClass(value=version0.class)
        public void setConsistencyGroups(boolean consistencyGroups) {
            this.consistencyGroups = consistencyGroups;
        }

        @versionClass(value=version0.class)
        public boolean isDynamicAccessRestriction() {
            return this.dynamicAccessRestriction;
        }

        @versionClass(value=version0.class)
        public void setDynamicAccessRestriction(boolean dynamicAccessRestriction) {
            this.dynamicAccessRestriction = dynamicAccessRestriction;
        }

        @versionClass(value=version0.class)
        public boolean isStretchedStorageSupport() {
            return this.stretchedStorageSupport;
        }

        @versionClass(value=version0.class)
        public void setStretchedStorageSupport(boolean stretchedStorageSupport) {
            this.stretchedStorageSupport = stretchedStorageSupport;
        }

        @list
        @optional
        @versionClass(value=version0.class)
        public Protocol[] getProtocol() {
            return this.protocol;
        }

        @list
        @optional
        @versionClass(value=version0.class)
        public void setProtocol(Protocol[] protocol) {
            this.protocol = protocol;
        }

        @optional
        @versionClass(value=version0.class)
        public DeviceIdentification getDeviceIdentification() {
            return this.deviceIdentification;
        }

        @optional
        @versionClass(value=version0.class)
        public void setDeviceIdentification(DeviceIdentification deviceIdentification) {
            this.deviceIdentification = deviceIdentification;
        }

        @optional
        @versionClass(value=version19.class)
        public NvmeDeviceIdentification getNvmeDeviceIdentification() {
            return this.nvmeDeviceIdentification;
        }

        @optional
        @versionClass(value=version19.class)
        public void setNvmeDeviceIdentification(NvmeDeviceIdentification nvmeDeviceIdentification) {
            this.nvmeDeviceIdentification = nvmeDeviceIdentification;
        }

        @versionClass(value=version0.class)
        public boolean isOneLunPerIScsiTarget() {
            return this.oneLunPerIScsiTarget;
        }

        @versionClass(value=version0.class)
        public void setOneLunPerIScsiTarget(boolean oneLunPerIScsiTarget) {
            this.oneLunPerIScsiTarget = oneLunPerIScsiTarget;
        }

        @versionClass(value=version0.class)
        public ExecutionLocation getSyncLocation() {
            return this.syncLocation;
        }

        @versionClass(value=version0.class)
        public void setSyncLocation(ExecutionLocation syncLocation) {
            this.syncLocation = syncLocation;
        }

        @versionClass(value=version0.class)
        public ExecutionLocation getReverseReplicationLocation() {
            return this.reverseReplicationLocation;
        }

        @versionClass(value=version0.class)
        public void setReverseReplicationLocation(ExecutionLocation reverseReplicationLocation) {
            this.reverseReplicationLocation = reverseReplicationLocation;
        }

        @versionClass(value=version0.class)
        public ExecutionLocation getRestoreReplicationLocation() {
            return this.restoreReplicationLocation;
        }

        @versionClass(value=version0.class)
        public void setRestoreReplicationLocation(ExecutionLocation restoreReplicationLocation) {
            this.restoreReplicationLocation = restoreReplicationLocation;
        }

        @map
        @optional
        @versionClass(value=version0.class)
        public String[] getLocale() {
            return this.locale;
        }

        @map
        @optional
        @versionClass(value=version0.class)
        public void setLocale(String[] locale) {
            this.locale = locale;
        }

        @map
        @optional
        @versionClass(value=version0.class)
        public DeviceCustomProperty[] getDeviceCustomProperty() {
            return this.deviceCustomProperty;
        }

        @map
        @optional
        @versionClass(value=version0.class)
        public void setDeviceCustomProperty(DeviceCustomProperty[] deviceCustomProperty) {
            this.deviceCustomProperty = deviceCustomProperty;
        }

        @optional
        @versionClass(value=version0.class)
        public String getQuiescedVmSnapshotPattern() {
            return this.quiescedVmSnapshotPattern;
        }

        @optional
        @versionClass(value=version0.class)
        public void setQuiescedVmSnapshotPattern(String quiescedVmSnapshotPattern) {
            this.quiescedVmSnapshotPattern = quiescedVmSnapshotPattern;
        }

        public String toString() {
            int i;
            StringBuilder objString = new StringBuilder(640);
            objString.append("(dr.storage.Features) {\n");
            objString.append("   ");
            objString.append("dynamicType = ");
            objString.append(this.getDynamicType());
            objString.append(",\n");
            objString.append("   ");
            objString.append("dynamicProperty = ");
            if (this.getDynamicProperty() == null) {
                objString.append("null");
            } else {
                objString.append("(vmodl.DynamicProperty) [\n");
                for (i = 0; i < this.getDynamicProperty().length; ++i) {
                    objString.append("      ");
                    objString.append(StringUtil.indent((String)String.valueOf(this.getDynamicProperty()[i]), (boolean)true));
                    if (i < this.getDynamicProperty().length - 1) {
                        objString.append(",");
                    }
                    objString.append("\n");
                }
                objString.append("   ");
                objString.append("]");
            }
            objString.append(",\n");
            objString.append("   ");
            objString.append("multiArrayDiscovery = ");
            objString.append(this.isMultiArrayDiscovery());
            objString.append(",\n");
            objString.append("   ");
            objString.append("consistencyGroups = ");
            objString.append(this.isConsistencyGroups());
            objString.append(",\n");
            objString.append("   ");
            objString.append("dynamicAccessRestriction = ");
            objString.append(this.isDynamicAccessRestriction());
            objString.append(",\n");
            objString.append("   ");
            objString.append("stretchedStorageSupport = ");
            objString.append(this.isStretchedStorageSupport());
            objString.append(",\n");
            objString.append("   ");
            objString.append("protocol = ");
            if (this.getProtocol() == null) {
                objString.append("null");
            } else {
                objString.append("(dr.storage.Protocol) [\n");
                for (i = 0; i < this.getProtocol().length; ++i) {
                    objString.append("      ");
                    objString.append((Object)this.getProtocol()[i]);
                    if (i < this.getProtocol().length - 1) {
                        objString.append(",");
                    }
                    objString.append("\n");
                }
                objString.append("   ");
                objString.append("]");
            }
            objString.append(",\n");
            objString.append("   ");
            objString.append("deviceIdentification = ");
            objString.append((Object)this.getDeviceIdentification());
            objString.append(",\n");
            objString.append("   ");
            objString.append("nvmeDeviceIdentification = ");
            objString.append((Object)this.getNvmeDeviceIdentification());
            objString.append(",\n");
            objString.append("   ");
            objString.append("oneLunPerIScsiTarget = ");
            objString.append(this.isOneLunPerIScsiTarget());
            objString.append(",\n");
            objString.append("   ");
            objString.append("syncLocation = ");
            objString.append((Object)this.getSyncLocation());
            objString.append(",\n");
            objString.append("   ");
            objString.append("reverseReplicationLocation = ");
            objString.append((Object)this.getReverseReplicationLocation());
            objString.append(",\n");
            objString.append("   ");
            objString.append("restoreReplicationLocation = ");
            objString.append((Object)this.getRestoreReplicationLocation());
            objString.append(",\n");
            objString.append("   ");
            objString.append("locale = ");
            if (this.getLocale() == null) {
                objString.append("null");
            } else {
                objString.append("(STRING) [\n");
                for (i = 0; i < this.getLocale().length; ++i) {
                    objString.append("      ");
                    objString.append(this.getLocale()[i]);
                    if (i < this.getLocale().length - 1) {
                        objString.append(",");
                    }
                    objString.append("\n");
                }
                objString.append("   ");
                objString.append("]");
            }
            objString.append(",\n");
            objString.append("   ");
            objString.append("deviceCustomProperty = ");
            if (this.getDeviceCustomProperty() == null) {
                objString.append("null");
            } else {
                objString.append("(dr.storage.DeviceCustomProperty) [\n");
                for (i = 0; i < this.getDeviceCustomProperty().length; ++i) {
                    objString.append("      ");
                    objString.append(StringUtil.indent((String)String.valueOf((Object)this.getDeviceCustomProperty()[i]), (boolean)true));
                    if (i < this.getDeviceCustomProperty().length - 1) {
                        objString.append(",");
                    }
                    objString.append("\n");
                }
                objString.append("   ");
                objString.append("]");
            }
            objString.append(",\n");
            objString.append("   ");
            objString.append("quiescedVmSnapshotPattern = ");
            objString.append(this.getQuiescedVmSnapshotPattern());
            objString.append("\n}");
            return objString.toString();
        }
    }

    @versionClass(value=version0.class)
    @wsdlName(value="DrStorageStorageAdapterDeviceCustomProperty")
    @data
    @propertyOrder(value={"key", "title"})
    public static class DeviceCustomProperty
    extends DynamicDataImpl {
        private static final long serialVersionUID = 1L;
        public String key;
        public LocalizableString title;

        public DeviceCustomProperty() {
        }

        public DeviceCustomProperty(String key, LocalizableString title) {
            this.key = key;
            this.title = title;
        }

        @versionClass(value=version0.class)
        public String getKey() {
            return this.key;
        }

        @versionClass(value=version0.class)
        public void setKey(String key) {
            this.key = key;
        }

        @versionClass(value=version0.class)
        public LocalizableString getTitle() {
            return this.title;
        }

        @versionClass(value=version0.class)
        public void setTitle(LocalizableString title) {
            this.title = title;
        }

        public String toString() {
            StringBuilder objString = new StringBuilder(160);
            objString.append("(dr.storage.DeviceCustomProperty) {\n");
            objString.append("   ");
            objString.append("dynamicType = ");
            objString.append(this.getDynamicType());
            objString.append(",\n");
            objString.append("   ");
            objString.append("dynamicProperty = ");
            if (this.getDynamicProperty() == null) {
                objString.append("null");
            } else {
                objString.append("(vmodl.DynamicProperty) [\n");
                for (int i = 0; i < this.getDynamicProperty().length; ++i) {
                    objString.append("      ");
                    objString.append(StringUtil.indent((String)String.valueOf(this.getDynamicProperty()[i]), (boolean)true));
                    if (i < this.getDynamicProperty().length - 1) {
                        objString.append(",");
                    }
                    objString.append("\n");
                }
                objString.append("   ");
                objString.append("]");
            }
            objString.append(",\n");
            objString.append("   ");
            objString.append("key = ");
            objString.append(this.getKey());
            objString.append(",\n");
            objString.append("   ");
            objString.append("title = ");
            if (this.getTitle() == null) {
                objString.append("null");
            } else {
                objString.append(StringUtil.indent((String)String.valueOf((Object)this.getTitle()), (boolean)false));
            }
            objString.append("\n}");
            return objString.toString();
        }
    }

    @versionClass(value=version19.class)
    @wsdlName(value="DrStorageStorageAdapterNvmeDeviceIdentification")
    public static enum NvmeDeviceIdentification {
        eui64,
        nguid,
        uuid,
        eui64Andnguid;

    }

    @versionClass(value=version0.class)
    @wsdlName(value="DrStorageStorageAdapterDeviceIdentification")
    public static enum DeviceIdentification {
        wwn,
        lun,
        lunPerIGroup,
        lunAndTarget,
        lunPerIGroupAndTarget;

    }

    @versionClass(value=version0.class)
    @wsdlName(value="DrStorageStorageAdapterExecutionLocation")
    public static enum ExecutionLocation {
        source,
        target;

    }

    @versionClass(value=version0.class)
    @wsdlName(value="DrStorageStorageAdapterProtocol")
    public static enum Protocol {
        fc,
        iScsi,
        nfs,
        nvme;

    }

    @versionClass(value=version0.class)
    @wsdlName(value="DrStorageStorageAdapterCommand")
    public static enum Command {
        queryInfo,
        queryCapabilities,
        queryErrorDefinitions,
        queryConnectionParameters,
        queryStrings,
        discoverArrays,
        discoverDevices,
        queryReplicationSettings,
        queryRecoveryPoints,
        queryDeviceDetails,
        syncOnce,
        querySyncStatus,
        checkTestFailoverStart,
        testFailoverStart,
        testFailoverStop,
        checkFailover,
        prepareFailover,
        failover,
        prepareReverseReplication,
        reverseReplication,
        prepareRestoreReplication,
        restoreReplication;

    }

    @versionClass(value=version0.class)
    @wsdlName(value="DrStorageStorageAdapterArrayModel")
    @data
    @propertyOrder(value={"name", "vendor"})
    public static class ArrayModel
    extends DynamicDataImpl {
        private static final long serialVersionUID = 1L;
        public String name;
        public LocalizableString vendor;

        public ArrayModel() {
        }

        public ArrayModel(String name2, LocalizableString vendor) {
            this.name = name2;
            this.vendor = vendor;
        }

        @versionClass(value=version0.class)
        public String getName() {
            return this.name;
        }

        @versionClass(value=version0.class)
        public void setName(String name2) {
            this.name = name2;
        }

        @versionClass(value=version0.class)
        public LocalizableString getVendor() {
            return this.vendor;
        }

        @versionClass(value=version0.class)
        public void setVendor(LocalizableString vendor) {
            this.vendor = vendor;
        }

        public String toString() {
            StringBuilder objString = new StringBuilder(160);
            objString.append("(dr.storage.ArrayModel) {\n");
            objString.append("   ");
            objString.append("dynamicType = ");
            objString.append(this.getDynamicType());
            objString.append(",\n");
            objString.append("   ");
            objString.append("dynamicProperty = ");
            if (this.getDynamicProperty() == null) {
                objString.append("null");
            } else {
                objString.append("(vmodl.DynamicProperty) [\n");
                for (int i = 0; i < this.getDynamicProperty().length; ++i) {
                    objString.append("      ");
                    objString.append(StringUtil.indent((String)String.valueOf(this.getDynamicProperty()[i]), (boolean)true));
                    if (i < this.getDynamicProperty().length - 1) {
                        objString.append(",");
                    }
                    objString.append("\n");
                }
                objString.append("   ");
                objString.append("]");
            }
            objString.append(",\n");
            objString.append("   ");
            objString.append("name = ");
            objString.append(this.getName());
            objString.append(",\n");
            objString.append("   ");
            objString.append("vendor = ");
            if (this.getVendor() == null) {
                objString.append("null");
            } else {
                objString.append(StringUtil.indent((String)String.valueOf((Object)this.getVendor()), (boolean)false));
            }
            objString.append("\n}");
            return objString.toString();
        }
    }

    @versionClass(value=version0.class)
    @wsdlName(value="DrStorageStorageAdapterReplicationSoftware")
    @data
    @propertyOrder(value={"name", "version"})
    public static class ReplicationSoftware
    extends DynamicDataImpl {
        private static final long serialVersionUID = 1L;
        public String name;
        public String version;

        public ReplicationSoftware() {
        }

        public ReplicationSoftware(String name2, String version) {
            this.name = name2;
            this.version = version;
        }

        @versionClass(value=version0.class)
        public String getName() {
            return this.name;
        }

        @versionClass(value=version0.class)
        public void setName(String name2) {
            this.name = name2;
        }

        @versionClass(value=version0.class)
        public String getVersion() {
            return this.version;
        }

        @versionClass(value=version0.class)
        public void setVersion(String version) {
            this.version = version;
        }

        public String toString() {
            StringBuilder objString = new StringBuilder(160);
            objString.append("(dr.storage.ReplicationSoftware) {\n");
            objString.append("   ");
            objString.append("dynamicType = ");
            objString.append(this.getDynamicType());
            objString.append(",\n");
            objString.append("   ");
            objString.append("dynamicProperty = ");
            if (this.getDynamicProperty() == null) {
                objString.append("null");
            } else {
                objString.append("(vmodl.DynamicProperty) [\n");
                for (int i = 0; i < this.getDynamicProperty().length; ++i) {
                    objString.append("      ");
                    objString.append(StringUtil.indent((String)String.valueOf(this.getDynamicProperty()[i]), (boolean)true));
                    if (i < this.getDynamicProperty().length - 1) {
                        objString.append(",");
                    }
                    objString.append("\n");
                }
                objString.append("   ");
                objString.append("]");
            }
            objString.append(",\n");
            objString.append("   ");
            objString.append("name = ");
            objString.append(this.getName());
            objString.append(",\n");
            objString.append("   ");
            objString.append("version = ");
            objString.append(this.getVersion());
            objString.append("\n}");
            return objString.toString();
        }
    }

    @versionClass(value=version0.class)
    @wsdlName(value="DrStorageStorageAdapterPeer")
    @data
    @propertyOrder(value={"key", "site", "adapter", "version", "reloadFault"})
    public static class Peer
    extends DynamicDataImpl {
        private static final long serialVersionUID = 1L;
        public ManagedObjectReference key;
        public ManagedObjectReference site;
        public ManagedObjectReference adapter;
        public String version;
        public Exception reloadFault;

        public Peer() {
        }

        public Peer(ManagedObjectReference key, ManagedObjectReference site, ManagedObjectReference adapter, String version, Exception reloadFault) {
            this.key = key;
            this.site = site;
            this.adapter = adapter;
            this.version = version;
            this.reloadFault = reloadFault;
        }

        @managedObjectType(value="com.vmware.vim.binding.dr.site.RemoteSite")
        @versionClass(value=version0.class)
        public ManagedObjectReference getKey() {
            return this.key;
        }

        @managedObjectType(value="com.vmware.vim.binding.dr.site.RemoteSite")
        @versionClass(value=version0.class)
        public void setKey(ManagedObjectReference key) {
            this.key = key;
        }

        @managedObjectType(value="com.vmware.vim.binding.dr.site.RemoteSite")
        @versionClass(value=version0.class)
        public ManagedObjectReference getSite() {
            return this.site;
        }

        @managedObjectType(value="com.vmware.vim.binding.dr.site.RemoteSite")
        @versionClass(value=version0.class)
        public void setSite(ManagedObjectReference site) {
            this.site = site;
        }

        @managedObjectType(value="com.vmware.vim.binding.dr.storage.StorageAdapter")
        @versionClass(value=version0.class)
        public ManagedObjectReference getAdapter() {
            return this.adapter;
        }

        @managedObjectType(value="com.vmware.vim.binding.dr.storage.StorageAdapter")
        @versionClass(value=version0.class)
        public void setAdapter(ManagedObjectReference adapter) {
            this.adapter = adapter;
        }

        @versionClass(value=version0.class)
        public String getVersion() {
            return this.version;
        }

        @versionClass(value=version0.class)
        public void setVersion(String version) {
            this.version = version;
        }

        @optional
        @versionClass(value=version0.class)
        public Exception getReloadFault() {
            return this.reloadFault;
        }

        @optional
        @versionClass(value=version0.class)
        public void setReloadFault(Exception reloadFault) {
            this.reloadFault = reloadFault;
        }

        public String toString() {
            StringBuilder objString = new StringBuilder(280);
            objString.append("(dr.storage.Peer) {\n");
            objString.append("   ");
            objString.append("dynamicType = ");
            objString.append(this.getDynamicType());
            objString.append(",\n");
            objString.append("   ");
            objString.append("dynamicProperty = ");
            if (this.getDynamicProperty() == null) {
                objString.append("null");
            } else {
                objString.append("(vmodl.DynamicProperty) [\n");
                for (int i = 0; i < this.getDynamicProperty().length; ++i) {
                    objString.append("      ");
                    objString.append(StringUtil.indent((String)String.valueOf(this.getDynamicProperty()[i]), (boolean)true));
                    if (i < this.getDynamicProperty().length - 1) {
                        objString.append(",");
                    }
                    objString.append("\n");
                }
                objString.append("   ");
                objString.append("]");
            }
            objString.append(",\n");
            objString.append("   ");
            objString.append("key = ");
            if (this.getKey() == null) {
                objString.append("null");
            } else {
                objString.append(StringUtil.indent((String)String.valueOf(this.getKey()), (boolean)false));
            }
            objString.append(",\n");
            objString.append("   ");
            objString.append("site = ");
            if (this.getSite() == null) {
                objString.append("null");
            } else {
                objString.append(StringUtil.indent((String)String.valueOf(this.getSite()), (boolean)false));
            }
            objString.append(",\n");
            objString.append("   ");
            objString.append("adapter = ");
            if (this.getAdapter() == null) {
                objString.append("null");
            } else {
                objString.append(StringUtil.indent((String)String.valueOf(this.getAdapter()), (boolean)false));
            }
            objString.append(",\n");
            objString.append("   ");
            objString.append("version = ");
            objString.append(this.getVersion());
            objString.append(",\n");
            objString.append("   ");
            objString.append("reloadFault = ");
            if (this.getReloadFault() == null) {
                objString.append("null");
            } else {
                objString.append(StringUtil.indent((String)String.valueOf(this.getReloadFault()), (boolean)false));
            }
            objString.append("\n}");
            return objString.toString();
        }
    }

    @versionClass(value=version0.class)
    @wsdlName(value="DrStorageStorageAdapterInfo")
    @data
    @propertyOrder(value={"uuid", "installPath", "name", "version", "vendor", "helpUrl"})
    public static class Info
    extends DynamicDataImpl {
        private static final long serialVersionUID = 1L;
        public String uuid;
        public String installPath;
        public LocalizableString name;
        public String version;
        public LocalizableString vendor;
        public String helpUrl;

        public Info() {
        }

        public Info(String uuid, String installPath, LocalizableString name2, String version, LocalizableString vendor, String helpUrl) {
            this.uuid = uuid;
            this.installPath = installPath;
            this.name = name2;
            this.version = version;
            this.vendor = vendor;
            this.helpUrl = helpUrl;
        }

        @versionClass(value=version0.class)
        public String getUuid() {
            return this.uuid;
        }

        @versionClass(value=version0.class)
        public void setUuid(String uuid) {
            this.uuid = uuid;
        }

        @versionClass(value=version0.class)
        public String getInstallPath() {
            return this.installPath;
        }

        @versionClass(value=version0.class)
        public void setInstallPath(String installPath) {
            this.installPath = installPath;
        }

        @versionClass(value=version0.class)
        public LocalizableString getName() {
            return this.name;
        }

        @versionClass(value=version0.class)
        public void setName(LocalizableString name2) {
            this.name = name2;
        }

        @versionClass(value=version0.class)
        public String getVersion() {
            return this.version;
        }

        @versionClass(value=version0.class)
        public void setVersion(String version) {
            this.version = version;
        }

        @versionClass(value=version0.class)
        public LocalizableString getVendor() {
            return this.vendor;
        }

        @versionClass(value=version0.class)
        public void setVendor(LocalizableString vendor) {
            this.vendor = vendor;
        }

        @optional
        @versionClass(value=version0.class)
        public String getHelpUrl() {
            return this.helpUrl;
        }

        @optional
        @versionClass(value=version0.class)
        public void setHelpUrl(String helpUrl) {
            this.helpUrl = helpUrl;
        }

        public String toString() {
            StringBuilder objString = new StringBuilder(320);
            objString.append("(dr.storage.Info) {\n");
            objString.append("   ");
            objString.append("dynamicType = ");
            objString.append(this.getDynamicType());
            objString.append(",\n");
            objString.append("   ");
            objString.append("dynamicProperty = ");
            if (this.getDynamicProperty() == null) {
                objString.append("null");
            } else {
                objString.append("(vmodl.DynamicProperty) [\n");
                for (int i = 0; i < this.getDynamicProperty().length; ++i) {
                    objString.append("      ");
                    objString.append(StringUtil.indent((String)String.valueOf(this.getDynamicProperty()[i]), (boolean)true));
                    if (i < this.getDynamicProperty().length - 1) {
                        objString.append(",");
                    }
                    objString.append("\n");
                }
                objString.append("   ");
                objString.append("]");
            }
            objString.append(",\n");
            objString.append("   ");
            objString.append("uuid = ");
            objString.append(this.getUuid());
            objString.append(",\n");
            objString.append("   ");
            objString.append("installPath = ");
            objString.append(this.getInstallPath());
            objString.append(",\n");
            objString.append("   ");
            objString.append("name = ");
            if (this.getName() == null) {
                objString.append("null");
            } else {
                objString.append(StringUtil.indent((String)String.valueOf((Object)this.getName()), (boolean)false));
            }
            objString.append(",\n");
            objString.append("   ");
            objString.append("version = ");
            objString.append(this.getVersion());
            objString.append(",\n");
            objString.append("   ");
            objString.append("vendor = ");
            if (this.getVendor() == null) {
                objString.append("null");
            } else {
                objString.append(StringUtil.indent((String)String.valueOf((Object)this.getVendor()), (boolean)false));
            }
            objString.append(",\n");
            objString.append("   ");
            objString.append("helpUrl = ");
            objString.append(this.getHelpUrl());
            objString.append("\n}");
            return objString.toString();
        }
    }
}

