/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.topology.impl.lspp.monitor.model;

import com.vmware.dr.ui.tools.utilities.HashUtils;
import com.vmware.dr.ui.tools.utilities.StringUtils;
import com.vmware.srm.client.topology.impl.lspp.monitor.model.LsppService;
import com.vmware.vim.binding.lookup.ServiceRegistration;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LsppNode {
    private static final Logger LOGGER = LoggerFactory.getLogger(LsppNode.class);
    private final String _id;
    private final String _siteId;
    private final Map<LsppService, LsppService> _services = new HashMap<LsppService, LsppService>();
    private transient Integer _hashCode;

    public static LsppService createService(ServiceRegistration.Info info) {
        if (info == null) {
            throw new IllegalArgumentException("info");
        }
        String id = info.getServiceId();
        String serviceVersion = info.getServiceVersion();
        String serviceNameDefault = info.getServiceNameDefault();
        String serviceNameResourceKey = info.serviceNameResourceKey;
        String serviceDescriptionResourceKey = info.serviceDescriptionResourceKey;
        String siteId = info.getSiteId();
        String nodeId = info.getNodeId();
        String ownerId = info.getOwnerId();
        ServiceRegistration.ServiceType serviceType = info.getServiceType() == null ? new ServiceRegistration.ServiceType() : info.getServiceType();
        String product = serviceType.getProduct();
        String type = serviceType.getType();
        ServiceRegistration.Attribute[] attrs = info.getServiceAttributes();
        ServiceRegistration.Endpoint[] eps = info.getServiceEndpoints();
        try {
            return new LsppService(id, serviceVersion, serviceNameDefault, serviceNameResourceKey, serviceDescriptionResourceKey, nodeId, siteId, ownerId, product, type, attrs == null ? Collections.emptyList() : Arrays.asList(attrs), eps == null ? Collections.emptyList() : Arrays.asList(eps));
        }
        catch (IllegalArgumentException iae) {
            LOGGER.error("Failed to create LsppService from " + String.valueOf(info), (Throwable)iae);
            return null;
        }
    }

    public LsppNode(String id, String siteId) {
        if (id == null) {
            throw new IllegalArgumentException("id");
        }
        if (siteId == null) {
            throw new IllegalArgumentException("siteId");
        }
        this._id = id;
        this._siteId = siteId;
    }

    public String getId() {
        return this._id;
    }

    public String getSiteId() {
        return this._siteId;
    }

    public Set<LsppService> getServices() {
        return Collections.unmodifiableSet(this._services.keySet());
    }

    public int hashCode() {
        if (this._hashCode == null) {
            this._hashCode = HashUtils.getHashCode((Object[])new Object[]{this._id, this._siteId});
        }
        return this._hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LsppNode)) {
            return false;
        }
        LsppNode other = (LsppNode)obj;
        return HashUtils.areEqual((Object)this._id, (Object)other._id) && HashUtils.areEqual((Object)this._siteId, (Object)other._siteId);
    }

    public String toString() {
        HashMap<String, Object> members = new HashMap<String, Object>();
        members.put("_id", this._id);
        members.put("_siteId", this._siteId);
        members.put("_services", this._services.keySet());
        return StringUtils.getToStringValue((String)"LsppNode", members);
    }
}

